/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.PairLR;
import edu.buffalo.cse.sneps3.gui.Slot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Frame {
    public static Map<Quantification, String> quantstr = new HashMap<Quantification, String>(){
        {
            this.put(Quantification.None, "");
            this.put(Quantification.Arbitrary, "every");
            this.put(Quantification.Indefinite, "some");
        }
    };
    private Caseframe cf;
    private ArrayList<PairLR<Slot, Object>> sf;
    private Quantification quant;
    private String varName;
    private String depVar;
    private String fsym;

    public Frame(Caseframe caseframe, String string, ArrayList<Slot> arrayList, ArrayList<Object> arrayList2, Quantification quantification, String string2, String string3) {
        this(caseframe, arrayList, arrayList2, quantification, string2, string3);
        this.fsym = string;
    }

    public Frame(Caseframe caseframe, ArrayList<Slot> arrayList, ArrayList<Object> arrayList2, Quantification quantification, String string, String string2) {
        this(caseframe, arrayList, arrayList2);
        this.quant = quantification;
        this.varName = string;
        this.depVar = string2;
    }

    public Frame(Caseframe caseframe, String string, ArrayList<Slot> arrayList, ArrayList<Object> arrayList2) {
        this(caseframe, arrayList, arrayList2);
        this.fsym = string;
    }

    public Frame(Caseframe caseframe, ArrayList<Slot> arrayList, ArrayList<Object> arrayList2) {
        this.cf = caseframe;
        this.sf = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.sf.add(new PairLR<Slot, Object>(arrayList.get(i), arrayList2.get(i)));
        }
        this.quant = Quantification.None;
    }

    public Quantification getQuantification() {
        return this.quant;
    }

    public String getVariable() {
        return this.varName;
    }

    public String getDepVar() {
        return this.depVar;
    }

    private ArrayList<PairLR<Slot, Object>> getAll(Slot slot) {
        ArrayList<PairLR<Slot, Object>> arrayList = new ArrayList<PairLR<Slot, Object>>();
        for (PairLR<Slot, Object> pairLR : this.sf) {
            if (pairLR.getLeft() != slot) continue;
            arrayList.add(pairLR);
        }
        return arrayList;
    }

    private ArrayList<PairLR<Slot, Object>> getVarShare(Frame frame, ArrayList<PairLR<Slot, Object>> arrayList) {
        ArrayList<PairLR<Slot, Object>> arrayList2 = new ArrayList<PairLR<Slot, Object>>();
        for (PairLR<Slot, Object> pairLR : arrayList) {
            if (!(pairLR.getRight() instanceof Frame) || !((Frame)pairLR.getRight()).getVariable().equals(frame.getVariable()) || !(((Frame)pairLR.getRight()).getDepVar() == null ? frame.getDepVar() == null : ((Frame)pairLR.getRight()).getDepVar().equals(frame.getDepVar()))) continue;
            arrayList2.add(pairLR);
        }
        return arrayList2;
    }

    private String buildVarString(Frame frame) {
        if (frame.quant == Quantification.None) {
            return "";
        }
        if (frame.quant == Quantification.Arbitrary) {
            return "(every " + frame.getVariable();
        }
        return "(some " + frame.getVariable() + "(" + frame.getDepVar() + ") ";
    }

    private String buildFillers(ArrayList<PairLR<Slot, Object>> arrayList, boolean bl) {
        String string = "";
        if (!bl || arrayList.size() == 1) {
            for (PairLR<Slot, Object> pairLR : arrayList) {
                Object object = pairLR.getRight();
                if (object instanceof Frame) {
                    string = string + " " + ((Frame)object).toString();
                    continue;
                }
                string = string + " " + object.toString();
            }
        } else {
            ArrayList<PairLR<Slot, Object>> arrayList2 = new ArrayList<PairLR<Slot, Object>>();
            string = string + " (setof ";
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object = arrayList.get(i).getRight();
                if (arrayList2.contains(object)) continue;
                if (object instanceof Frame) {
                    Frame frame = (Frame)object;
                    Quantification quantification = frame.getQuantification();
                    if (quantification != Quantification.None) {
                        ArrayList<PairLR<Slot, Object>> arrayList3 = this.getVarShare(frame, arrayList);
                        arrayList2.addAll(arrayList3);
                        string = string + this.buildVarString(frame);
                        for (PairLR<Slot, Object> pairLR : arrayList3) {
                            string = string + ((Frame)pairLR.getRight()).buildNoQuantString();
                        }
                        string = string + ")";
                        continue;
                    }
                    string = string + frame.toString();
                    continue;
                }
                string = string + object.toString();
            }
            string = string + ")";
        }
        return string;
    }

    protected String buildNoQuantString() {
        String string = this.cf.name;
        for (Slot slot : this.cf.slots) {
            if (this.cf.slots.size() > 1) {
                string = string + this.buildFillers(this.getAll(slot), true);
                continue;
            }
            string = string + this.buildFillers(this.getAll(slot), false);
        }
        return "";
    }

    public String toString() {
        return this.buildVarString(this) + this.buildNoQuantString() + ")";
    }

    public static enum Quantification {
        None,
        Arbitrary,
        Indefinite;

    }
}

