/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDist;
import edu.buffalo.cse.sneps3.gui.AddToKBPanel;
import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.Context;
import edu.buffalo.cse.sneps3.gui.CreateContextForm;
import edu.buffalo.cse.sneps3.gui.DefineCaseframeForm;
import edu.buffalo.cse.sneps3.gui.DemoMode;
import edu.buffalo.cse.sneps3.gui.FindQuery3;
import edu.buffalo.cse.sneps3.gui.GlobalGraphFilter;
import edu.buffalo.cse.sneps3.gui.IController;
import edu.buffalo.cse.sneps3.gui.JungGraphEdge;
import edu.buffalo.cse.sneps3.gui.JungGraphNode;
import edu.buffalo.cse.sneps3.gui.JungGraphPanel;
import edu.buffalo.cse.sneps3.gui.JungRestrictionGraphEdge;
import edu.buffalo.cse.sneps3.gui.Model;
import edu.buffalo.cse.sneps3.gui.PluginPanel;
import edu.buffalo.cse.sneps3.gui.REPLPanel;
import edu.buffalo.cse.sneps3.gui.SemanticType;
import edu.buffalo.cse.sneps3.gui.Slot;
import edu.buffalo.cse.sneps3.gui.pdfViewer;
import edu.uci.ics.jung.algorithms.layout.util.Relaxer;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.Layer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.freehep.util.export.ExportDialog;

public class GUI2
extends JFrame
implements IController {
    public static final boolean DEBUG = false;
    public static Model model = new Model();
    private static GUI2 instance;
    DefaultComboBoxModel contextModel = new DefaultComboBoxModel();
    CreateContextForm ccf;
    DefineCaseframeForm caseFrameForm = new DefineCaseframeForm();
    int lastReplSize = 0;
    boolean established = false;
    String fullkb = "";
    String defs = "";
    String asserts = "";
    String sendQueue = "";
    ArrayList<String> sendHistory = new ArrayList();
    File currentDir = new File(".");
    boolean showNewAssertions = true;
    Map<String, JungGraphNode> nodeName_node_map = new HashMap<String, JungGraphNode>();
    ArrayList<JungGraphEdge> edges = new ArrayList();
    ExportDialog export = new ExportDialog();
    boolean doingSave = false;
    static ArrayList<Caseframe> hide_cf_list;
    DirectedSparseMultigraph<JungGraphNode, JungGraphEdge> dsg = new DirectedSparseMultigraph();
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JCheckBoxMenuItem jCheckBoxMenuItem_antialias;
    private JCheckBoxMenuItem jCheckBoxMenuItem_autoRefresh;
    private JCheckBoxMenuItem jCheckBoxMenuItem_autoRelayout;
    private JCheckBoxMenuItem jCheckBoxMenuItem_showNewAssertions;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenu7;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JMenuItem jMenuItem_refreshGraph;
    private JMenuItem jMenuItem_relayout;
    private JMenu jMenu_globablFilter;
    private JPopupMenu.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JToggleButton jToggleButton_repl;
    private JToolBar jToolBar1;
    private JungGraphPanel jungGraphPanel1;
    private JMenuItem loadDemo;
    private JMenuItem menuItem_guidocs;
    private JMenuItem menuItem_sneps3manual;
    private PluginPanel pluginPanel1;
    private REPLPanel rEPLPanel1;
    private JMenuItem saveCurrentKB;
    private JMenuItem saveKBasDemo;
    private JSplitPane splitPane_left;

    public GUI2() {
        this.initComponents();
        this.setTitle("Sneps 3 GUI Version 2013.06.07");
        this.setLayout(new BorderLayout());
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.jSplitPane1, "Center");
        model.registerView(this);
        this.setVisible(true);
        this.setInstance();
        KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 83) {
                    if (GUI2.this.doingSave) {
                        return false;
                    }
                    GUI2.this.doingSave = true;
                    Component component = keyEvent.getComponent();
                    while (component.getParent() != null) {
                        component = component.getParent();
                    }
                    GUI2.this.export.showExportDialog(component, "Take Screenshot...", component, "guiscr");
                    GUI2.this.doingSave = false;
                    return true;
                }
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                GUI2.this.makeLispCall("(in-package sneps)");
                GUI2.this.makeLispCall("(setf *sneps-gui-ptr* nil)");
            }
        }));
        this.jMenuItem12.setEnabled(false);
    }

    private void setInstance() {
        instance = this;
    }

    public static GUI2 getInstance() {
        return instance;
    }

    public void setREPLVisibility(boolean bl) {
        if (bl) {
            this.splitPane_left.setDividerLocation(this.lastReplSize);
            this.splitPane_left.setDividerSize(6);
        } else {
            this.lastReplSize = this.splitPane_left.getDividerLocation();
            this.splitPane_left.setDividerLocation(this.getHeight());
            this.splitPane_left.setDividerSize(0);
        }
    }

    public void connectToLisp(int n, int n2) {
        JavaLinkDist.connect("localhost", n, "localhost", 6080, 1000, 300);
    }

    public void startup() {
        this.rEPLPanel1.makeLispCall("(in-package :snuser)");
    }

    public boolean checkParenMatch(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (!(cArray[i] != '|' || i != 0 && cArray[i - 1] == '\\' || bl2)) {
                boolean bl3 = bl = !bl;
            }
            if (!(cArray[i] != '\"' || i != 0 && cArray[i - 1] == '\\' || bl)) {
                boolean bl4 = bl2 = !bl2;
            }
            if (bl || bl2) continue;
            if (cArray[i] == '(') {
                ++n;
                continue;
            }
            if (cArray[i] != ')') continue;
            ++n2;
        }
        return n == n2;
    }

    public void makeLispCall(String string) {
        if (string.trim().equals("") || string.trim().charAt(0) == ';') {
            return;
        }
        this.sendQueue = this.sendQueue + string;
        if (this.checkParenMatch(this.sendQueue)) {
            this.sendHistory.add(this.sendQueue.toString());
            this.rEPLPanel1.makeLispCall(this.sendQueue);
            this.fullkb = this.fullkb + this.sendQueue + '\n';
            if (this.sendQueue.contains("defineCaseframe") || this.sendQueue.contains("defineSlot") || this.sendQueue.contains("defineType")) {
                this.defs = this.defs + this.sendQueue + '\n';
            } else {
                this.asserts = this.asserts + this.sendQueue + '\n';
            }
            this.sendQueue = "";
        }
    }

    public void reinitialize(boolean bl) {
        this.jungGraphPanel1.reinitialize();
        this.nodeName_node_map.clear();
        this.edges.clear();
        hide_cf_list.clear();
        model.clearContexts();
        if (bl) {
            model.clearCaseframes();
            model.clearSlots();
        }
        this.jTabbedPane1.setTitleAt(0, "Graph View");
        this.asserts = "";
    }

    public static ArrayList<Caseframe> getHideCFList() {
        return hide_cf_list;
    }

    public void updateContexts(ArrayList arrayList) {
    }

    public void updateSemanticTypes(ArrayList arrayList) {
        ArrayList<SemanticType> arrayList2 = new ArrayList<SemanticType>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof SemanticType)) continue;
            arrayList2.add((SemanticType)arrayList.get(i));
        }
        model.recvUpdatedTypes(arrayList2);
    }

    public void addCaseframe(Caseframe caseframe) {
        model.addNewCaseframe(caseframe);
    }

    public void addSlot(Slot slot) {
        model.addNewSlot(slot);
    }

    public void addSemanticType(String string, ArrayList arrayList) {
        ArrayList<SemanticType> arrayList2 = new ArrayList<SemanticType>();
        for (SemanticType semanticType : GUI2.model.types) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((String)arrayList.get(i)).equals(semanticType.name)) continue;
                arrayList2.add(semanticType);
            }
        }
        model.addNewType(new SemanticType(string, arrayList2));
    }

    public void addContext(String string, ArrayList arrayList) {
        ArrayList<Context> arrayList2 = new ArrayList<Context>();
        for (Context context : GUI2.model.contexts) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((String)arrayList.get(i)).equals(context.name)) continue;
                arrayList2.add(context);
            }
        }
        model.addNewContext(new Context(string, arrayList2));
    }

    public void selectCurrentContext(String string) {
        for (Context context : GUI2.model.contexts) {
            if (!context.name.equals(string)) continue;
            model.selectCurrentContext(context);
            return;
        }
    }

    public void createNewGraph() {
        this.dsg = new DirectedSparseMultigraph();
    }

    public void setAddMode(boolean bl) {
        if (bl) {
            this.jungGraphPanel1.layout.lock(true);
            Relaxer relaxer = this.jungGraphPanel1.vv.getModel().getRelaxer();
            relaxer.pause();
        } else {
            this.jungGraphPanel1.layout.initialize();
            Relaxer relaxer = this.jungGraphPanel1.vv.getModel().getRelaxer();
            relaxer.resume();
            this.jungGraphPanel1.layout.lock(false);
        }
    }

    public void setShowNewAssertions(boolean bl) {
        this.showNewAssertions = bl;
    }

    public void displayNodes(ArrayList arrayList) {
        this.jungGraphPanel1.displayNodeSet(arrayList);
        this.jungGraphPanel1.displayGraph(this.jungGraphPanel1.getGraph());
    }

    public void addCustomVertex(String string, String string2, String string3, ArrayList arrayList, boolean bl, double d) {
        string2 = string2.substring(string2.indexOf(45) + 1);
        SemanticType semanticType = null;
        for (SemanticType object2 : GUI2.model.types) {
            if (!object2.getName().equalsIgnoreCase(string2)) continue;
            semanticType = object2;
        }
        Object object3 = null;
        if (string3 != null && !string3.equals("nil")) {
            object3 = model.getCaseframeByNameAndSlots(string3, arrayList);
        }
        JungGraphNode jungGraphNode = new JungGraphNode(string, semanticType, (Caseframe)object3, bl, d);
        JungGraphNode jungGraphNode2 = this.nodeName_node_map.get(string);
        if (jungGraphNode2 != null) {
            if (jungGraphNode2.asserted != bl) {
                jungGraphNode2.asserted = bl;
            }
            if (this.showNewAssertions && !jungGraphNode2.isVisible()) {
                this.jungGraphPanel1.showNode(jungGraphNode2);
            }
            return;
        }
        this.nodeName_node_map.put(jungGraphNode.getName(), jungGraphNode);
        if (this.showNewAssertions) {
            this.jungGraphPanel1.addVertex(jungGraphNode);
        } else {
            jungGraphNode.visible = false;
            this.jungGraphPanel1.showing_all = false;
        }
    }

    public void unassert(String string) {
        JungGraphNode jungGraphNode = this.findGraphNode(string);
        if (jungGraphNode != null) {
            jungGraphNode.asserted = false;
        }
    }

    public void addStringEdge(String string, String string2, String string3) {
        JungGraphNode jungGraphNode = this.findGraphNode(string);
        JungGraphNode jungGraphNode2 = this.findGraphNode(string2);
        if (jungGraphNode == null || jungGraphNode2 == null) {
            return;
        }
        JungGraphEdge jungGraphEdge = new JungGraphEdge(string3, jungGraphNode, jungGraphNode2);
        for (JungGraphEdge jungGraphEdge2 : jungGraphNode.getDownCableset()) {
            if (jungGraphEdge2.to != jungGraphNode2 || !jungGraphEdge2.toString().equals(jungGraphEdge.toString())) continue;
            return;
        }
        jungGraphNode.addToDownCableset(jungGraphEdge);
        jungGraphNode2.addToUpCableset(jungGraphEdge);
        if (this.showNewAssertions) {
            this.dsg.addEdge((Object)jungGraphEdge, (Object)jungGraphNode, (Object)jungGraphNode2, EdgeType.DIRECTED);
        }
        this.edges.add(jungGraphEdge);
    }

    public void addArbRestrictionEdge(String string, String string2) {
        JungGraphNode jungGraphNode = this.findGraphNode(string);
        JungGraphNode jungGraphNode2 = this.findGraphNode(string2);
        JungRestrictionGraphEdge jungRestrictionGraphEdge = new JungRestrictionGraphEdge("Every", jungGraphNode, jungGraphNode2);
        for (JungGraphEdge jungGraphEdge : this.dsg.getEdges()) {
            if (!jungGraphEdge.equals(jungRestrictionGraphEdge)) continue;
            return;
        }
        this.dsg.addEdge((Object)jungRestrictionGraphEdge, (Object)jungGraphNode, (Object)jungGraphNode2, EdgeType.DIRECTED);
    }

    public void addIndRestrictionEdge(String string, String string2) {
        JungGraphNode jungGraphNode = this.findGraphNode(string);
        JungGraphNode jungGraphNode2 = this.findGraphNode(string2);
        if (jungGraphNode != null && jungGraphNode2 != null) {
            JungRestrictionGraphEdge jungRestrictionGraphEdge = new JungRestrictionGraphEdge("Some", jungGraphNode, jungGraphNode2);
            for (JungGraphEdge jungGraphEdge : this.dsg.getEdges()) {
                if (!jungGraphEdge.equals(jungRestrictionGraphEdge)) continue;
                return;
            }
            this.dsg.addEdge((Object)jungRestrictionGraphEdge, (Object)this.findGraphNode(string), (Object)this.findGraphNode(string2), EdgeType.DIRECTED);
        }
    }

    public void addDepRestrictionEdge(String string, String string2) {
        JungGraphNode jungGraphNode = this.findGraphNode(string);
        JungGraphNode jungGraphNode2 = this.findGraphNode(string2);
        if (jungGraphNode != null && jungGraphNode2 != null) {
            JungRestrictionGraphEdge jungRestrictionGraphEdge = new JungRestrictionGraphEdge("Depends", jungGraphNode, jungGraphNode2);
            for (JungGraphEdge jungGraphEdge : this.dsg.getEdges()) {
                if (!jungGraphEdge.equals(jungRestrictionGraphEdge)) continue;
                return;
            }
            this.dsg.addEdge((Object)jungRestrictionGraphEdge, (Object)this.findGraphNode(string), (Object)this.findGraphNode(string2), EdgeType.DIRECTED);
        }
    }

    public JungGraphNode findGraphNode(String string) {
        return this.nodeName_node_map.get(string);
    }

    public void displayGraph() {
        this.jungGraphPanel1.displayGraph(this.dsg);
    }

    public void relayoutGraph() {
        this.jungGraphPanel1.displayGraph(this.jungGraphPanel1.getGraph());
    }

    public void disableGraphRefresh() {
        this.jCheckBoxMenuItem_autoRefresh.setSelected(false);
        this.makeLispCall("(setf sneps3::*auto-refresh-graph* nil)");
    }

    public void enableGraphRefresh() {
        this.jCheckBoxMenuItem_autoRefresh.setSelected(true);
        this.makeLispCall("(setf sneps3::*auto-refresh-graph* t)");
        this.makeLispCall("(sneps3::generate-graph)");
    }

    public void disableGraphRelayout() {
        this.jCheckBoxMenuItem_autoRelayout.setSelected(false);
        this.makeLispCall("(setf sneps3::*auto-relayout-graph* nil)");
    }

    public void enableGraphRelayout() {
        this.jCheckBoxMenuItem_autoRelayout.setSelected(true);
        this.makeLispCall("(setf sneps3::*auto-relayout-graph* t)");
    }

    public Collection getNodes() {
        return this.jungGraphPanel1.dsg.getVertices();
    }

    public DirectedSparseMultigraph getGraph() {
        return this.jungGraphPanel1.dsg;
    }

    public void enableFindButton() {
    }

    public void findGraphResults(ArrayList arrayList) {
        if (this.jungGraphPanel1.isShowingAll()) {
            this.jungGraphPanel1.displayOnlyNodeSet(arrayList);
        } else {
            this.jungGraphPanel1.displayNodeSet(arrayList);
        }
    }

    public Map<String, JungGraphNode> getNodeName_node_map() {
        return this.nodeName_node_map;
    }

    public ArrayList<JungGraphEdge> getEdge_list() {
        return this.edges;
    }

    public void loadToKB(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.setAddMode(true);
            while ((string = bufferedReader.readLine()) != null) {
                this.makeLispCall(string);
            }
            this.setAddMode(false);
            bufferedReader.close();
            this.jTabbedPane1.setTitleAt(0, "Graph View: " + file.getName());
        }
        catch (Exception exception) {
            Logger.getLogger(GUI2.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void setScaleLevel(int n) {
        this.jungGraphPanel1.getVV().getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
        this.jungGraphPanel1.getVV().getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
        this.jungGraphPanel1.scale_btn_click = n;
        if (n >= 0) {
            for (int i = 0; i < n; ++i) {
                this.jungGraphPanel1.scaler.scale(this.jungGraphPanel1.getVV(), this.jungGraphPanel1.scaleAmt, this.jungGraphPanel1.getVV().getCenter());
            }
        } else {
            for (int i = 0; i > n; ++i) {
                this.jungGraphPanel1.scaler.scale(this.jungGraphPanel1.getVV(), 1.0f / this.jungGraphPanel1.scaleAmt, this.jungGraphPanel1.getVV().getCenter());
            }
        }
    }

    protected final JungGraphPanel getGraphPanel() {
        return this.jungGraphPanel1;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jToggleButton_repl = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.splitPane_left = new JSplitPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.jungGraphPanel1 = new JungGraphPanel();
        this.rEPLPanel1 = new REPLPanel();
        this.pluginPanel1 = new PluginPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu5 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.loadDemo = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.saveCurrentKB = new JMenuItem();
        this.saveKBasDemo = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenu_globablFilter = new JMenu();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jCheckBoxMenuItem_showNewAssertions = new JCheckBoxMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem_refreshGraph = new JMenuItem();
        this.jCheckBoxMenuItem_autoRefresh = new JCheckBoxMenuItem();
        this.jMenuItem_relayout = new JMenuItem();
        this.jCheckBoxMenuItem_autoRelayout = new JCheckBoxMenuItem();
        this.jMenu7 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jCheckBoxMenuItem_antialias = new JCheckBoxMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.menuItem_sneps3manual = new JMenuItem();
        this.menuItem_guidocs = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Sneps 3 GUI Version 2011.11.11");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                GUI2.this.formKeyPressed(keyEvent);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jButton1.setText("Add Frame Instance");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jToggleButton_repl.setSelected(true);
        this.jToggleButton_repl.setText("REPL");
        this.jToggleButton_repl.setFocusable(false);
        this.jToggleButton_repl.setHorizontalTextPosition(0);
        this.jToggleButton_repl.setVerticalTextPosition(3);
        this.jToggleButton_repl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jToggleButton_replActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jToggleButton_repl);
        this.jSplitPane1.setDividerLocation(750);
        this.jSplitPane1.setDividerSize(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.splitPane_left.setDividerLocation(451);
        this.splitPane_left.setOrientation(0);
        this.splitPane_left.setResizeWeight(1.0);
        this.jTabbedPane1.addTab("Graph View", this.jungGraphPanel1);
        this.splitPane_left.setTopComponent(this.jTabbedPane1);
        this.jTabbedPane1.getAccessibleContext().setAccessibleName("Graph View");
        this.splitPane_left.setRightComponent(this.rEPLPanel1);
        this.jSplitPane1.setLeftComponent(this.splitPane_left);
        this.jSplitPane1.setRightComponent(this.pluginPanel1);
        this.jMenu1.setMnemonic('F');
        this.jMenu1.setText("File");
        this.jMenu5.setMnemonic('L');
        this.jMenu5.setText("Load");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem1.setMnemonic('L');
        this.jMenuItem1.setText("Load to KB");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu5.add(this.jMenuItem1);
        this.loadDemo.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.loadDemo.setMnemonic('D');
        this.loadDemo.setText("Demo");
        this.loadDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.loadDemoActionPerformed(actionEvent);
            }
        });
        this.jMenu5.add(this.loadDemo);
        this.jMenu1.add(this.jMenu5);
        this.jMenu4.setMnemonic('S');
        this.jMenu4.setText("Save");
        this.saveCurrentKB.setText("Current KB");
        this.saveCurrentKB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.saveCurrentKBActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.saveCurrentKB);
        this.saveKBasDemo.setText("KB as Demo");
        this.saveKBasDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.saveKBasDemoActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.saveKBasDemo);
        this.jMenuItem10.setText("Export Graph...");
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem10ActionPerformed(actionEvent);
            }
        });
        this.jMenu4.add(this.jMenuItem10);
        this.jMenu1.add(this.jMenu4);
        this.jMenuItem3.setMnemonic('Q');
        this.jMenuItem3.setText("Quit");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem3ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu_globablFilter.setMnemonic('G');
        this.jMenu_globablFilter.setText("Graph");
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.jMenuItem9.setMnemonic('S');
        this.jMenuItem9.setText("Show In Graph");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem9ActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jMenuItem9);
        this.jMenuItem12.setText("Globally Filter Graph by Caseframe");
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem12ActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jMenuItem12);
        this.jCheckBoxMenuItem_showNewAssertions.setSelected(true);
        this.jCheckBoxMenuItem_showNewAssertions.setText("Show New Assertions in Graph");
        this.jCheckBoxMenuItem_showNewAssertions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jCheckBoxMenuItem_showNewAssertionsActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jCheckBoxMenuItem_showNewAssertions);
        this.jMenu_globablFilter.add(this.jSeparator1);
        this.jMenuItem_refreshGraph.setMnemonic('F');
        this.jMenuItem_refreshGraph.setText("Refresh");
        this.jMenuItem_refreshGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem_refreshGraphActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jMenuItem_refreshGraph);
        this.jCheckBoxMenuItem_autoRefresh.setMnemonic('R');
        this.jCheckBoxMenuItem_autoRefresh.setSelected(true);
        this.jCheckBoxMenuItem_autoRefresh.setText("Auto Refresh");
        this.jCheckBoxMenuItem_autoRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jCheckBoxMenuItem_autoRefreshActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jCheckBoxMenuItem_autoRefresh);
        this.jMenuItem_relayout.setMnemonic('L');
        this.jMenuItem_relayout.setText("Relayout");
        this.jMenuItem_relayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem_relayoutActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jMenuItem_relayout);
        this.jCheckBoxMenuItem_autoRelayout.setMnemonic('E');
        this.jCheckBoxMenuItem_autoRelayout.setSelected(true);
        this.jCheckBoxMenuItem_autoRelayout.setText("Auto Relayout");
        this.jCheckBoxMenuItem_autoRelayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jCheckBoxMenuItem_autoRelayoutActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jCheckBoxMenuItem_autoRelayout);
        this.jMenu7.setMnemonic('F');
        this.jMenu7.setText("Font Size");
        this.jMenuItem4.setText("12");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItemFontSizeActionPerformed(actionEvent);
            }
        });
        this.jMenu7.add(this.jMenuItem4);
        this.jMenuItem5.setText("14");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItemFontSizeActionPerformed(actionEvent);
            }
        });
        this.jMenu7.add(this.jMenuItem5);
        this.jMenuItem6.setText("16");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItemFontSizeActionPerformed(actionEvent);
            }
        });
        this.jMenu7.add(this.jMenuItem6);
        this.jMenuItem7.setText("18");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItemFontSizeActionPerformed(actionEvent);
            }
        });
        this.jMenu7.add(this.jMenuItem7);
        this.jMenuItem8.setText("20");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItemFontSizeActionPerformed(actionEvent);
            }
        });
        this.jMenu7.add(this.jMenuItem8);
        this.jMenu_globablFilter.add(this.jMenu7);
        this.jCheckBoxMenuItem_antialias.setSelected(true);
        this.jCheckBoxMenuItem_antialias.setText("Anti-Aliasing");
        this.jCheckBoxMenuItem_antialias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jCheckBoxMenuItem_antialiasActionPerformed(actionEvent);
            }
        });
        this.jMenu_globablFilter.add(this.jCheckBoxMenuItem_antialias);
        this.jMenuBar1.add(this.jMenu_globablFilter);
        this.jMenu3.setMnemonic('S');
        this.jMenu3.setText("SNePS");
        this.jMenu3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenu3ActionPerformed(actionEvent);
            }
        });
        this.jMenuItem2.setMnemonic('C');
        this.jMenuItem2.setText("Clear Knowledge Base");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem2ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem2);
        this.jMenuItem11.setMnemonic('L');
        this.jMenuItem11.setText("Clear Knowledge Base, Slots, and Caseframes");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.jMenuItem11ActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.jMenuItem11);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu6.setMnemonic('H');
        this.jMenu6.setText("Help");
        this.menuItem_sneps3manual.setMnemonic('S');
        this.menuItem_sneps3manual.setText("SNePS 3 Manual");
        this.menuItem_sneps3manual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.menuItem_sneps3manualActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.menuItem_sneps3manual);
        this.menuItem_guidocs.setMnemonic('G');
        this.menuItem_guidocs.setText("GUI Manual");
        this.menuItem_guidocs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI2.this.menuItem_guidocsActionPerformed(actionEvent);
            }
        });
        this.jMenu6.add(this.menuItem_guidocs);
        this.jMenuBar1.add(this.jMenu6);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 996, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 996, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 586, Short.MAX_VALUE)));
        this.pack();
    }

    private void jToggleButton_replActionPerformed(ActionEvent actionEvent) {
        if (((JToggleButton)actionEvent.getSource()).isSelected()) {
            this.setREPLVisibility(true);
        } else {
            this.setREPLVisibility(false);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.currentDir);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.currentDir = jFileChooser.getCurrentDirectory();
            this.loadToKB(jFileChooser.getSelectedFile());
        }
    }

    private void jMenu3ActionPerformed(ActionEvent actionEvent) {
    }

    private void jMenuItem3ActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentKBActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.currentDir);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.currentDir = jFileChooser.getCurrentDirectory();
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                outputStreamWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter(outputStreamWriter);
                printWriter.write(this.defs);
                printWriter.write(this.asserts);
            }
            catch (IOException iOException) {
                Logger.getLogger(GUI2.class.getName()).log(Level.SEVERE, null, iOException);
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(GUI2.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void jMenuItem2ActionPerformed(ActionEvent actionEvent) {
        this.makeLispCall("(clearkb)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveKBasDemoActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.currentDir);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.currentDir = jFileChooser.getCurrentDirectory();
            OutputStreamWriter outputStreamWriter = null;
            try {
                File file = jFileChooser.getSelectedFile();
                outputStreamWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter(outputStreamWriter);
                printWriter.write(this.fullkb);
            }
            catch (IOException iOException) {
                Logger.getLogger(GUI2.class.getName()).log(Level.SEVERE, null, iOException);
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(GUI2.class.getName()).log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    private void loadDemoActionPerformed(ActionEvent actionEvent) {
        try {
            DemoMode demoMode = new DemoMode();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.currentDir);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.currentDir = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                this.jTabbedPane1.setTitleAt(0, "Graph View: " + file.getName());
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = System.getProperty("line.separator");
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(string2);
                }
                demoMode.setVisible(true);
                demoMode.setupDemo(stringBuilder.toString(), this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jMenuItem_refreshGraphActionPerformed(ActionEvent actionEvent) {
        this.makeLispCall("(sneps3::generate-graph)");
    }

    private void jCheckBoxMenuItem_autoRefreshActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        boolean bl = abstractButton.getModel().isSelected();
        if (bl) {
            this.makeLispCall("(setf sneps3::*auto-refresh-graph* t)");
            this.makeLispCall("(sneps3::generate-graph)");
        } else {
            this.makeLispCall("(setf sneps3::*auto-refresh-graph* nil)");
        }
    }

    private void jCheckBoxMenuItem_autoRelayoutActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        boolean bl = abstractButton.getModel().isSelected();
        if (bl) {
            this.makeLispCall("(setf sneps3::*auto-relayout-graph* t)");
        } else {
            this.makeLispCall("(setf sneps3::*auto-relayout-graph* nil)");
        }
    }

    private void jMenuItem_relayoutActionPerformed(ActionEvent actionEvent) {
        this.relayoutGraph();
    }

    private void menuItem_sneps3manualActionPerformed(ActionEvent actionEvent) {
        pdfViewer pdfViewer2 = new pdfViewer("Docs/manual.pdf");
    }

    private void menuItem_guidocsActionPerformed(ActionEvent actionEvent) {
        pdfViewer pdfViewer2 = new pdfViewer("Docs/SNePSGUIDocs.pdf");
    }

    private void jMenuItemFontSizeActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        int n = Integer.parseInt(jMenuItem.getText());
        this.jungGraphPanel1.setFontSize(n);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        AddToKBPanel addToKBPanel = new AddToKBPanel();
        addToKBPanel.setVisible(true);
    }

    private void jMenuItem9ActionPerformed(ActionEvent actionEvent) {
        FindQuery3 findQuery3 = new FindQuery3();
        findQuery3.setVisible(true);
    }

    private void jMenuItem10ActionPerformed(ActionEvent actionEvent) {
        this.export.showExportDialog((Component)this, "Export graph as...", this.jungGraphPanel1.getVV(), "propgraph");
        if (this.jCheckBoxMenuItem_antialias.isSelected()) {
            this.jungGraphPanel1.getVV().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    private void formKeyPressed(KeyEvent keyEvent) {
    }

    private void jCheckBoxMenuItem_antialiasActionPerformed(ActionEvent actionEvent) {
        if (this.jCheckBoxMenuItem_antialias.isSelected()) {
            this.jungGraphPanel1.getVV().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.jungGraphPanel1.getVV().repaint();
        } else {
            this.jungGraphPanel1.getVV().getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.jungGraphPanel1.getVV().repaint();
        }
    }

    private void jMenuItem11ActionPerformed(ActionEvent actionEvent) {
        this.makeLispCall("(clearkb t)");
    }

    private void jMenuItem12ActionPerformed(ActionEvent actionEvent) {
        GlobalGraphFilter.showFilterDialog(this);
    }

    private void jCheckBoxMenuItem_showNewAssertionsActionPerformed(ActionEvent actionEvent) {
        if (this.jCheckBoxMenuItem_showNewAssertions.isSelected()) {
            this.showNewAssertions = true;
            this.getGraphPanel().setStatusbarText("");
        } else {
            this.showNewAssertions = false;
            this.getGraphPanel().setStatusbarText("New assertions are not shown in the graph.");
        }
    }

    public static void main(final String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = "";
                String string2 = "";
                int n = 4321;
                int n2 = 1000;
                int n3 = 300;
                int n4 = -1;
                String string3 = "";
                String string4 = "";
                int n5 = 0;
                if (stringArray.length > 1) {
                    JavaLinkCommon.sdebug = true;
                    JavaLinkDist.connect(stringArray[1], n, string4, n5, n2, n3);
                } else {
                    instance = new GUI2();
                    instance.setVisible(true);
                }
            }
        });
    }

    @Override
    public void ctUpdate(ArrayList<Context> arrayList) {
    }

    @Override
    public void stUpdate(ArrayList<SemanticType> arrayList) {
    }

    @Override
    public void cfUpdate(ArrayList<Caseframe> arrayList) {
    }

    @Override
    public void slotUpdate(ArrayList<Slot> arrayList) {
    }

    @Override
    public void ctCurrent(Context context) {
    }

    static {
        hide_cf_list = new ArrayList();
    }
}

