/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.JungGraphEdge;
import edu.buffalo.cse.sneps3.gui.JungGraphEdgeCollapsed;
import edu.buffalo.cse.sneps3.gui.JungGraphPanel;
import edu.buffalo.cse.sneps3.gui.SemanticType;
import edu.buffalo.cse.sneps3.gui.Slot;
import java.util.ArrayList;
import java.util.HashSet;

public class JungGraphNode
implements Cloneable {
    String name;
    SemanticType type;
    double activation;
    Caseframe cf;
    boolean asserted;
    ArrayList<JungGraphEdge> upCableset = new ArrayList();
    ArrayList<JungGraphEdge> downCableset = new ArrayList();
    boolean upCSVisible = true;
    boolean dnCSVisible = true;
    public boolean visible = true;
    private boolean wftStatusKnown = false;
    private boolean wftNode = false;

    public JungGraphNode(String string, SemanticType semanticType, Caseframe caseframe, boolean bl, double d) {
        this.name = string;
        this.type = semanticType;
        this.cf = caseframe;
        this.activation = d;
        this.asserted = bl;
    }

    public JungGraphNode(String string) {
        this.name = string;
    }

    public SemanticType getType() {
        return this.type;
    }

    public double getActivation() {
        return this.activation;
    }

    public void addToUpCableset(JungGraphEdge jungGraphEdge) {
        for (JungGraphEdge jungGraphEdge2 : this.upCableset) {
            if (!jungGraphEdge2.equals(jungGraphEdge)) continue;
            return;
        }
        this.upCableset.add(jungGraphEdge);
    }

    public ArrayList<JungGraphEdge> getUpCableset() {
        return this.upCableset;
    }

    public void addToDownCableset(JungGraphEdge jungGraphEdge) {
        for (JungGraphEdge jungGraphEdge2 : this.downCableset) {
            if (!jungGraphEdge2.equals(jungGraphEdge)) continue;
            return;
        }
        this.downCableset.add(jungGraphEdge);
    }

    public ArrayList<JungGraphEdge> getDownCableset() {
        return this.downCableset;
    }

    public String toString() {
        if (this.asserted) {
            return this.name + "!";
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWftNode() {
        if (this.wftStatusKnown) {
            return this.wftNode;
        }
        if (this.cf != null && this.name.length() > 3 && this.name.substring(0, 3).equals("wft")) {
            for (int i = 3; i < this.name.length(); ++i) {
                if (Character.isDigit(this.name.charAt(i))) continue;
                this.wftStatusKnown = true;
                this.wftNode = false;
                return false;
            }
        } else {
            this.wftStatusKnown = true;
            this.wftNode = false;
            return false;
        }
        this.wftStatusKnown = true;
        this.wftNode = true;
        return true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDownCablesetVisible() {
        int n = 0;
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (!jungGraphEdge.to.isVisible()) continue;
            ++n;
        }
        return n == this.downCableset.size();
    }

    public boolean isDownCablesetPartialVisible() {
        int n = 0;
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (!jungGraphEdge.to.isVisible()) continue;
            ++n;
        }
        return n > 0;
    }

    public int getDownCablesetVisibleCount() {
        int n = 0;
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (!jungGraphEdge.to.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public boolean isUpCablesetVisible() {
        int n = 0;
        for (JungGraphEdge jungGraphEdge : this.upCableset) {
            if (!jungGraphEdge.from.isVisible()) continue;
            ++n;
        }
        return n == this.upCableset.size();
    }

    public boolean isUpCablesetPartialVisible() {
        int n = 0;
        for (JungGraphEdge jungGraphEdge : this.upCableset) {
            if (!jungGraphEdge.from.isVisible()) continue;
            ++n;
        }
        return n > 0;
    }

    public ArrayList<JungGraphEdge> getUpCablesetMinusFS() {
        ArrayList<JungGraphEdge> arrayList = new ArrayList<JungGraphEdge>();
        for (JungGraphEdge jungGraphEdge : this.upCableset) {
            if (jungGraphEdge.from.isWftNode() && jungGraphEdge.from.cf.hasFSymbols() && jungGraphEdge.from.cf.slots.get((int)0).name.equals(jungGraphEdge.toString()) && !jungGraphEdge.from.isVisible()) continue;
            arrayList.add(jungGraphEdge);
        }
        return arrayList;
    }

    public ArrayList<JungGraphEdge> getDownCablesetMinusFS() {
        ArrayList<JungGraphEdge> arrayList = new ArrayList<JungGraphEdge>();
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (jungGraphEdge.from.isWftNode() && jungGraphEdge.from.cf.hasFSymbols() && jungGraphEdge.from.cf.slotnames.get(0).equals(jungGraphEdge.toString()) && !jungGraphEdge.from.isVisible()) continue;
            arrayList.add(jungGraphEdge);
        }
        return arrayList;
    }

    public int getUpCablesetVisibleCount() {
        int n = 0;
        block0: for (JungGraphEdge jungGraphEdge : this.upCableset) {
            if (jungGraphEdge.from.isVisible()) {
                ++n;
                continue;
            }
            if (!JungGraphPanel.collapsed) continue;
            for (JungGraphEdgeCollapsed jungGraphEdgeCollapsed : JungGraphPanel.semantic_addedEdges) {
                if (jungGraphEdgeCollapsed.getReplacedWft() != jungGraphEdge.from) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public Caseframe getCaseframe() {
        return this.cf;
    }

    public ArrayList<Caseframe> getCaseframesIn() {
        ArrayList<Caseframe> arrayList = new ArrayList<Caseframe>();
        for (JungGraphEdge jungGraphEdge : this.upCableset) {
            if (!jungGraphEdge.from.isWftNode()) continue;
            arrayList.add(jungGraphEdge.from.getCaseframe());
        }
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (!jungGraphEdge.to.isWftNode()) continue;
            arrayList.add(jungGraphEdge.to.getCaseframe());
        }
        return arrayList;
    }

    public String buildLogicalForm() {
        String string = "(";
        if (!this.cf.hasFSymbols()) {
            string = string + this.cf.name;
        }
        for (Slot slot : this.cf.slots) {
            string = string + " ";
            HashSet hashSet = this.getSlotFillers(slot);
            if (hashSet.size() > 1) {
                string = string + "(setof";
            }
            for (JungGraphNode jungGraphNode : hashSet) {
                if (hashSet.size() > 1) {
                    string = string + " ";
                }
                if (jungGraphNode.isWftNode()) {
                    string = string + jungGraphNode.buildLogicalForm();
                    continue;
                }
                if (jungGraphNode.getName().contains(" ")) {
                    string = string + "\"" + jungGraphNode.getName() + "\"";
                    continue;
                }
                string = string + jungGraphNode.getName();
            }
            if (hashSet.size() <= 1) continue;
            string = string + ")";
        }
        return string + ")";
    }

    private HashSet getSlotFillers(Slot slot) {
        HashSet<JungGraphNode> hashSet = new HashSet<JungGraphNode>();
        for (JungGraphEdge jungGraphEdge : this.downCableset) {
            if (!jungGraphEdge.toString().equals(slot.name)) continue;
            hashSet.add(jungGraphEdge.to);
        }
        return hashSet;
    }

    public JungGraphNode clone() {
        return new JungGraphNode(this.name, this.type, this.cf, this.asserted, this.activation);
    }
}

