/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import edu.buffalo.cse.sneps3.gui.ArrowFillTransformer;
import edu.buffalo.cse.sneps3.gui.ArrowShapeTransformer;
import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.FindQuery3;
import edu.buffalo.cse.sneps3.gui.GUI2;
import edu.buffalo.cse.sneps3.gui.JungGraphEdge;
import edu.buffalo.cse.sneps3.gui.JungGraphEdgeCollapsed;
import edu.buffalo.cse.sneps3.gui.JungGraphNode;
import edu.buffalo.cse.sneps3.gui.JungRestrictionGraphEdge;
import edu.buffalo.cse.sneps3.gui.PairLR;
import edu.buffalo.cse.sneps3.gui.SnepsModalGraphMouse;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout3d.Layout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.DefaultParallelEdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.LayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization3d.VisualizationViewer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.media.j3d.BoundingSphere;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.vecmath.Point3d;
import org.apache.commons.collections15.Transformer;

public class JungGraphPanel
extends JPanel {
    boolean straightEdges = true;
    boolean findv2 = true;
    boolean showing_all = true;
    static boolean collapsed = false;
    GraphType type = GraphType.FR2d;
    EdgeShape.QuadCurve quadcurve = new EdgeShape.QuadCurve();
    EdgeShape.Line line = new EdgeShape.Line();
    DirectedSparseMultigraph dsg;
    edu.uci.ics.jung.visualization.VisualizationViewer<JungGraphNode, JungGraphEdge> vv;
    LensSupport hyperbolicViewSupport;
    LensSupport hyperbolicLayoutSupport;
    SnepsModalGraphMouse<JungGraphNode, JungGraphEdge> graphMouse = new SnepsModalGraphMouse();
    static ArrayList<JungGraphEdgeCollapsed> semantic_addedEdges = new ArrayList();
    ArrayList<JungGraphEdge> semantic_removedEdges = new ArrayList();
    ArrayList<JungGraphNode> semantic_removedNodes = new ArrayList();
    ArrayList on_graph_expanded_nodenames = new ArrayList();
    ArrayList<JungGraphEdge> explore_removedEdges = new ArrayList();
    ArrayList<JungGraphNode> explore_removedNodes = new ArrayList();
    ArrayList<JungGraphNode> highlightedNodes = new ArrayList();
    Color highlightedColor = new Color(135, 206, 250);
    AbstractLayout<JungGraphNode, JungGraphEdge> layout;
    final ScalingControl scaler = new CrossoverScalingControl();
    int lastSliderVal = 0;
    int displayAreaWidth = 700;
    int displayAreaHeight = 350;
    final float[] dash = new float[]{10.0f};
    final Stroke dashStroke = new BasicStroke(1.0f, 0, 0, 10.0f, this.dash, 0.0f);
    final Stroke solidStroke = new BasicStroke(1.0f);
    public int scale_btn_click = 0;
    float scaleAmt = 1.2f;
    public static JungGraphPanel instance;
    GraphZoomScrollPane panel;
    private JButton jButton_hideAll;
    private JButton jButton_scaleMinus;
    private JButton jButton_scalePlus;
    private JButton jButton_scaleReset;
    private JButton jButton_showAll;
    private JButton jButton_showInGraph;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel_status;
    private JPanel jPanel1;
    private JToolBar.Separator jSeparator2;
    private JToggleButton jToggleButton_collapse;
    private JToggleButton jToggleButton_lens;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;

    public JungGraphPanel() {
        instance = this;
        this.initComponents();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.jPanel1, "South");
        Border border = BorderFactory.createEmptyBorder();
        this.jButton_scalePlus.setBorder(border);
        this.jButton_scaleMinus.setBorder(border);
        this.jButton_scaleReset.setBorder(border);
        this.quadcurve.setEdgeIndexFunction((EdgeIndexFunction)DefaultParallelEdgeIndexFunction.getInstance());
        this.displayGraph((DirectedSparseMultigraph<JungGraphNode, JungGraphEdge>)new DirectedSparseMultigraph());
    }

    public edu.uci.ics.jung.visualization.VisualizationViewer<JungGraphNode, JungGraphEdge> getVV() {
        return this.vv;
    }

    public void setFontSize(final int n) {
        Transformer<JungGraphNode, Font> transformer = new Transformer<JungGraphNode, Font>(){

            @Override
            public Font transform(JungGraphNode jungGraphNode) {
                return new Font(JungGraphPanel.this.vv.getFont().getName(), JungGraphPanel.this.vv.getFont().getStyle(), n);
            }
        };
        this.vv.setFont(new Font(this.vv.getFont().getName(), this.vv.getFont().getStyle(), n));
        this.vv.getRenderContext().setVertexFontTransformer((Transformer)transformer);
    }

    public DirectedSparseMultigraph<JungGraphNode, JungGraphEdge> getGraph() {
        return this.dsg;
    }

    public void displayGraph(DirectedSparseMultigraph<JungGraphNode, JungGraphEdge> directedSparseMultigraph) {
        if (this.jToggleButton_collapse.isSelected()) {
            this.jToggleButton_collapse.setSelected(false);
            this.semanticExpandAll();
        }
        this.dsg = directedSparseMultigraph;
        if (this.type == GraphType.FR2d) {
            this.layout = new FRLayout(directedSparseMultigraph);
            int n = this.getWidth() < 100 ? 700 : this.getWidth() - (Integer)UIManager.get("ScrollBar.width") - 15;
            int n2 = this.getHeight() < 100 ? 350 : this.getHeight() - (Integer)UIManager.get("ScrollBar.width") - 40;
            this.layout.setSize(new Dimension(n, n2));
            this.vv = new edu.uci.ics.jung.visualization.VisualizationViewer(this.layout);
            if (this.scale_btn_click > 0) {
                for (int i = 0; i < this.scale_btn_click; ++i) {
                    this.scaler.scale(this.vv, this.scaleAmt, this.vv.getCenter());
                }
            }
            this.vv.setBackground(Color.white);
            this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
            this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
            if (this.straightEdges) {
                this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new Transformer<Context<Graph<JungGraphNode, JungGraphEdge>, JungGraphEdge>, Shape>(){

                    @Override
                    public Shape transform(Context<Graph<JungGraphNode, JungGraphEdge>, JungGraphEdge> context) {
                        if (context.element instanceof JungRestrictionGraphEdge) {
                            return JungGraphPanel.this.quadcurve.transform(context);
                        }
                        JungGraphNode jungGraphNode = ((JungGraphEdge)context.element).from;
                        for (Object e : JungGraphPanel.this.dsg.getOutEdges((Object)jungGraphNode)) {
                            JungGraphEdge jungGraphEdge = (JungGraphEdge)e;
                            if (jungGraphEdge.to != ((JungGraphEdge)context.element).to || context.element == jungGraphEdge) continue;
                            return JungGraphPanel.this.quadcurve.transform(context);
                        }
                        return JungGraphPanel.this.line.transform(context);
                    }
                });
                this.vv.getRenderer().setEdgeLabelRenderer(new CustomEdgeLabelRenderer());
            }
            this.vv.getRenderContext().setEdgeStrokeTransformer((Transformer)new Transformer<JungGraphEdge, Stroke>(){

                @Override
                public Stroke transform(JungGraphEdge jungGraphEdge) {
                    if (jungGraphEdge instanceof JungRestrictionGraphEdge) {
                        return JungGraphPanel.this.dashStroke;
                    }
                    return JungGraphPanel.this.solidStroke;
                }
            });
            this.vv.getRenderContext().setEdgeLabelClosenessTransformer((Transformer)new Transformer<Context<Graph<JungGraphNode, JungGraphEdge>, JungGraphEdge>, Number>(){

                @Override
                public Number transform(Context<Graph<JungGraphNode, JungGraphEdge>, JungGraphEdge> context) {
                    return new Double(0.5);
                }
            });
            this.vv.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
            this.vv.getRenderContext().setEdgeArrowTransformer(new ArrowShapeTransformer());
            this.vv.getRenderContext().setVertexShapeTransformer(new NodeShapeTransformer());
            Transformer<JungGraphNode, Paint> transformer = new Transformer<JungGraphNode, Paint>(){

                @Override
                public Paint transform(JungGraphNode jungGraphNode) {
                    PickedState pickedState = JungGraphPanel.this.vv.getPickedVertexState();
                    if (pickedState.isPicked((Object)jungGraphNode)) {
                        return Color.green;
                    }
                    if (JungGraphPanel.this.highlightedNodes.contains(jungGraphNode)) {
                        return JungGraphPanel.this.highlightedColor;
                    }
                    if (jungGraphNode.getActivation() == 1.0) {
                        return Color.red;
                    }
                    if (jungGraphNode.getActivation() > 0.4) {
                        return Color.orange;
                    }
                    if (jungGraphNode.getActivation() > 0.0) {
                        return Color.yellow;
                    }
                    return Color.pink;
                }
            };
            this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)transformer);
            Transformer<String, Paint> transformer2 = new Transformer<String, Paint>(){

                @Override
                public Paint transform(String string) {
                    return Color.white;
                }
            };
            this.vv.getRenderContext().setArrowFillPaintTransformer(new ArrowFillTransformer());
            this.vv.setGraphMouse(this.graphMouse);
            this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            this.hyperbolicLayoutSupport = new LayoutLensSupport(this.vv, (LensTransformer)new HyperbolicTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT)), (ModalGraphMouse)new ModalLensGraphMouse());
            this.graphMouse.addItemListener(this.hyperbolicLayoutSupport.getGraphMouse().getModeListener());
            this.panel = new GraphZoomScrollPane(this.vv);
            if (((BorderLayout)this.getLayout()).getLayoutComponent("Center") != null) {
                this.remove(((BorderLayout)this.getLayout()).getLayoutComponent("Center"));
            }
            this.add((Component)this.panel, "Center");
        }
        if (this.type == GraphType.FR3d) {
            edu.uci.ics.jung.algorithms.layout3d.FRLayout fRLayout = new edu.uci.ics.jung.algorithms.layout3d.FRLayout(directedSparseMultigraph);
            fRLayout.setSize(new BoundingSphere(new Point3d(150.0, 150.0, 150.0), 50.0));
            VisualizationViewer visualizationViewer = new VisualizationViewer();
            visualizationViewer.setGraphLayout((Layout)fRLayout);
            visualizationViewer.setPreferredSize(new Dimension(350, 350));
            this.add((Component)visualizationViewer, "Center");
        }
        this.on_graph_expanded_nodenames.clear();
        for (Object e : this.dsg.getVertices()) {
            this.on_graph_expanded_nodenames.add(((JungGraphNode)e).getName());
        }
    }

    public void addVertex(JungGraphNode jungGraphNode) {
        this.dsg.addVertex((Object)jungGraphNode);
        jungGraphNode.visible = true;
        this.on_graph_expanded_nodenames.add(jungGraphNode.getName());
    }

    public void reinitialize() {
        this.jToggleButton_collapse.setSelected(false);
        collapsed = false;
        GUI2.getInstance().getNodeName_node_map().clear();
        this.hideAll();
        semantic_addedEdges.clear();
        this.semantic_removedEdges.clear();
        this.semantic_removedNodes.clear();
        this.on_graph_expanded_nodenames.clear();
        this.showing_all = true;
    }

    public void hideAll() {
        Object[] objectArray;
        for (Object object : objectArray = this.dsg.getVertices().toArray()) {
            this.dsg.removeVertex(object);
            ((JungGraphNode)object).visible = false;
        }
        semantic_addedEdges.clear();
        this.semantic_removedEdges.clear();
        this.semantic_removedNodes.clear();
        this.on_graph_expanded_nodenames.clear();
        this.vv.repaint();
        this.showing_all = false;
    }

    public void showAll() {
        if (collapsed) {
            this.semanticExpandAll();
        }
        for (JungGraphNode object : GUI2.getInstance().getNodeName_node_map().values()) {
            if (object.isVisible()) continue;
            this.dsg.addVertex((Object)object);
            object.visible = true;
        }
        for (JungGraphEdge jungGraphEdge : GUI2.getInstance().getEdge_list()) {
            this.dsg.addEdge((Object)jungGraphEdge, (Object)jungGraphEdge.from, (Object)jungGraphEdge.to, EdgeType.DIRECTED);
        }
        this.on_graph_expanded_nodenames.clear();
        for (Object object : this.dsg.getVertices()) {
            this.on_graph_expanded_nodenames.add(((JungGraphNode)object).getName());
        }
        if (collapsed) {
            this.semanticCollapseAll();
        }
        this.vv.repaint();
        this.showing_all = true;
    }

    public boolean isEmpty() {
        return this.dsg.getVertexCount() == 0;
    }

    public boolean isShowingAll() {
        return this.showing_all;
    }

    public String displayOnlyNodeSet(ArrayList<String> arrayList) {
        this.hideAll();
        this.on_graph_expanded_nodenames = new ArrayList();
        return this.displayNodeSet(arrayList);
    }

    public String displayNodeSet(ArrayList<String> arrayList) {
        ArrayList<JungGraphNode> arrayList2 = new ArrayList<JungGraphNode>();
        String string = "";
        for (String object : arrayList) {
            JungGraphNode jungGraphNode = GUI2.getInstance().getNodeName_node_map().get(object);
            if (jungGraphNode != null) {
                arrayList2.add(jungGraphNode);
                continue;
            }
            string = string + " \"" + object + "\"";
        }
        if (!string.equals("")) {
            return string;
        }
        this.on_graph_expanded_nodenames.addAll(arrayList);
        for (JungGraphNode jungGraphNode : arrayList2) {
            if (jungGraphNode.isVisible()) continue;
            this.showNode(jungGraphNode);
            for (JungGraphEdge jungGraphEdge : GUI2.getInstance().getEdge_list()) {
                if (jungGraphEdge.from != jungGraphNode || !this.dsg.containsVertex((Object)jungGraphEdge.to)) continue;
                this.dsg.addEdge((Object)jungGraphEdge, (Object)jungGraphEdge.from, (Object)jungGraphEdge.to, EdgeType.DIRECTED);
            }
        }
        this.highlightedNodes.clear();
        for (JungGraphNode jungGraphNode : arrayList2) {
            this.highlightedNodes.add(jungGraphNode);
        }
        if (collapsed) {
            this.semanticCollapse(arrayList2);
        }
        return null;
    }

    public void semanticCollapseAll() {
        semantic_addedEdges.clear();
        this.semantic_removedEdges.clear();
        this.semantic_removedNodes.clear();
        this.semanticCollapse(this.dsg.getVertices());
    }

    /*
     * WARNING - void declaration
     */
    public void semanticCollapse(Collection collection) {
        Object object;
        JungGraphEdge jungGraphEdge;
        JungGraphEdge jungGraphEdge2;
        JungGraphNode jungGraphNode;
        ArrayList<JungGraphNode> arrayList = new ArrayList<JungGraphNode>();
        for (Object object3 : collection) {
            jungGraphNode = (JungGraphNode)object3;
            if (!jungGraphNode.isWftNode() || !jungGraphNode.getCaseframe().type.equals("Proposition") || jungGraphNode.getDownCableset().size() != 2 || !jungGraphNode.getUpCableset().isEmpty()) continue;
            jungGraphEdge2 = jungGraphNode.getDownCableset().get(0);
            jungGraphEdge = jungGraphNode.getDownCableset().get(1);
            if (jungGraphEdge2.to == jungGraphEdge.to) continue;
            arrayList.add(jungGraphNode);
            this.dsg.removeEdge((Object)jungGraphEdge2);
            this.dsg.removeEdge((Object)jungGraphEdge);
            object = jungGraphNode.getCaseframe();
            JungGraphEdgeCollapsed jungGraphEdgeCollapsed = null;
            String string = ((Caseframe)object).name + (jungGraphNode.asserted ? "!" : "");
            if (((Caseframe)object).slots.get(0).toString().equals(jungGraphEdge2.toString())) {
                jungGraphEdgeCollapsed = new JungGraphEdgeCollapsed(string, jungGraphEdge2.to, jungGraphEdge.to, jungGraphNode);
                jungGraphEdgeCollapsed.collapsed = true;
                this.dsg.addEdge((Object)jungGraphEdgeCollapsed, (Object)jungGraphEdge2.to, (Object)jungGraphEdge.to);
            } else {
                jungGraphEdgeCollapsed = new JungGraphEdgeCollapsed(string, jungGraphEdge.to, jungGraphEdge2.to, jungGraphNode);
                jungGraphEdgeCollapsed.collapsed = true;
                this.dsg.addEdge((Object)jungGraphEdgeCollapsed, (Object)jungGraphEdge.to, (Object)jungGraphEdge2.to);
            }
            semantic_addedEdges.add(jungGraphEdgeCollapsed);
            this.semantic_removedEdges.add(jungGraphEdge);
            this.semantic_removedEdges.add(jungGraphEdge2);
            this.semantic_removedNodes.add(jungGraphNode);
        }
        for (Object e : collection) {
            void var10_24;
            jungGraphNode = (JungGraphNode)e;
            if (!jungGraphNode.isWftNode() || !jungGraphNode.getCaseframe().type.equals("Proposition") || !jungGraphNode.getUpCableset().isEmpty() || jungGraphNode.getDownCableset().size() != 3 || GUI2.model.getSlotByName(jungGraphNode.cf.name) == null || !jungGraphNode.cf.hasFSymbols()) continue;
            jungGraphEdge2 = null;
            jungGraphEdge = null;
            object = null;
            for (JungGraphEdge jungGraphEdge3 : jungGraphNode.getDownCableset()) {
                if (jungGraphEdge3.toString().equals(jungGraphNode.cf.name)) {
                    jungGraphEdge2 = jungGraphEdge3;
                    continue;
                }
                if (jungGraphEdge == null) {
                    jungGraphEdge = jungGraphEdge3;
                    continue;
                }
                object = jungGraphEdge3;
            }
            if (jungGraphEdge.to == ((JungGraphEdge)object).to) continue;
            boolean bl = true;
            if (!jungGraphEdge2.to.getDownCableset().isEmpty()) {
                bl = false;
            }
            for (JungGraphEdge jungGraphEdge4 : jungGraphEdge2.to.getUpCableset()) {
                if (jungGraphEdge4.toString().equals(jungGraphEdge2.toString())) continue;
                bl = false;
            }
            if (bl) {
                arrayList.add(jungGraphEdge2.to);
            }
            arrayList.add(jungGraphNode);
            String string = "";
            if (!jungGraphEdge2.to.isWftNode()) {
                String string2 = jungGraphEdge2.to.toString() + (jungGraphNode.asserted ? "!" : "");
            } else {
                String string3 = jungGraphEdge2.to.buildLogicalForm() + (jungGraphNode.asserted ? "!" : "");
            }
            this.dsg.removeEdge((Object)jungGraphEdge2);
            arrayList.add(jungGraphNode);
            this.dsg.removeEdge((Object)jungGraphEdge);
            this.dsg.removeEdge(object);
            Caseframe caseframe = jungGraphNode.getCaseframe();
            JungGraphEdgeCollapsed jungGraphEdgeCollapsed = null;
            if (caseframe.slots.get(1).toString().equals(jungGraphEdge.toString())) {
                jungGraphEdgeCollapsed = new JungGraphEdgeCollapsed((String)var10_24, jungGraphEdge.to, ((JungGraphEdge)object).to, jungGraphNode);
                jungGraphEdgeCollapsed.collapsed = true;
                this.dsg.addEdge((Object)jungGraphEdgeCollapsed, (Object)jungGraphEdge.to, (Object)((JungGraphEdge)object).to);
            } else {
                jungGraphEdgeCollapsed = new JungGraphEdgeCollapsed((String)var10_24, ((JungGraphEdge)object).to, jungGraphEdge.to, jungGraphNode);
                jungGraphEdgeCollapsed.collapsed = true;
                this.dsg.addEdge((Object)jungGraphEdgeCollapsed, (Object)((JungGraphEdge)object).to, (Object)jungGraphEdge.to);
            }
            semantic_addedEdges.add(jungGraphEdgeCollapsed);
            this.semantic_removedEdges.add((JungGraphEdge)object);
            this.semantic_removedEdges.add(jungGraphEdge);
            this.semantic_removedNodes.add(jungGraphNode);
            this.semantic_removedNodes.add(jungGraphEdge2.to);
            this.semantic_removedEdges.add(jungGraphEdge2);
        }
        for (JungGraphNode jungGraphNode2 : arrayList) {
            this.dsg.removeVertex((Object)jungGraphNode2);
            jungGraphNode2.visible = false;
        }
        this.vv.repaint();
    }

    public boolean isWftReplaced(JungGraphNode jungGraphNode) {
        for (JungGraphEdgeCollapsed jungGraphEdgeCollapsed : semantic_addedEdges) {
            if (jungGraphEdgeCollapsed.getReplacedWft() != jungGraphNode) continue;
            return true;
        }
        return false;
    }

    public void semanticExpandAll() {
        this.semanticExpand(new PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>>(this.semantic_removedNodes, this.semantic_removedEdges));
    }

    public void semanticExpand(PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>> pairLR) {
        ArrayList<JungGraphNode> arrayList2 = new ArrayList<JungGraphNode>();
        for (JungGraphNode arrayList3 : pairLR.getLeft()) {
            arrayList2.add(arrayList3);
            if (!this.on_graph_expanded_nodenames.contains(arrayList3.getName())) continue;
            this.showNode(arrayList3);
        }
        ArrayList arrayList4 = new ArrayList();
        for (JungGraphEdge jungGraphEdge : pairLR.getRight()) {
            arrayList4.add(jungGraphEdge);
            if (!this.dsg.containsVertex((Object)jungGraphEdge.from) || !this.dsg.containsVertex((Object)jungGraphEdge.to)) continue;
            this.dsg.addEdge((Object)jungGraphEdge, (Object)jungGraphEdge.from, (Object)jungGraphEdge.to);
        }
        ArrayList<JungGraphEdgeCollapsed> arrayList = new ArrayList<JungGraphEdgeCollapsed>();
        for (JungGraphEdgeCollapsed jungGraphEdgeCollapsed : semantic_addedEdges) {
            if (!this.dsg.containsVertex((Object)jungGraphEdgeCollapsed.from) || !this.dsg.containsVertex((Object)jungGraphEdgeCollapsed.to) || !pairLR.getLeft().contains(jungGraphEdgeCollapsed.getReplacedWft())) continue;
            this.dsg.removeEdge((Object)jungGraphEdgeCollapsed);
            arrayList.add(jungGraphEdgeCollapsed);
        }
        semantic_addedEdges.removeAll(arrayList);
        this.semantic_removedNodes.removeAll(arrayList2);
        this.semantic_removedEdges.removeAll(arrayList4);
        this.vv.repaint();
    }

    public void hideNode(JungGraphNode jungGraphNode) {
        PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>> pairLR = this.hideNodeAggregator(jungGraphNode, new PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>>(new ArrayList(), new ArrayList()));
        if (this.jToggleButton_collapse.isSelected()) {
            this.semanticExpand(pairLR);
        }
        for (JungGraphEdge object : pairLR.getRight()) {
            this.dsg.removeEdge((Object)object);
            this.explore_removedEdges.add(object);
        }
        for (JungGraphNode jungGraphNode2 : pairLR.getLeft()) {
            this.dsg.removeVertex((Object)jungGraphNode2);
            this.explore_removedNodes.add(jungGraphNode2);
            jungGraphNode2.visible = false;
        }
        for (JungGraphNode jungGraphNode3 : pairLR.getLeft()) {
            this.on_graph_expanded_nodenames.remove(jungGraphNode3.getName());
        }
        this.vv.repaint();
        this.showing_all = false;
    }

    private PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>> hideNodeAggregator(JungGraphNode jungGraphNode, PairLR<ArrayList<JungGraphNode>, ArrayList<JungGraphEdge>> pairLR) {
        if (jungGraphNode.isWftNode()) {
            pairLR.getLeft().add(jungGraphNode);
            pairLR.getRight().addAll(jungGraphNode.getUpCableset());
            pairLR.getRight().addAll(jungGraphNode.getDownCableset());
            for (JungGraphEdge jungGraphEdge : jungGraphNode.getUpCableset()) {
                if (!jungGraphEdge.from.isVisible()) continue;
                pairLR = this.hideNodeAggregator(jungGraphEdge.from, pairLR);
            }
        } else {
            ArrayList<JungGraphEdge> arrayList = jungGraphNode.getUpCablesetMinusFS();
            for (JungGraphEdge jungGraphEdge : arrayList) {
                if (!jungGraphEdge.from.isWftNode()) continue;
                pairLR = this.hideNodeAggregator(jungGraphEdge.from, pairLR);
            }
            pairLR.getLeft().add(jungGraphNode);
        }
        return pairLR;
    }

    public void showNode(JungGraphNode jungGraphNode) {
        ArrayList<JungGraphNode> arrayList = this.showNode(jungGraphNode, new ArrayList<JungGraphNode>());
        if (this.jToggleButton_collapse.isSelected()) {
            this.semanticCollapse(arrayList);
        }
        for (JungGraphNode jungGraphNode2 : arrayList) {
            this.on_graph_expanded_nodenames.add(jungGraphNode2.getName());
        }
    }

    private ArrayList<JungGraphNode> showNode(JungGraphNode jungGraphNode, ArrayList<JungGraphNode> arrayList) {
        if (jungGraphNode.isVisible()) {
            return arrayList;
        }
        if (jungGraphNode.isWftNode()) {
            for (JungGraphEdge jungGraphEdge : jungGraphNode.getDownCableset()) {
                if (!jungGraphEdge.to.isVisible()) {
                    arrayList.addAll(this.showNode(jungGraphEdge.to, arrayList));
                }
                this.dsg.addEdge((Object)jungGraphEdge, (Object)jungGraphEdge.from, (Object)jungGraphEdge.to);
                this.explore_removedEdges.remove(jungGraphEdge);
            }
            arrayList.add(jungGraphNode);
            this.dsg.addVertex((Object)jungGraphNode);
            jungGraphNode.visible = true;
            this.explore_removedNodes.remove(jungGraphNode);
        } else {
            arrayList.add(jungGraphNode);
            this.dsg.addVertex((Object)jungGraphNode);
            jungGraphNode.visible = true;
            this.explore_removedNodes.remove(jungGraphNode);
        }
        this.vv.repaint();
        return arrayList;
    }

    public void hideUpCableset(JungGraphNode jungGraphNode) {
        for (JungGraphEdge jungGraphEdge : jungGraphNode.getUpCableset()) {
            if (!jungGraphEdge.from.isVisible() && (!collapsed || !this.isWftReplaced(jungGraphEdge.from))) continue;
            this.hideNode(jungGraphEdge.from);
        }
    }

    public void showUpCableset(JungGraphNode jungGraphNode) {
        for (JungGraphEdge jungGraphEdge : jungGraphNode.getUpCableset()) {
            if (jungGraphEdge.from.isVisible()) continue;
            this.showNode(jungGraphEdge.from);
        }
    }

    public void hideDownCableset(JungGraphNode jungGraphNode) {
        if (jungGraphNode.isVisible()) {
            this.hideNode(jungGraphNode);
        }
    }

    public void showDownCableset(JungGraphNode jungGraphNode) {
        for (JungGraphEdge jungGraphEdge : jungGraphNode.getDownCableset()) {
            if (jungGraphEdge.to.isVisible()) continue;
            this.showNode(jungGraphEdge.to);
        }
    }

    public HashMap<Caseframe, ArrayList<JungGraphEdge>> getHiddenUpCablesetCfs(JungGraphNode jungGraphNode) {
        HashMap<Caseframe, ArrayList<JungGraphEdge>> hashMap = new HashMap<Caseframe, ArrayList<JungGraphEdge>>();
        for (JungGraphEdge jungGraphEdge : jungGraphNode.getUpCableset()) {
            if ((jungGraphEdge.from.isVisible() || collapsed) && (!collapsed || this.isWftReplaced(jungGraphEdge.from))) continue;
            if (jungGraphEdge.from.isWftNode()) {
                if (hashMap.get(jungGraphEdge.from.cf) == null) {
                    ArrayList<JungGraphEdge> arrayList = new ArrayList<JungGraphEdge>();
                    arrayList.add(jungGraphEdge);
                    hashMap.put(jungGraphEdge.from.cf, arrayList);
                    continue;
                }
                hashMap.get(jungGraphEdge.from.cf).add(jungGraphEdge);
                continue;
            }
            System.out.println("We're missing some situation in showing up cfs");
        }
        return hashMap;
    }

    public HashMap<Caseframe, ArrayList<JungGraphEdge>> getVisibleUpCablesetCfs(JungGraphNode jungGraphNode) {
        HashMap<Caseframe, ArrayList<JungGraphEdge>> hashMap = new HashMap<Caseframe, ArrayList<JungGraphEdge>>();
        for (JungGraphEdge jungGraphEdge : jungGraphNode.getUpCableset()) {
            if (!jungGraphEdge.from.isVisible() && (!collapsed || !this.isWftReplaced(jungGraphEdge.from))) continue;
            if (jungGraphEdge.from.isWftNode()) {
                if (hashMap.get(jungGraphEdge.from.cf) == null) {
                    ArrayList<JungGraphEdge> arrayList = new ArrayList<JungGraphEdge>();
                    arrayList.add(jungGraphEdge);
                    hashMap.put(jungGraphEdge.from.cf, arrayList);
                    continue;
                }
                hashMap.get(jungGraphEdge.from.cf).add(jungGraphEdge);
                continue;
            }
            System.out.println("We're missing some situation in showing up cfs");
        }
        return hashMap;
    }

    protected void setStatusbarText(String string) {
        this.jLabel_status.setText(string);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_showInGraph = new JButton();
        this.jButton_hideAll = new JButton();
        this.jButton_showAll = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jSeparator2 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jToggleButton_lens = new JToggleButton();
        this.jToggleButton_collapse = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.jToolBar2 = new JToolBar();
        this.jLabel3 = new JLabel();
        this.jButton_scalePlus = new JButton();
        this.jButton_scaleMinus = new JButton();
        this.jButton_scaleReset = new JButton();
        this.jLabel_status = new JLabel();
        this.jToolBar1.setRollover(true);
        this.jButton_showInGraph.setText("Show In Graph");
        this.jButton_showInGraph.setFocusable(false);
        this.jButton_showInGraph.setHorizontalTextPosition(0);
        this.jButton_showInGraph.setVerticalTextPosition(3);
        this.jButton_showInGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_showInGraphActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jButton_showInGraph);
        this.jButton_hideAll.setText("Hide All");
        this.jButton_hideAll.setFocusable(false);
        this.jButton_hideAll.setHorizontalTextPosition(0);
        this.jButton_hideAll.setVerticalTextPosition(3);
        this.jButton_hideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_hideAllActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jButton_hideAll);
        this.jButton_showAll.setText("Show All");
        this.jButton_showAll.setFocusable(false);
        this.jButton_showAll.setHorizontalTextPosition(0);
        this.jButton_showAll.setVerticalTextPosition(3);
        this.jButton_showAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_showAllActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jButton_showAll);
        this.jLabel2.setText("Mouse:");
        this.jToolBar1.add(this.jLabel2);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Picking", "Transforming"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jComboBox1ActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jComboBox1);
        this.jToolBar1.add(this.jSeparator2);
        this.jLabel1.setText("View:");
        this.jToolBar1.add(this.jLabel1);
        this.jToggleButton_lens.setText("Lens");
        this.jToggleButton_lens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jToggleButton_lensActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jToggleButton_lens);
        this.jToggleButton_collapse.setText("Collapsed");
        this.jToggleButton_collapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jToggleButton_collapseActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.jToggleButton_collapse);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jLabel3.setFont(new Font("Ubuntu", 0, 12));
        this.jLabel3.setText("Zoom:");
        this.jToolBar2.add(this.jLabel3);
        this.jButton_scalePlus.setFont(new Font("Ubuntu", 0, 12));
        this.jButton_scalePlus.setText(" + ");
        this.jButton_scalePlus.setFocusable(false);
        this.jButton_scalePlus.setHorizontalTextPosition(0);
        this.jButton_scalePlus.setVerticalTextPosition(3);
        this.jButton_scalePlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_scalePlusActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.jButton_scalePlus);
        this.jButton_scaleMinus.setFont(new Font("Ubuntu", 0, 12));
        this.jButton_scaleMinus.setText(" - ");
        this.jButton_scaleMinus.setFocusable(false);
        this.jButton_scaleMinus.setHorizontalTextPosition(0);
        this.jButton_scaleMinus.setVerticalTextPosition(3);
        this.jButton_scaleMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_scaleMinusActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.jButton_scaleMinus);
        this.jButton_scaleReset.setFont(new Font("Ubuntu", 0, 12));
        this.jButton_scaleReset.setText(" Reset ");
        this.jButton_scaleReset.setFocusable(false);
        this.jButton_scaleReset.setHorizontalTextPosition(0);
        this.jButton_scaleReset.setVerticalTextPosition(3);
        this.jButton_scaleReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JungGraphPanel.this.jButton_scaleResetActionPerformed(actionEvent);
            }
        });
        this.jToolBar2.add(this.jButton_scaleReset);
        this.jLabel_status.setText(" ");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel_status).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 652, Short.MAX_VALUE).addComponent(this.jToolBar2, -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_status).addComponent(this.jToolBar2, -2, 18, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -2, -1, -2).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 362, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
    }

    private void jToggleButton_collapseActionPerformed(ActionEvent actionEvent) {
        if (this.jToggleButton_collapse.isSelected()) {
            collapsed = true;
            this.semanticCollapseAll();
        } else {
            this.semanticExpandAll();
            collapsed = false;
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent actionEvent) {
        if (this.jComboBox1.getSelectedItem().equals("Picking")) {
            this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        } else {
            this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        }
    }

    private void jToggleButton_lensActionPerformed(ActionEvent actionEvent) {
        if (this.jToggleButton_lens.isSelected()) {
            this.hyperbolicLayoutSupport.activate();
        } else {
            this.hyperbolicLayoutSupport.deactivate();
        }
        if (this.jComboBox1.getSelectedItem().equals("Picking")) {
            this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        } else {
            this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        }
    }

    private void jButton_scalePlusActionPerformed(ActionEvent actionEvent) {
        this.scaler.scale(this.vv, this.scaleAmt, this.vv.getCenter());
        ++this.scale_btn_click;
    }

    private void jButton_scaleMinusActionPerformed(ActionEvent actionEvent) {
        this.scaler.scale(this.vv, 1.0f / this.scaleAmt, this.vv.getCenter());
        --this.scale_btn_click;
    }

    private void jButton_scaleResetActionPerformed(ActionEvent actionEvent) {
        this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
        this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
        this.scale_btn_click = 0;
    }

    private void jButton_hideAllActionPerformed(ActionEvent actionEvent) {
        this.hideAll();
    }

    private void jButton_showAllActionPerformed(ActionEvent actionEvent) {
        this.showAll();
    }

    private void jButton_showInGraphActionPerformed(ActionEvent actionEvent) {
        FindQuery3 findQuery3 = new FindQuery3();
        findQuery3.setVisible(true);
    }

    class CustomEdgeLabelRenderer<V, E>
    implements Renderer.EdgeLabel<V, E> {
        CustomEdgeLabelRenderer() {
        }

        public Component prepareRenderer(RenderContext<V, E> renderContext, EdgeLabelRenderer edgeLabelRenderer, Object object, boolean bl, E e) {
            return renderContext.getEdgeLabelRenderer().getEdgeLabelRendererComponent(renderContext.getScreenDevice(), object, (Font)renderContext.getEdgeFontTransformer().transform(e), bl, e);
        }

        public void labelEdge(RenderContext<V, E> renderContext, edu.uci.ics.jung.algorithms.layout.Layout<V, E> layout, E e, String string) {
            if (string == null || string.length() == 0) {
                return;
            }
            Graph graph = layout.getGraph();
            Pair pair = graph.getEndpoints(e);
            Object object = pair.getFirst();
            Object object2 = pair.getSecond();
            if (!renderContext.getEdgeIncludePredicate().evaluate(Context.getInstance((Object)graph, e))) {
                return;
            }
            if (!renderContext.getVertexIncludePredicate().evaluate(Context.getInstance((Object)graph, (Object)object)) || !renderContext.getVertexIncludePredicate().evaluate(Context.getInstance((Object)graph, (Object)object2))) {
                return;
            }
            Point2D point2D = (Point2D)layout.transform(object);
            Point2D point2D2 = (Point2D)layout.transform(object2);
            point2D = renderContext.getMultiLayerTransformer().transform(Layer.LAYOUT, point2D);
            point2D2 = renderContext.getMultiLayerTransformer().transform(Layer.LAYOUT, point2D2);
            float f = (float)point2D.getX();
            float f2 = (float)point2D.getY();
            float f3 = (float)point2D2.getX();
            float f4 = (float)point2D2.getY();
            GraphicsDecorator graphicsDecorator = renderContext.getGraphicsContext();
            float f5 = f3 - f;
            float f6 = f4 - f2;
            double d = Math.sqrt(f5 * f5 + f6 * f6);
            double d2 = ((Number)renderContext.getEdgeLabelClosenessTransformer().transform(Context.getInstance((Object)graph, e))).doubleValue();
            int n = (int)((double)f + d2 * (double)f5);
            int n2 = (int)((double)f2 + d2 * (double)f6);
            int n3 = (int)((double)renderContext.getLabelOffset() * ((double)f6 / d));
            int n4 = (int)((double)renderContext.getLabelOffset() * ((double)(-f5) / d));
            Component component = this.prepareRenderer(renderContext, renderContext.getEdgeLabelRenderer(), string, renderContext.getPickedEdgeState().isPicked(e), e);
            Dimension dimension = component.getPreferredSize();
            Shape shape = (Shape)renderContext.getEdgeShapeTransformer().transform(Context.getInstance((Object)graph, e));
            double d3 = 1.0;
            if (renderContext.getParallelEdgeIndexFunction().getIndex(graph, e) > 0) {
                d3 += (double)renderContext.getParallelEdgeIndexFunction().getIndex(graph, e);
                d3 *= (double)dimension.height;
                if (shape instanceof Ellipse2D) {
                    d3 += shape.getBounds().getHeight();
                    d3 = -d3;
                }
            } else {
                d3 = 20.0;
            }
            AffineTransform affineTransform = graphicsDecorator.getTransform();
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.translate(n + n3, n2 + n4);
            double d4 = f3 - f;
            double d5 = f4 - f2;
            if (renderContext.getEdgeLabelRenderer().isRotateEdgeLabels()) {
                double d6 = Math.atan2(d5, d4);
                if (d4 < 0.0) {
                    d6 += Math.PI;
                }
                affineTransform2.rotate(d6);
            }
            if (d4 < 0.0) {
                d3 = -d3;
            }
            affineTransform2.translate(-dimension.width / 2, -((double)(dimension.height / 2) - d3));
            graphicsDecorator.setTransform(affineTransform2);
            graphicsDecorator.draw(component, renderContext.getRendererPane(), 0, 0, dimension.width, dimension.height, true);
            graphicsDecorator.setTransform(affineTransform);
        }
    }

    class NodeShapeTransformer<St, Ss>
    implements Transformer<JungGraphNode, Shape> {
        private DirectedSparseMultigraph d;

        NodeShapeTransformer() {
        }

        @Override
        public Shape transform(JungGraphNode jungGraphNode) {
            int n = JungGraphPanel.this.vv.getFontMetrics(JungGraphPanel.this.vv.getFont()).stringWidth(jungGraphNode.toString()) + 10;
            return new RoundRectangle2D.Float(n / 2 * -1, -7.0f, n, 15.0f, 5.0f, 5.0f);
        }
    }

    static enum GraphType {
        FR3d,
        FR2d;

    }
}

