/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.Context;
import edu.buffalo.cse.sneps3.gui.IController;
import edu.buffalo.cse.sneps3.gui.SemanticType;
import edu.buffalo.cse.sneps3.gui.Slot;
import java.util.ArrayList;

public class Model {
    ArrayList<IController> views;
    ArrayList<Slot> slots = new ArrayList();
    ArrayList<Caseframe> caseframes = new ArrayList();
    ArrayList<SemanticType> types = new ArrayList();
    ArrayList<Context> contexts = new ArrayList();
    Context currentContext;

    public Model() {
        this.views = new ArrayList();
    }

    public void registerView(IController iController) {
        this.views.add(iController);
    }

    public void unregisterView(IController iController) {
        this.views.remove(iController);
    }

    public void recvUpdatedCaseframes(ArrayList<Caseframe> arrayList) {
        this.caseframes = arrayList;
    }

    public void recvUpdatedSlots(ArrayList<Slot> arrayList) {
        this.slots = arrayList;
    }

    public void recvUpdatedTypes(ArrayList<SemanticType> arrayList) {
        this.types = arrayList;
    }

    public void selectCurrentContext(Context context) {
        this.currentContext = context;
        for (IController iController : this.views) {
            iController.ctCurrent(context);
        }
    }

    public void addNewCaseframe(Caseframe caseframe) {
        this.caseframes.add(caseframe);
        for (IController iController : this.views) {
            iController.cfUpdate(this.caseframes);
        }
    }

    public void addNewSlot(Slot slot) {
        this.slots.add(slot);
        for (IController iController : this.views) {
            iController.slotUpdate(this.slots);
        }
    }

    public void addNewType(SemanticType semanticType) {
        this.types.add(semanticType);
        for (IController iController : this.views) {
            iController.stUpdate(this.types);
        }
    }

    public void addNewContext(Context context) {
        this.contexts.add(context);
        for (IController iController : this.views) {
            iController.ctUpdate(this.contexts);
        }
    }

    public void clearContexts() {
        this.contexts.clear();
        for (IController iController : this.views) {
            iController.ctUpdate(this.contexts);
        }
    }

    public void clearSlots() {
        this.slots.clear();
        for (IController iController : this.views) {
            iController.slotUpdate(this.slots);
        }
    }

    public void clearCaseframes() {
        this.caseframes.clear();
        for (IController iController : this.views) {
            iController.cfUpdate(this.caseframes);
        }
    }

    public Caseframe getCaseframeByNameAndSlots(String string, ArrayList arrayList) {
        for (Caseframe caseframe : this.caseframes) {
            if (caseframe.name.equals(string) && caseframe.slotnames.containsAll(arrayList)) {
                return caseframe;
            }
            if (caseframe.fsymbols == null || !caseframe.slotnames.containsAll(arrayList)) continue;
            for (String string2 : caseframe.fsymbols) {
                if (!string2.equals(string)) continue;
                return caseframe;
            }
        }
        return null;
    }

    public Slot getSlotByName(String string) {
        for (Slot slot : this.slots) {
            if (!slot.name.equals(string)) continue;
            return slot;
        }
        return null;
    }
}

