/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import edu.buffalo.cse.sneps3.gui.Caseframe;
import edu.buffalo.cse.sneps3.gui.CaseframeBasedShowHideDialog;
import edu.buffalo.cse.sneps3.gui.GUI2;
import edu.buffalo.cse.sneps3.gui.JungGraphEdge;
import edu.buffalo.cse.sneps3.gui.JungGraphNode;
import edu.buffalo.cse.sneps3.gui.JungGraphPanel;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class SnepsModalGraphMouse<V, E>
extends DefaultModalGraphMouse
implements MouseListener,
MouseMotionListener {
    JPopupMenu popup = new JPopupMenu();

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        GUI2.getInstance().getGraphPanel().highlightedNodes.clear();
        if (mouseEvent.getButton() != 3) {
            this.popup.setVisible(false);
        }
        if (mouseEvent.getButton() == 3) {
            VisualizationViewer visualizationViewer = (VisualizationViewer)mouseEvent.getSource();
            GraphElementAccessor graphElementAccessor = visualizationViewer.getPickSupport();
            Layout layout = visualizationViewer.getGraphLayout();
            Point point = mouseEvent.getPoint();
            Object object = graphElementAccessor.getVertex(layout, ((Point2D)point).getX(), ((Point2D)point).getY());
            final JungGraphNode jungGraphNode = (JungGraphNode)object;
            if (object == null) {
                this.popup.setVisible(false);
                return;
            }
            this.popup.setVisible(false);
            this.popup.removeAll();
            int n = jungGraphNode.getDownCablesetVisibleCount();
            int n2 = jungGraphNode.getUpCablesetVisibleCount();
            if (n2 < jungGraphNode.getUpCableset().size()) {
                this.popup.add(new AbstractAction("Show All In Edges (" + (jungGraphNode.getUpCableset().size() - n2) + " edges)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JungGraphPanel.instance.showUpCableset(jungGraphNode);
                    }
                });
                this.popup.add(new AbstractAction("Show In Edges By Relation"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HashMap<Caseframe, ArrayList<JungGraphEdge>> hashMap = JungGraphPanel.instance.getHiddenUpCablesetCfs(jungGraphNode);
                        CaseframeBasedShowHideDialog caseframeBasedShowHideDialog = new CaseframeBasedShowHideDialog((Frame)GUI2.getInstance(), new ArrayList<Caseframe>(hashMap.keySet()));
                        caseframeBasedShowHideDialog.setHelpText("   Select the Caseframes you        wish to show in the graph.");
                        caseframeBasedShowHideDialog.setVisible(true);
                        for (Caseframe caseframe : caseframeBasedShowHideDialog.getResult()) {
                            for (JungGraphEdge jungGraphEdge : hashMap.get(caseframe)) {
                                JungGraphPanel.instance.showNode(jungGraphEdge.from);
                            }
                        }
                    }
                });
            }
            if (n < jungGraphNode.getDownCableset().size()) {
                this.popup.add(new AbstractAction("Show All Out Edges (" + (jungGraphNode.getDownCableset().size() - n) + " edges)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JungGraphPanel.instance.showDownCableset(jungGraphNode);
                    }
                });
            }
            if (n2 > 0) {
                this.popup.add(new AbstractAction("Hide All In Edges (" + n2 + " edges)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JungGraphPanel.instance.hideUpCableset(jungGraphNode);
                    }
                });
                this.popup.add(new AbstractAction("Hide In Edges By Relation"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HashMap<Caseframe, ArrayList<JungGraphEdge>> hashMap = JungGraphPanel.instance.getVisibleUpCablesetCfs(jungGraphNode);
                        CaseframeBasedShowHideDialog caseframeBasedShowHideDialog = new CaseframeBasedShowHideDialog((Frame)GUI2.getInstance(), new ArrayList<Caseframe>(hashMap.keySet()));
                        caseframeBasedShowHideDialog.setHelpText("   Select the Caseframes you       wish to hide from the graph.");
                        caseframeBasedShowHideDialog.setVisible(true);
                        for (Caseframe caseframe : caseframeBasedShowHideDialog.getResult()) {
                            for (JungGraphEdge jungGraphEdge : hashMap.get(caseframe)) {
                                JungGraphPanel.instance.hideNode(jungGraphEdge.from);
                            }
                        }
                    }
                });
            }
            if (n > 0 && !jungGraphNode.isWftNode()) {
                this.popup.add(new AbstractAction("Hide All Out Edges (" + n + " edges)"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JungGraphPanel.instance.hideDownCableset(jungGraphNode);
                    }
                });
            }
            this.popup.add(new AbstractAction("Hide Node"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JungGraphPanel.instance.hideNode(jungGraphNode);
                }
            });
            if (jungGraphNode.isWftNode() && !jungGraphNode.asserted) {
                this.popup.add(new AbstractAction("Assert"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        GUI2.getInstance().makeLispCall("(ct::add-to-context '" + jungGraphNode.name + " (currentContext))");
                        jungGraphNode.asserted = true;
                        GUI2.getInstance().getGraphPanel().vv.repaint();
                    }
                });
            }
            this.popup.show((Component)visualizationViewer, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
        VisualizationViewer visualizationViewer = (VisualizationViewer)mouseEvent.getSource();
        GraphElementAccessor graphElementAccessor = visualizationViewer.getPickSupport();
        Layout layout = visualizationViewer.getGraphLayout();
        Point point = mouseEvent.getPoint();
        Object object = graphElementAccessor.getVertex(layout, ((Point2D)point).getX(), ((Point2D)point).getY());
        JungGraphNode jungGraphNode = (JungGraphNode)object;
        if (object == null) {
            if (!GUI2.getInstance().showNewAssertions) {
                GUI2.getInstance().getGraphPanel().setStatusbarText("New assertions are not shown in the graph.");
            } else {
                GUI2.getInstance().getGraphPanel().setStatusbarText("");
            }
            return;
        }
        String string = "   " + jungGraphNode.toString();
        if (jungGraphNode.isWftNode()) {
            string = string + " " + jungGraphNode.buildLogicalForm();
        }
        if (!jungGraphNode.upCableset.isEmpty()) {
            string = string + " is in relation" + (jungGraphNode.upCableset.size() == 1 ? "" : "s") + ": " + new HashSet<Caseframe>(jungGraphNode.getCaseframesIn());
        }
        GUI2.getInstance().getGraphPanel().setStatusbarText(string);
    }
}

