/*
 * Decompiled with CFR 0.152.
 */
package edu.buffalo.cse.sneps3.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class pdfViewer {
    JFrame mainFrame = new JFrame("JavaME Viewer");
    PdfDecoder pdfPane = new PdfDecoder(true);
    JScrollPane scollPane = new JScrollPane((Component)this.pdfPane);
    JPanel navButtons = new JPanel(new GridBagLayout());
    GridBagConstraints gbc = new GridBagConstraints();
    JTextField page = new JTextField();
    JLabel pageCount = new JLabel();
    JButton next = new JButton(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fforward.gif")));
    JButton previous = new JButton(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fback.gif")));
    int currentPage = 1;
    WindowListener wl = new WindowListener(){

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            System.exit(1);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }
    };

    public static void main(String[] stringArray) {
    }

    public pdfViewer(String string) {
        this.init(string);
    }

    public int init(String string) {
        this.mainFrame.addWindowListener(this.wl);
        this.setupNavButtons();
        this.setPdfDisplay();
        this.mainFrame.setVisible(true);
        try {
            this.openFile(string);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
            return -1;
        }
        return 0;
    }

    private void setupNavButtons() {
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (pdfViewer.this.currentPage < pdfViewer.this.pdfPane.getPageCount()) {
                    ++pdfViewer.this.currentPage;
                    pdfViewer.this.drawPage();
                }
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (pdfViewer.this.currentPage > 1) {
                    --pdfViewer.this.currentPage;
                    pdfViewer.this.drawPage();
                }
            }
        });
        this.gbc.fill = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.navButtons.add((Component)this.previous, this.gbc);
        this.gbc.gridx = 1;
        this.navButtons.add((Component)this.page, this.gbc);
        this.gbc.gridx = 2;
        this.navButtons.add((Component)this.pageCount, this.gbc);
        this.gbc.gridx = 3;
        this.navButtons.add((Component)this.next, this.gbc);
    }

    private void setPdfDisplay() {
        this.mainFrame.getContentPane().removeAll();
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.scollPane, "Center");
        this.mainFrame.getContentPane().add((Component)this.navButtons, "South");
        this.mainFrame.pack();
        this.mainFrame.repaint();
    }

    private void setDisplay(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        this.mainFrame.getContentPane().removeAll();
        this.mainFrame.getContentPane().add((Component)jComponent, "West");
        this.mainFrame.getContentPane().add((Component)jComponent2, "Center");
        this.mainFrame.getContentPane().add((Component)jComponent3, "East");
        this.mainFrame.getContentPane().add((Component)this.navButtons, "South");
        this.mainFrame.pack();
        this.mainFrame.repaint();
    }

    public void openFile(String string) throws PdfException {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setAlignmentX(0.0f);
        jProgressBar.setIndeterminate(true);
        this.gbc.gridx = 4;
        this.gbc.gridwidth = 2;
        this.navButtons.add((Component)jProgressBar, this.gbc);
        this.mainFrame.pack();
        this.mainFrame.repaint();
        this.pdfPane.openPdfFile(string);
        while (!this.pdfPane.isOpen()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.drawPage();
        this.pageCount.setText(" / " + this.pdfPane.getPageCount());
        this.navButtons.remove(jProgressBar);
        this.mainFrame.pack();
        this.mainFrame.repaint();
    }

    public void drawPage() {
        try {
            this.page.setText("" + this.currentPage);
            this.pdfPane.decodePage(this.currentPage);
            this.pdfPane.setPageParameters(1.0f, 1);
            this.pdfPane.waitForDecodingToFinish();
            this.scollPane.invalidate();
            this.scollPane.validate();
            this.scollPane.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

