/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freehep.util.export.ExportFileType;
import org.freehep.util.export.MimeTypes;

public class ExportFileTypeGroups {
    public static final String VECTOR = "vector";
    public static final String BITMAP = "bitmap";
    public static final String OTHER = "other";
    public static final String ALTERNATIVE = "alternative";
    private List groupNames = new ArrayList();
    private Map groups;
    private List alternatives;
    private Map labels;

    public ExportFileTypeGroups(List exportFileTypes) {
        this.groupNames.add(VECTOR);
        this.groupNames.add(BITMAP);
        this.groupNames.add(OTHER);
        this.groupNames.add(ALTERNATIVE);
        this.labels = new HashMap();
        this.labels.put(VECTOR, "Vector Formats");
        this.labels.put(BITMAP, "Bitmap Formats");
        this.labels.put(OTHER, "Other");
        this.labels.put(ALTERNATIVE, "Alternative Formats");
        this.groups = new HashMap();
        this.alternatives = new ArrayList();
        for (ExportFileType exportFileType : exportFileTypes) {
            String extension;
            String mimeType = exportFileType.getMIMETypes()[0];
            String key = MimeTypes.isBitmap(mimeType) ? BITMAP : (MimeTypes.isVector(mimeType) ? VECTOR : OTHER);
            HashMap<String, ExportFileType> fileTypes = (HashMap<String, ExportFileType>)this.groups.get(key);
            if (fileTypes == null) {
                fileTypes = new HashMap<String, ExportFileType>();
                this.groups.put(key, fileTypes);
            }
            if (fileTypes.get(extension = exportFileType.getExtensions()[0]) == null) {
                fileTypes.put(extension, exportFileType);
                continue;
            }
            this.alternatives.add(exportFileType);
        }
    }

    public List getExportFileTypes(String group) {
        ArrayList result = new ArrayList();
        if (group.equals(ALTERNATIVE)) {
            result.addAll(this.alternatives);
        } else {
            Map fileTypes = (Map)this.groups.get(group);
            if (fileTypes != null) {
                result.addAll(fileTypes.values());
            }
        }
        return result;
    }

    public List getGroupNames() {
        return this.groupNames;
    }

    public String getLabel(String group) {
        return (String)this.labels.get(group);
    }
}

