/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.freehep.graphics2d.TagHandler;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.FontUtilities;

public class GenericTagHandler
extends TagHandler {
    public static Integer UNDERLINE_OVERLINE = new Integer(128);
    private Graphics2D graphics;
    private StringBuffer clearedText;
    private Vector attributes;
    private Hashtable tags;
    private Stack fontFamilyStack;
    private double superscriptCorrection;

    public GenericTagHandler(Graphics2D graphics) {
        this.graphics = graphics;
        this.clearedText = new StringBuffer();
        this.tags = new Hashtable();
    }

    public void print(TagString s, double x, double y, double superscriptCorrection) {
        this.fontFamilyStack = new Stack();
        this.clearedText = new StringBuffer();
        this.attributes = new Vector();
        this.superscriptCorrection = superscriptCorrection;
        this.parse(s);
        while (this.tags.size() > 0) {
            this.closeTag((String)this.tags.keys().nextElement());
        }
        AttributedString attributedString = new AttributedString(this.clearedText.toString(), FontUtilities.getAttributes(this.graphics.getFont()));
        for (int i = 0; i < this.attributes.size(); ++i) {
            ((AttributeEntry)this.attributes.elementAt(i)).apply(attributedString);
        }
        this.graphics.drawString(attributedString.getIterator(), (float)x, (float)y);
    }

    public TextLayout createTextLayout(TagString s, double superscriptCorrection) {
        this.fontFamilyStack = new Stack();
        this.clearedText = new StringBuffer();
        this.attributes = new Vector();
        this.superscriptCorrection = superscriptCorrection;
        this.parse(s);
        while (this.tags.size() > 0) {
            this.closeTag((String)this.tags.keys().nextElement());
        }
        AttributedString attributedString = new AttributedString(this.clearedText.toString(), FontUtilities.getAttributes(this.graphics.getFont()));
        for (int i = 0; i < this.attributes.size(); ++i) {
            ((AttributeEntry)this.attributes.elementAt(i)).apply(attributedString);
        }
        return new TextLayout(attributedString.getIterator(), this.graphics.getFontRenderContext());
    }

    @Override
    protected String openTag(String tag) {
        if (!this.tags.containsKey(tag)) {
            this.tags.put(tag, new Integer(this.clearedText.length()));
        }
        return "";
    }

    @Override
    protected String closeTag(String tag) {
        if (!this.tags.containsKey(tag)) {
            return super.closeTag(tag);
        }
        int begin = (Integer)this.tags.get(tag);
        this.tags.remove(tag);
        if (tag.equalsIgnoreCase("b")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD));
        } else if (tag.equalsIgnoreCase("i")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE));
        } else if (tag.equalsIgnoreCase("s") || tag.equalsIgnoreCase("strike")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON));
        } else if (tag.equalsIgnoreCase("udash")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DASHED));
        } else if (tag.equalsIgnoreCase("udot")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_DOTTED));
        } else if (tag.equalsIgnoreCase("u")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON));
        } else if (tag.equalsIgnoreCase("tt")) {
            this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.FAMILY, this.fontFamilyStack.pop()));
        } else if (!tag.equalsIgnoreCase("v")) {
            if (tag.equalsIgnoreCase("over")) {
                this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.UNDERLINE, UNDERLINE_OVERLINE));
            } else if (tag.equalsIgnoreCase("sup")) {
                this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.TRANSFORM, AffineTransform.getTranslateInstance(0.0, this.superscriptCorrection)));
                this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER));
            } else if (tag.equalsIgnoreCase("sub")) {
                this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.TRANSFORM, AffineTransform.getTranslateInstance(0.0, -this.superscriptCorrection)));
                this.attributes.add(new AttributeEntry(begin, this.clearedText.length(), TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB));
            } else {
                return super.closeTag(tag);
            }
        }
        return "";
    }

    @Override
    protected String text(String text) {
        this.clearedText.append(text);
        return text;
    }

    private class AttributeEntry {
        private int begin;
        private int end;
        private TextAttribute textAttribute;
        private Object value;

        protected AttributeEntry(int begin, int end, TextAttribute textAttribute, Object value) {
            this.begin = begin;
            this.end = end;
            this.textAttribute = textAttribute;
            this.value = value;
        }

        protected void apply(AttributedString as) {
            as.addAttribute(this.textAttribute, this.value, this.begin, this.end);
        }
    }
}

