/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLCommonImplementation;
import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.JavaLinkDistIF;
import com.franz.jlinker.JavaLinkNotifier;
import com.franz.jlinker.JavaLinkRoot;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallSocket;
import com.franz.jlinker.TranStruct;
import com.franz.jlinker.Transport;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class JLCommonSocket
extends JavaLinkCommon
implements JLCommonImplementation {
    static final int socket_version = 8001001;
    public static Transport client_object;
    public JavaLinkNotifier lisp_notifier;
    public int notify_seq = -1;
    public static String default_l2j;
    public String l2j_ior = "";
    public static String default_j2l;
    public String j2l_ior = "";
    public static JavaLinkRoot server_object;
    int linkPort = 0;
    String linkHost = "";
    String javaHost = "";
    int javaPort = 0;

    public JLCommonSocket(String[] stringArray) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        this.linkPort = 0;
        this.linkHost = "";
        this.javaHost = "";
        this.javaPort = 0;
        this.j2l_ior = "";
        this.scanargs(stringArray);
        server_object = null;
        this.startL2JServer(true);
    }

    public JLCommonSocket(String string, String string2, int n, String string3, int n2) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        this.linkPort = n;
        this.linkHost = string2;
        this.javaHost = string3;
        this.javaPort = n2;
        this.j2l_ior = string;
        server_object = null;
        this.startL2JServer(true);
    }

    public JLCommonSocket(JavaLinkRoot javaLinkRoot) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        server_object = javaLinkRoot;
        this.linkPort = javaLinkRoot.linkPort;
        this.linkHost = javaLinkRoot.linkHost;
        this.j2l_ior = "";
        this.startL2JServer(false);
    }

    void startL2JServer(boolean bl) throws IllegalArgumentException {
        Object object;
        this.version = 8001001;
        JLCommonSocket.dprint("JLCommonSocket: starting up.");
        client_object = null;
        JLCommonSocket.dprint("JLCommonSocket: set lisp_notifier.");
        this.lisp_notifier = new JavaLinkNotifier();
        JLCommonSocket.dprint("JLCommonSocket: lisp_notifier is set.");
        if (this.linkPort == 0) {
            if (this.j2l_ior == "") {
                this.j2l_ior = default_j2l;
            }
            object = Transport.connectToServer(this.j2l_ior);
        } else {
            object = Transport.connectToServer(this.linkHost, this.linkPort);
        }
        if (Transport.isP(object)) {
            if (bl) {
                server_object = new JavaLinkRoot("", this.javaHost, this.javaPort);
            }
            client_object = Transport.coerce(object);
            JLCommonSocket.dprint("JLCommonSocket: client_object is set - " + client_object);
            if (bl) {
                this.notifyLisp("announceServer", 0, JLCommonSocket.server_object.advertisedHost, new int[]{server_object.advertisingOnPort()});
            }
            JavaLinkDist.openDist(new JavaLinkDistIF());
            if (bl) {
                server_object.start();
            }
        } else {
            JLCommonSocket.dprint("JLCommonSocket: connectToServer failed " + object);
            throw new IllegalArgumentException("Lisp to Java: connectToServer failed " + object);
        }
        JLCommonSocket.dprint("JLCommonSocket: serverState==" + JLCommonSocket.server_object.serverState);
        JLCommonSocket.dprint("Java VM version " + JLCommonSocket.versionStringOfJDK());
        JLCommonSocket.dprint("jLinker version " + this.version);
    }

    public int message(int n, String[] stringArray) {
        String string;
        int n2 = stringArray.length;
        int n3 = 0;
        switch (n2) {
            case 1: {
                string = stringArray[0];
                break;
            }
            case 0: {
                string = "<String[0]>";
                break;
            }
            default: {
                string = stringArray[0] + "..." + n2;
            }
        }
        JLCommonSocket.dprint("JLCommonSocket.message: " + n + "  Data: " + string);
        switch (n) {
            case 1: {
                if (client_object == null) {
                    n3 = 2;
                    break;
                }
                this.notifyLisp("connectToServer", 0, "");
                n3 = 1;
                break;
            }
            case 2: {
                if (!JavaLinkDist.defaultRemoteP(true)) break;
                n3 = 1;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            default: {
                JLCommonSocket.dprint("JLCommonSocket: round-trip message ignored.");
                n3 = -1;
            }
        }
        JLCommonSocket.dprint("JLCommonSocket.message: returning " + n3);
        return n3;
    }

    public void activate(int n, String[] stringArray) {
        JLCommonSocket.dprint("JLCommonSocket.activate: " + new Integer(n).toString());
        switch (n) {
            case 1: {
                JLCommonSocket.dprint("JLCommonSocket: simple round-trip query.");
                if (client_object == null) {
                    JLCommonSocket.dprint("JLCommonSocket: client_object==null");
                    break;
                }
                this.notifyLisp("serverIsLive", 0, "");
                break;
            }
            case 99: {
                JLCommonSocket.dprint("JLCommonSocket: shutdown.");
                JavaLinkDist.connectionComplete();
                try {
                    Thread.yield();
                    if (client_object != null) {
                        client_object.disconnect();
                    }
                    Thread.sleep(100L);
                    JavaLinkDist.closeDist();
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                JLCommonSocket.dprint("JLCommonSocket: one-way message ignored.");
            }
        }
    }

    public void scanargs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-debug")) {
                JavaLinkCommon.sdebug = true;
                continue;
            }
            if (stringArray[i].equals("-lhost")) {
                this.linkHost = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-jhost")) {
                this.javaHost = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-lport")) {
                try {
                    this.linkPort = Integer.parseInt(stringArray[++i]);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!stringArray[i].equals("-jport")) continue;
            try {
                this.javaPort = Integer.parseInt(stringArray[++i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void dprint(String string) {
        JavaLinkCommon.dsprint(string);
    }

    void notifyLisp(String string, int n, String string2) {
        ++this.notify_seq;
        JLCommonSocket.dprint("notifyLisp sending: " + string);
        this.lisp_notifier.notifyLispShort(string, n, this.notify_seq, string2);
        JLCommonSocket.dprint("notifyLisp sent: " + string);
    }

    void notifyLisp(String string, int n, String string2, int[] nArray) {
        ++this.notify_seq;
        JLCommonSocket.dprint("notifyLisp sending: " + string);
        this.lisp_notifier.notifyLispLongs(string, n, this.notify_seq, string2, nArray);
        JLCommonSocket.dprint("notifyLisp sent: " + string);
    }

    void notifyLisp(String string, int n, String[] stringArray) {
        ++this.notify_seq;
        JLCommonSocket.dprint("notifyLisp sending: " + string);
        this.lisp_notifier.notifyLispStrings(string, n, this.notify_seq, stringArray);
        JLCommonSocket.dprint("notifyLisp sent: " + string);
    }

    void notifyLisp(String string, int n, String[] stringArray, int[] nArray) {
        ++this.notify_seq;
        JLCommonSocket.dprint("notifyLisp sending: " + string);
        this.lisp_notifier.notifyLispBoth(string, n, this.notify_seq, stringArray, nArray);
        JLCommonSocket.dprint("notifyLisp sent: " + string);
    }

    int isRegistered(Object object) {
        if (client_object == null) {
            JLCommonSocket.dprint("JLCommonSocket.callLisp: client_object==null, ignoring");
            return 0;
        }
        int n = JavaLinkCommon.getSObHandle(object);
        if (n == 0) {
            return 0;
        }
        return n;
    }

    public int callLisp(String string, Object object) {
        int n = this.isRegistered(object);
        if (n == 0) {
            return 0;
        }
        this.notifyLisp(string, n, "");
        return this.notify_seq;
    }

    public int callLisp(String string, Object object, String string2) {
        int n = this.isRegistered(object);
        if (n == 0) {
            return 0;
        }
        this.notifyLisp(string, n, string2);
        return this.notify_seq;
    }

    public int callLisp(String string, Object object, String string2, int[] nArray) {
        int n = this.isRegistered(object);
        if (n == 0) {
            return 0;
        }
        this.notifyLisp(string, n, string2, nArray);
        return this.notify_seq;
    }

    public int callLisp(String string, Object object, String[] stringArray, int[] nArray) {
        int n = this.isRegistered(object);
        if (n == 0) {
            return 0;
        }
        this.notifyLisp(string, n, stringArray, nArray);
        return this.notify_seq;
    }

    public static int versionOfJDK() {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(JLCommonSocket.versionStringOfJDK(), ".");
        for (int i = 0; i < 3; ++i) {
            int n2;
            if (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
            n = n2 + n * 100;
        }
        return n;
    }

    public static String versionStringOfJDK() {
        try {
            return System.getProperty("java.vm.version", "1.1");
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    Class nameToClass(Object object) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        if (string.equals("java.lang.Class")) {
            return (Class)object;
        }
        if (string.equals("java.lang.String")) {
            try {
                return Class.forName((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Object().getClass();
    }

    public Object invoke0(Object object, String string) {
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Method method = clazz.getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object invoke1(Object object, String string, Object object2, Object object3) {
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[]{this.nameToClass(object2)};
            Object[] objectArray = new Object[]{object3};
            Method method = clazz.getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object invoke2(Object object, String string, Object object2, Object object3, Object object4, Object object5) {
        try {
            Class<?> clazz = object.getClass();
            Class[] classArray = new Class[]{this.nameToClass(object2), this.nameToClass(object4)};
            Object[] objectArray = new Object[]{object3, object5};
            Method method = clazz.getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object[] lispValuesOp(Object object, String string, int n, int n2, boolean bl) {
        TranStruct[] tranStructArray = (TranStruct[])object;
        String string2 = "";
        int n3 = -1;
        int n4 = tranStructArray.length;
        if (n4 == 1 && JavaLinkDist.errorP(tranStructArray[0])) {
            string2 = "LispError from " + string + ": " + JavaLinkDist.stringValue(tranStructArray[0], 0) + " " + JavaLinkDist.stringValue(tranStructArray[0], 1);
            JavaLinkDist.discardInLisp(tranStructArray[0]);
        } else if (JavaLinkDist.integerP(tranStructArray[0])) {
            n3 = JavaLinkDist.intValue(tranStructArray[0]);
            if (n3 != n4 - 1) {
                string2 = "Strange result (r[0] not length) " + string + ": " + tranStructArray.toString();
            } else if (n3 < n || n3 > n2) {
                string2 = "Unexpected values count from " + string + ": " + new Integer(n3).toString();
            } else if (n3 > 0 && bl && !JavaLinkDist.pointerP(tranStructArray[1])) {
                string2 = "Unexpected value returned from " + string + ": " + tranStructArray[1].toString();
            }
        } else {
            string2 = n4 == 0 ? "Strange zero-length result." : (n4 == 1 ? "Strange result(not err, not String) " + string + ": len=" + n4 + " " + tranStructArray[0] : (n4 == 2 ? "Strange result(not err, not String) " + string + ": len=" + n4 + " " + tranStructArray[0] + " " + tranStructArray[1] : "Strange result(not err, not String) " + string + ": len=" + n4 + " " + tranStructArray[0] + " " + tranStructArray[1] + " ..."));
        }
        return new Object[]{new Integer(n3), string2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(Object object) {
        Object object2 = object;
        synchronized (object2) {
            ((Object[])object)[1] = "open";
            object.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failRequest(Object object, String string) {
        Object object2 = object;
        synchronized (object2) {
            ((Object[])object)[1] = "open";
            ((Object[])object)[0] = string;
            object.notify();
        }
    }

    public static void main(String[] stringArray) throws IllegalArgumentException, InterruptedException {
        JLCommonSocket.dprint("JLCommonSocket: starting main.");
        new JLCommonSocket(stringArray);
        LispCall.prototype = new LispCallSocket();
        server_object.join();
        JLCommonSocket.dprint("JLCommonSocket: leaving main.");
        System.exit(0);
    }

    static {
        default_l2j = "LispToJava.trp";
        default_j2l = "JavaToLisp.trp";
    }
}

