/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLCommonSocket;
import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDistIF;
import com.franz.jlinker.JavaLinkRoot;
import com.franz.jlinker.TranStruct;
import com.franz.jlinker.Transport;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class JavaLinkDist {
    public static final String TR_HOMEImmediate = "Self";
    public static final int TR_NONE = 0;
    public static final int TR_RemoteWidth = 3;
    public static final int TR_IndirectShift = 0;
    public static final int TR_IMMEDIATE = 0;
    public static final int TR_INDIRECT = 1;
    public static final int TR_LastShift = 1;
    public static final int TR_KEEP = 0;
    public static final int TR_DISCARD = 1;
    public static final int TR_DiscardShift = 2;
    public static final int TR_LIVE = 0;
    public static final int TR_DISCARDED = 1;
    public static final int TR_RankWidth = 5;
    public static final int TR_RankShift = 3;
    public static final int TR_HIRANK = 31;
    public static final int TR_BaseWidth = 5;
    public static final int TR_ExtnWidth = 3;
    public static final int TR_BaseShift = 8;
    public static final int TR_ExtnShift = 13;
    public static final int TR_BYTE = 1;
    public static final int TR_SHORT = 2;
    public static final int TR_INT = 3;
    public static final int TR_LONG = 4;
    public static final int TR_CHAR = 5;
    public static final int TR_STRING = 6;
    public static final int TR_SINGLE = 7;
    public static final int TR_DOUBLE = 8;
    public static final int TR_BOOL = 9;
    public static final int TR_SYMBOL = 10;
    public static final int TR_MESSAGE = 30;
    public static final int TR_NULL = 31;
    public static final int TR_AggrWidth = 8;
    public static final int TR_AggrShift = 16;
    public static final int TR_AggrMask = 255;
    public static final int TR_POINTER = 1;
    public static final int TR_ARRAY = 4;
    public static final int TR_CLASS = 5;
    public static final int TR_CONSTRUCTOR = 6;
    public static final int TR_METHOD = 7;
    public static final int TR_ERROR = 61;
    public static final int TR_INDEXWIDTH = 29;
    public static final int TR_MKActivate = 1;
    public static final int TR_MKMessage = 2;
    public static final int TR_MKDiscard = 3;
    public static final int TR_MKInvoke = 4;
    public static final int TR_MKNotify = 5;
    public static final int TR_EXTNMASK = 57344;
    public static final int TR_EXBYTES = 8192;
    public static final int TR_EXSHORTS = 16384;
    public static final int TR_EXFLOATS = 24576;
    static JavaLinkDistIF remoteServer = null;
    static JavaLinkDist localServer = null;
    static boolean remoteReady = false;
    JavaLinkDistIF remoteSelf = null;
    static Hashtable table;
    static int connectIndex;
    static int nextIndex;
    static int tableLive;
    static int tableFree;
    static int oldestFree;
    static int newestFree;
    static int topIndex;
    String localName = "Java";
    static final Class structClass;
    static final String structName;
    Object nullMarker = new Integer(0);
    Object[] ans = new Object[3];
    static final int IGNORE = 0;
    static final int setIMM = 1;
    static final int setIND = 2;
    static final int setLIVE = 1;
    static final int setLAST = 2;
    static final int setDEAD = 3;

    public static Object lispError(LispException lispException) {
        return lispException.lispErr;
    }

    public static boolean query() {
        return JavaLinkDist.query(false);
    }

    public static boolean query(boolean bl) {
        if (JavaLinkDist.defaultRemoteP()) {
            if (bl) {
                TranStruct[] tranStructArray = JavaLinkDist.invokeInLisp(2, JavaLinkDist.newDistOb("cl:values"), new TranStruct[0]);
                if (tranStructArray.length == 1 && JavaLinkDist.integerP(tranStructArray[0]) && 0 == JavaLinkDist.intValue(tranStructArray[0])) {
                    return true;
                }
                JavaLinkDist.closeDist();
            } else {
                return true;
            }
        }
        return false;
    }

    public static void disconnect() {
        ((JLCommonSocket)JavaLinkCommon.ltoj_anchor).activate(99, new String[0]);
    }

    public static boolean advertise(int n, int n2) {
        return JavaLinkDist.advertiseInner(false, "", "", n, n2);
    }

    public static boolean advertise(String string, String string2, int n, int n2) {
        return JavaLinkDist.advertiseInner(true, string, string2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean advertiseInner(boolean bl, String string, String string2, int n, int n2) {
        JavaLinkRoot javaLinkRoot;
        if (JavaLinkDist.query(false)) {
            return true;
        }
        if (bl) {
            if (string.equals("")) {
                string = "LispToJava.trp";
            }
            javaLinkRoot = new JavaLinkRoot(string, string2, n);
        } else {
            if (n < 1) {
                return false;
            }
            javaLinkRoot = new JavaLinkRoot("", "", n);
        }
        javaLinkRoot.start();
        int n3 = 1;
        int n4 = 1;
        while (javaLinkRoot.linkPort == 0) {
            try {
                Object object;
                if (!(javaLinkRoot.isAlive() && n2 < 0 || javaLinkRoot.isAlive() && n2 != 0)) {
                    object = bl ? Transport.connectToServer(string) : Transport.connectToServer(n);
                    if (Transport.isP(object)) {
                        Transport transport = Transport.coerce(object);
                        transport.disconnect();
                    }
                    JavaLinkCommon.dsprint("JavaLinkDist.advertise FAILED.");
                    return false;
                }
                if (n3 < n4) {
                    ++n3;
                } else {
                    n3 = 0;
                    n4 = 2 * n4;
                    JavaLinkCommon.dsprint("JavaLinkDist.advertise: waiting for Lisp.");
                }
                object = javaLinkRoot;
                synchronized (object) {
                    javaLinkRoot.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 < 0) continue;
            --n2;
        }
        JavaLinkCommon.dsprint("JavaLinkDist.advertise: starting Anchor.");
        try {
            new JLCommonSocket(javaLinkRoot);
        }
        catch (Exception exception) {
            return false;
        }
        if (!JavaLinkDist.connectionComplete()) {
            return false;
        }
        JavaLinkCommon.dsprint("JavaLinkDist.advertise done.");
        return true;
    }

    public static boolean connectionComplete() {
        int n = 0;
        while (!JavaLinkDist.defaultRemoteP()) {
            try {
                if (JavaLinkDist.defaultRemoteP()) {
                    return true;
                }
                Thread.sleep(100L);
                if (JavaLinkDist.defaultRemoteP()) {
                    return true;
                }
                if (++n > 300) {
                    JavaLinkCommon.dsprint("JavaLinkDist: failing with timeout.");
                    return false;
                }
                if (n != 4 && n != 24 && n != 154) continue;
                JavaLinkCommon.dsprint("JavaLinkDist: waiting for remote server...");
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static boolean connect(String string, String string2, int n, int n2, int n3) {
        return JavaLinkDist.connectInner(true, string, "", 0, string2, n, n2, n3);
    }

    public static boolean connect(String string, int n, String string2, int n2, int n3, int n4) {
        return JavaLinkDist.connectInner(false, "", string, n, string2, n2, n3, n4);
    }

    static boolean connectInner(boolean bl, String string, String string2, int n, String string3, int n2, int n3, int n4) {
        if (JavaLinkDist.query(false)) {
            return true;
        }
        while (!JavaLinkDist.connectInner(bl, string, string2, n, string3, n2)) {
            n4 = n3 < 0 ? -1 : --n4;
            if (n4 < 0) {
                return false;
            }
            try {
                Thread.sleep(n3);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    static boolean connectInner(boolean bl, String string, String string2, int n, String string3, int n2) {
        if (JavaLinkDist.query(false)) {
            return true;
        }
        if (bl) {
            JavaLinkCommon.dsprint("JavaLinkDist.connect(" + string + ", " + string3 + ":" + n2 + ")");
            try {
                new JLCommonSocket(string, "", 0, string3, n2);
            }
            catch (Exception exception) {
                JavaLinkCommon.dsprint("JavaLinkDist.connect failed: " + exception);
                return false;
            }
        }
        JavaLinkCommon.dsprint("JavaLinkDist.connect(" + string2 + ":" + n + ", " + string3 + ":" + n2 + ")");
        try {
            new JLCommonSocket("", string2, n, string3, n2);
        }
        catch (Exception exception) {
            JavaLinkCommon.dsprint("JavaLinkDist.connect failed: " + exception);
            return false;
        }
        if (!JavaLinkDist.connectionComplete()) {
            return false;
        }
        JavaLinkCommon.dsprint("JavaLinkDist.connect done.");
        return true;
    }

    public static synchronized void initDist() {
        table = new Hashtable();
        nextIndex = 1001;
        tableLive = 0;
        tableFree = 0;
        oldestFree = 0;
        newestFree = 0;
        connectIndex = (int)(System.currentTimeMillis() >> 13 & (long)(topIndex - 1));
    }

    public static synchronized void closeDist() {
        JavaLinkDist.initDist();
        remoteServer = null;
        localServer = null;
        remoteReady = false;
    }

    public static int openDist(Object object) {
        if (localServer == null) {
            localServer = new JavaLinkDist();
        }
        return JavaLinkDist.openDist(object, localServer);
    }

    public static int openDist(Object object, JavaLinkDist javaLinkDist) {
        boolean bl = false;
        try {
            Method method = object.getClass().getMethod("openDist", new Class[0]);
            javaLinkDist.remoteSelf = (JavaLinkDistIF)method.invoke(object, new Object[0]);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return -1;
        }
        catch (SecurityException securityException) {
            return -2;
        }
        catch (IllegalAccessException illegalAccessException) {
            return -3;
        }
        catch (InvocationTargetException invocationTargetException) {
            return -4;
        }
        if (bl && remoteServer == null) {
            remoteServer = javaLinkDist.remoteSelf;
        }
        return 1;
    }

    public JavaLinkDist() {
        localServer = this;
        JavaLinkDist.initDist();
    }

    synchronized void registerJavaObject(Object object, TranStruct tranStruct) {
        int n;
        if (nextIndex < topIndex && (tableFree == 0 || 2 * tableFree < tableLive)) {
            n = nextIndex++;
        } else {
            n = oldestFree;
            oldestFree = (Integer)table.get(new Integer(oldestFree));
            --tableFree;
        }
        table.put(new Integer(n), object);
        tranStruct.nums[0] = n;
        tranStruct.nums[1] = connectIndex;
        ++tableLive;
    }

    synchronized String extractJavaType(TranStruct tranStruct) {
        if (tranStruct == this.ans[2]) {
            return (String)this.ans[0];
        }
        this.ans[1] = null;
        this.ans[2] = tranStruct;
        this.extractJavaItem(tranStruct);
        return (String)this.ans[0];
    }

    synchronized Object extractJavaRef(TranStruct tranStruct) {
        if (tranStruct == this.ans[2]) {
            return this.ans[1];
        }
        this.ans[1] = null;
        this.ans[2] = tranStruct;
        this.extractJavaItem(tranStruct);
        return this.ans[1];
    }

    void extractJavaItem(TranStruct tranStruct) {
        if (!JavaLinkDist.liveP(tranStruct)) {
            this.ans[0] = "err";
            this.ans[1] = "Discarded Object 1";
            return;
        }
        if (JavaLinkDist.remoteP(tranStruct)) {
            this.ans[0] = "remote";
            this.ans[1] = tranStruct;
            return;
        }
        if (JavaLinkDist.indirectP(tranStruct)) {
            Object v = table.get(new Integer(tranStruct.nums[0]));
            if (v == null) {
                this.ans[0] = "err";
                this.ans[1] = "Unregistered object 2";
                return;
            }
            if (v == this.nullMarker) {
                this.ans[0] = "err";
                this.ans[1] = "Discarded object";
                return;
            }
            this.ans[0] = "indirect";
            this.ans[1] = v;
            return;
        }
        if (JavaLinkDist.rankP(tranStruct, 0)) {
            this.ans[0] = "immediate";
            switch (JavaLinkDist.getTypeBits(tranStruct, 5, 8)) {
                case 10: {
                    this.ans[0] = "remote";
                    this.ans[1] = tranStruct;
                    return;
                }
                case 1: {
                    this.ans[1] = new Byte((byte)tranStruct.nums[0]);
                    break;
                }
                case 2: {
                    this.ans[1] = new Short((short)tranStruct.nums[0]);
                    break;
                }
                case 3: {
                    this.ans[1] = new Integer(tranStruct.nums[0]);
                    break;
                }
                case 4: {
                    this.ans[1] = new Long(JavaLinkDist.longValue(tranStruct));
                    break;
                }
                case 7: {
                    this.ans[1] = new Float((float)tranStruct.reals[0]);
                    break;
                }
                case 8: {
                    this.ans[1] = new Double(tranStruct.reals[0]);
                    break;
                }
                case 5: {
                    this.ans[1] = new Character(tranStruct.strings[0].charAt(0));
                    break;
                }
                case 6: {
                    this.ans[1] = tranStruct.strings[0];
                    break;
                }
                case 9: {
                    if (0 == tranStruct.nums[0]) {
                        this.ans[1] = Boolean.FALSE;
                        break;
                    }
                    this.ans[1] = Boolean.TRUE;
                    break;
                }
                case 31: {
                    break;
                }
                default: {
                    this.ans[1] = "Unknown object base type";
                    this.ans[0] = "err";
                }
            }
            return;
        }
        if (JavaLinkDist.rankP(tranStruct, 1)) {
            this.ans[0] = "immediate";
            switch (JavaLinkDist.getTypeBits(tranStruct, 5, 8)) {
                case 3: {
                    this.ans[1] = tranStruct.nums.clone();
                    break;
                }
                case 6: {
                    this.ans[1] = tranStruct.strings.clone();
                    break;
                }
                case 8: {
                    this.ans[1] = tranStruct.reals.clone();
                    break;
                }
                case 1: {
                    if (8192 == (0xE000 & tranStruct.type)) {
                        this.ans[1] = tranStruct.getExdata();
                        break;
                    }
                    byte[] byArray = new byte[tranStruct.nums.length];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)tranStruct.nums[i];
                    }
                    this.ans[1] = byArray;
                    break;
                }
                case 2: {
                    if (16384 == (0xE000 & tranStruct.type)) {
                        this.ans[1] = tranStruct.getExdata();
                        break;
                    }
                    short[] sArray = new short[tranStruct.nums.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)tranStruct.nums[i];
                    }
                    this.ans[1] = sArray;
                    break;
                }
                case 7: {
                    if (24576 == (0xE000 & tranStruct.type)) {
                        this.ans[1] = tranStruct.getExdata();
                        break;
                    }
                    float[] fArray = new float[tranStruct.reals.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = (float)tranStruct.reals[i];
                    }
                    this.ans[1] = fArray;
                    break;
                }
                default: {
                    this.ans[1] = "Unknown object base type";
                    this.ans[0] = "err";
                }
            }
            return;
        }
        this.ans[0] = "err";
        this.ans[1] = "Unknown object type";
    }

    public Class extractClassRef(TranStruct tranStruct, Object object) throws ClassNotFoundException, ClassCastException {
        if (JavaLinkDist.stringP(tranStruct)) {
            String string = (String)object;
            if (string.equals("bool")) {
                return Boolean.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("void")) {
                return Void.TYPE;
            }
            return Class.forName(string);
        }
        return (Class)object;
    }

    public void discard(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.discard(nArray[i]);
        }
    }

    public void discard(int n) {
        if (tableFree == 0) {
            oldestFree = n;
        } else {
            table.put(new Integer(newestFree), new Integer(n));
        }
        ++tableFree;
        newestFree = n;
        table.put(new Integer(n), this.nullMarker);
        --tableLive;
    }

    public void invokeOneWay(TranStruct tranStruct, TranStruct[] tranStructArray) {
        this.invoke(-1, tranStruct, tranStructArray);
    }

    public TranStruct[] invoke(int n, TranStruct tranStruct, TranStruct[] tranStructArray) {
        TranStruct[] tranStructArray2;
        int n2;
        int n3 = 1;
        String string = "";
        Class clazz = null;
        String string2 = "";
        int n4 = 0;
        String string3 = "Arg err:";
        boolean bl = false;
        Object object = null;
        String string4 = "";
        Object object2 = "";
        try {
            int n5 = 99;
            TranStruct tranStruct2 = tranStruct;
            String string5 = this.extractJavaType(tranStruct2);
            Object object3 = this.extractJavaRef(tranStruct2);
            Object object4 = new Object();
            if (string5.equalsIgnoreCase("err")) {
                string4 = "Op err: " + object3;
            } else if (JavaLinkDist.stringP(tranStruct2)) {
                string5 = (String)object3;
                if (tranStructArray.length == 1 && string5.equalsIgnoreCase("forName")) {
                    n5 = 1;
                } else if (tranStructArray.length > 1 && string5.equalsIgnoreCase("getMethod")) {
                    n5 = 2;
                } else if (tranStructArray.length > 0 && string5.equalsIgnoreCase("getConstructor")) {
                    n5 = 3;
                } else if (tranStructArray.length > 1 && string5.equalsIgnoreCase("newArray")) {
                    n5 = 6;
                } else if (tranStructArray.length == 3 && string5.equalsIgnoreCase("getField")) {
                    n5 = 7;
                } else if (tranStructArray.length == 4 && string5.equalsIgnoreCase("setField")) {
                    n5 = 8;
                } else if (tranStructArray.length == 2 && string5.equalsIgnoreCase("getStatic")) {
                    n5 = 9;
                } else if (tranStructArray.length == 3 && string5.equalsIgnoreCase("setStatic")) {
                    n5 = 10;
                } else if (tranStructArray.length == 0 && string5.equalsIgnoreCase("queryFree")) {
                    n5 = 51;
                } else if (tranStructArray.length == 0 && string5.equalsIgnoreCase("queryLive")) {
                    n5 = 52;
                } else {
                    string4 = "Unknown op string: " + string5;
                }
            } else if (string5.equalsIgnoreCase("indirect")) {
                string5 = object3.getClass().getName();
                if (tranStructArray.length > 0 && string5.equals("java.lang.reflect.Method")) {
                    n5 = 4;
                } else if (string5.equals("java.lang.reflect.Constructor")) {
                    n5 = 5;
                } else {
                    string4 = "Bad op class: " + string5;
                }
            } else {
                string4 = "Unknown op: " + string5;
            }
            switch (n5) {
                case 1: {
                    object = this.extractClassRef(tranStructArray[0], this.extractJavaRef(tranStructArray[0]));
                    break;
                }
                case 2: {
                    Object object5;
                    TranStruct tranStruct3;
                    Class[] classArray = new Class[tranStructArray.length - 2];
                    block28: for (n2 = 0; n2 < tranStructArray.length; ++n2) {
                        tranStruct3 = tranStructArray[n2];
                        string5 = this.extractJavaType(tranStruct3);
                        object5 = this.extractJavaRef(tranStruct3);
                        if (string5.equalsIgnoreCase("err")) {
                            ++n4;
                            string3 = string3 + " " + n2 + ": " + (String)object5 + " ";
                        }
                        switch (n2) {
                            case 0: {
                                clazz = this.extractClassRef(tranStruct3, object5);
                                continue block28;
                            }
                            case 1: {
                                string2 = (String)object5;
                                continue block28;
                            }
                            default: {
                                classArray[n2 - 2] = this.extractClassRef(tranStruct3, object5);
                            }
                        }
                    }
                    if (n4 > 0) {
                        bl = true;
                        string4 = string3;
                        break;
                    }
                    object = clazz.getMethod(string2, classArray);
                    break;
                }
                case 3: {
                    Object object5;
                    TranStruct tranStruct3;
                    Class[] classArray = new Class[tranStructArray.length - 1];
                    block29: for (n2 = 0; n2 < tranStructArray.length; ++n2) {
                        tranStruct3 = tranStructArray[n2];
                        string5 = this.extractJavaType(tranStruct3);
                        object5 = this.extractJavaRef(tranStruct3);
                        if (string5.equalsIgnoreCase("err")) {
                            ++n4;
                            string3 = string3 + " " + n2 + ": " + (String)object5 + " ";
                        }
                        switch (n2) {
                            case 0: {
                                clazz = this.extractClassRef(tranStruct3, object5);
                                continue block29;
                            }
                            default: {
                                classArray[n2 - 1] = this.extractClassRef(tranStruct3, object5);
                            }
                        }
                    }
                    if (n4 > 0) {
                        bl = true;
                        string4 = string3;
                        break;
                    }
                    object = clazz.getConstructor(classArray);
                    break;
                }
                case 6: {
                    Object object5;
                    TranStruct tranStruct3;
                    int[] nArray = new int[tranStructArray.length - 1];
                    block30: for (n2 = 0; n2 < tranStructArray.length; ++n2) {
                        tranStruct3 = tranStructArray[n2];
                        string5 = this.extractJavaType(tranStruct3);
                        object5 = this.extractJavaRef(tranStruct3);
                        if (string5.equalsIgnoreCase("err")) {
                            ++n4;
                            string3 = string3 + " " + n2 + ": " + (String)object5 + " ";
                        }
                        switch (n2) {
                            case 0: {
                                clazz = this.extractClassRef(tranStruct3, object5);
                                continue block30;
                            }
                            default: {
                                nArray[n2 - 1] = ((Number)object5).intValue();
                            }
                        }
                    }
                    if (n4 > 0) {
                        bl = true;
                        string4 = string3;
                        break;
                    }
                    object = Array.newInstance(clazz, nArray);
                    break;
                }
                case 7: {
                    clazz = this.extractClassRef(tranStructArray[0], this.extractJavaRef(tranStructArray[0]));
                    string5 = JavaLinkDist.stringValue(tranStructArray[1]);
                    Object object5 = this.extractJavaRef(tranStructArray[2]);
                    Field field = clazz.getField(string5);
                    object = field.get(object5);
                    n3 = 2;
                    string = field.getType().getName();
                    break;
                }
                case 8: {
                    clazz = this.extractClassRef(tranStructArray[0], this.extractJavaRef(tranStructArray[0]));
                    string5 = JavaLinkDist.stringValue(tranStructArray[1]);
                    Object object5 = this.extractJavaRef(tranStructArray[2]);
                    Field field = clazz.getField(string5);
                    object4 = this.extractJavaRef(tranStructArray[3]);
                    field.set(object5, object4);
                    n3 = 0;
                    object = new Integer(0);
                    break;
                }
                case 9: {
                    clazz = this.extractClassRef(tranStructArray[0], this.extractJavaRef(tranStructArray[0]));
                    string5 = JavaLinkDist.stringValue(tranStructArray[1]);
                    Field field = clazz.getField(string5);
                    object = field.get(null);
                    n3 = 2;
                    string = field.getType().getName();
                    break;
                }
                case 10: {
                    clazz = this.extractClassRef(tranStructArray[0], this.extractJavaRef(tranStructArray[0]));
                    string5 = JavaLinkDist.stringValue(tranStructArray[1]);
                    Field field = clazz.getField(string5);
                    object4 = this.extractJavaRef(tranStructArray[2]);
                    field.set(null, object4);
                    n3 = 0;
                    object = new Integer(0);
                    break;
                }
                case 4: {
                    Object object5;
                    TranStruct tranStruct3;
                    Object[] objectArray = new Object[tranStructArray.length - 1];
                    for (n2 = 0; n2 < tranStructArray.length; ++n2) {
                        tranStruct3 = tranStructArray[n2];
                        string5 = this.extractJavaType(tranStruct3);
                        object5 = this.extractJavaRef(tranStruct3);
                        if (string5.equalsIgnoreCase("err")) {
                            ++n4;
                            string3 = string3 + " " + n2 + ": " + (String)object5 + " ";
                        }
                        if (n2 == 0) {
                            object4 = object5;
                            continue;
                        }
                        objectArray[n2 - 1] = object5;
                    }
                    if (n4 > 0) {
                        bl = true;
                        string4 = string3;
                        break;
                    }
                    object = ((Method)object3).invoke(object4, objectArray);
                    n3 = 2;
                    string = ((Method)object3).getReturnType().getName();
                    break;
                }
                case 5: {
                    Object object5;
                    TranStruct tranStruct3;
                    Object[] objectArray = new Object[tranStructArray.length];
                    for (n2 = 0; n2 < tranStructArray.length; ++n2) {
                        tranStruct3 = tranStructArray[n2];
                        string5 = this.extractJavaType(tranStruct3);
                        object5 = this.extractJavaRef(tranStruct3);
                        if (string5.equalsIgnoreCase("err")) {
                            ++n4;
                            string3 = string3 + " " + n2 + ": " + (String)object5 + " ";
                        }
                        objectArray[n2] = object5;
                    }
                    if (n4 > 0) {
                        bl = true;
                        string4 = string3;
                        break;
                    }
                    object = ((Constructor)object3).newInstance(objectArray);
                    break;
                }
                case 51: {
                    object = new Integer(tableFree);
                    n3 = 0;
                    break;
                }
                case 52: {
                    object = new Integer(tableLive);
                    n3 = 0;
                    break;
                }
                case 99: {
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                    string4 = "Bad method ref";
                    break;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            bl = true;
            object2 = invocationTargetException.getTargetException();
            string4 = object2.toString();
        }
        catch (Throwable throwable) {
            bl = true;
            string4 = throwable.toString();
            object2 = throwable;
        }
        if (bl) {
            tranStructArray2 = new TranStruct[]{JavaLinkDist.newDistOb(string4), JavaLinkDist.newDistOb(object2)};
        } else if (n < 1) {
            tranStructArray2 = new TranStruct[]{};
        } else {
            tranStructArray2 = new TranStruct[2];
            tranStructArray2[0] = JavaLinkDist.newDistOb(1);
            tranStructArray2[1] = object == null ? JavaLinkDist.nullDistOb() : (n3 == 0 ? this.unwrap(object) : (n3 == 1 ? this.wrap(object) : (string.equals("java.lang.String") ? (n == 1 ? this.wrap(object) : this.unwrap(object)) : (string.equals("boolean") || string.equals("byte") || string.equals("char") || string.equals("double") || string.equals("float") || string.equals("int") || string.equals("long") || string.equals("short") ? this.unwrap(object) : (n == 1 ? this.wrap(object) : this.unwrap(object))))));
        }
        if (JavaLinkDist.lastUseP(tranStruct)) {
            this.discard(tranStruct.nums[0]);
        }
        for (n2 = 0; n2 < tranStructArray.length; ++n2) {
            if (!JavaLinkDist.lastUseP(tranStructArray[n2])) continue;
            this.discard(tranStructArray[n2].nums[0]);
        }
        return tranStructArray2;
    }

    TranStruct wrap(Object object) {
        String string = object.getClass().getName();
        if (string.equals(structName)) {
            return (TranStruct)object;
        }
        return JavaLinkDist.newDistOb(object);
    }

    TranStruct unwrap(Object object) {
        String string = object.getClass().getName();
        if (string.equals("java.lang.Boolean")) {
            return JavaLinkDist.newDistOb((Boolean)object);
        }
        if (string.equals("java.lang.Character")) {
            return JavaLinkDist.newDistOb(((Character)object).charValue());
        }
        if (string.equals("java.lang.Byte")) {
            return JavaLinkDist.newDistOb((Byte)object);
        }
        if (string.equals("java.lang.Short")) {
            return JavaLinkDist.newDistOb((Short)object);
        }
        if (string.equals("java.lang.Integer")) {
            return JavaLinkDist.newDistOb((Integer)object);
        }
        if (string.equals("java.lang.Long")) {
            return JavaLinkDist.newDistOb((Long)object);
        }
        if (string.equals("java.lang.Float")) {
            return JavaLinkDist.newDistOb(((Float)object).floatValue());
        }
        if (string.equals("java.lang.Double")) {
            return JavaLinkDist.newDistOb((Double)object);
        }
        if (string.equals("java.lang.String")) {
            return JavaLinkDist.newDistOb((String)object);
        }
        if (string.equals("[Ljava.lang.String;")) {
            return JavaLinkDist.newDistOb((String[])object);
        }
        if (string.equals("[B")) {
            return JavaLinkDist.newDistOb((byte[])object);
        }
        if (string.equals("[S")) {
            return JavaLinkDist.newDistOb((short[])object);
        }
        if (string.equals("[I")) {
            return JavaLinkDist.newDistOb((int[])object);
        }
        if (string.equals("[F")) {
            return JavaLinkDist.newDistOb((float[])object);
        }
        if (string.equals("[D")) {
            return JavaLinkDist.newDistOb((double[])object);
        }
        return this.wrap(object);
    }

    public static int getBits(int n, int n2, int n3) {
        int n4 = (1 << n2) - 1 << n3;
        return (n & n4) >> n3;
    }

    public static int setBits(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = (1 << n3) - 1 << n4;
        n5 |= n6;
        n5 ^= n6;
        return n5 |= n6 & n2 << n4;
    }

    static int getTypeBits(TranStruct tranStruct, int n, int n2) {
        return JavaLinkDist.getBits(tranStruct.type, n, n2);
    }

    static TranStruct setImmediate(TranStruct tranStruct) {
        return JavaLinkDist.setRemote(tranStruct, 1, 1);
    }

    static TranStruct setRemote(TranStruct tranStruct, int n, int n2) {
        int n3 = tranStruct.type;
        switch (n) {
            case 1: {
                n3 = JavaLinkDist.setBits(n3, 0, 1, 0);
                break;
            }
            case 2: {
                n3 = JavaLinkDist.setBits(n3, 1, 1, 0);
            }
        }
        switch (n2) {
            case 1: {
                n3 = JavaLinkDist.setBits(n3, 0, 1, 1);
                n3 = JavaLinkDist.setBits(n3, 0, 1, 2);
                break;
            }
            case 2: {
                n3 = JavaLinkDist.setBits(n3, 1, 1, 1);
                break;
            }
            case 3: {
                n3 = JavaLinkDist.setBits(n3, 0, 1, 1);
                n3 = JavaLinkDist.setBits(n3, 1, 1, 2);
            }
        }
        tranStruct.type = n3;
        return tranStruct;
    }

    static TranStruct setType(TranStruct tranStruct, int n, int n2, int n3) {
        int n4 = tranStruct.type;
        n4 = JavaLinkDist.setBits(n4, n, 5, 8);
        n4 = JavaLinkDist.setBits(n4, n2, 5, 3);
        tranStruct.type = n4 = JavaLinkDist.setBits(n4, n3, 8, 16);
        return tranStruct;
    }

    public static TranStruct nullDistOb() {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 31, 0, 0);
        if (0 == Transport.exData) {
            tranStruct.type |= 0xE000;
        }
        return tranStruct;
    }

    public static TranStruct newDistOb(boolean bl) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        tranStruct.nums[0] = bl ? 1 : 0;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 9, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(byte by) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        tranStruct.nums[0] = by;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 1, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(short s) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        tranStruct.nums[0] = s;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 2, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(int n) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        tranStruct.nums[0] = n;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 3, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(long l) {
        int n;
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[4], new String[0], new double[0]);
        int n2 = 0x1FFFFFFF;
        int n3 = 1;
        if (l < 0L) {
            n3 = -1;
            l = -(l + 1L);
        }
        tranStruct.nums[0] = n = (int)(l & (long)n2);
        tranStruct.nums[1] = n = (int)((l >>= 29) & (long)n2);
        tranStruct.nums[2] = (int)(l >>= 29);
        tranStruct.nums[3] = n3;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 4, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(char c) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[1], new double[0]);
        char[] cArray = new char[]{c};
        tranStruct.strings[0] = new String(cArray);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 5, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(String string) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[1], new double[0]);
        tranStruct.strings[0] = string;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 6, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(float f) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[1]);
        tranStruct.reals[0] = f;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 7, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(double d) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[1]);
        tranStruct.reals[0] = d;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 8, 0, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(String[] stringArray) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], stringArray, new double[0]);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 6, 1, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(byte[] byArray) {
        if (0 == Transport.exData) {
            int[] nArray = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                nArray[i] = byArray[i];
            }
            TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, nArray, new String[0], new double[0]);
            JavaLinkDist.setImmediate(tranStruct);
            JavaLinkDist.setType(tranStruct, 1, 1, 0);
            return tranStruct;
        }
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        tranStruct.setExdata(byArray);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 1, 1, 0);
        tranStruct.type |= 0x2000;
        return tranStruct;
    }

    public static TranStruct newDistOb(short[] sArray) {
        if (0 == Transport.exData) {
            int[] nArray = new int[sArray.length];
            for (int i = 0; i < sArray.length; ++i) {
                nArray[i] = sArray[i];
            }
            TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, nArray, new String[0], new double[0]);
            JavaLinkDist.setImmediate(tranStruct);
            JavaLinkDist.setType(tranStruct, 2, 1, 0);
            return tranStruct;
        }
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        tranStruct.setExdata(sArray);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 2, 1, 0);
        tranStruct.type |= 0x4000;
        return tranStruct;
    }

    public static TranStruct newDistOb(int[] nArray) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, nArray, new String[0], new double[0]);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 3, 1, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(float[] fArray) {
        if (0 == Transport.exData) {
            double[] dArray = new double[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                dArray[i] = fArray[i];
            }
            TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], dArray);
            JavaLinkDist.setImmediate(tranStruct);
            JavaLinkDist.setType(tranStruct, 7, 1, 0);
            return tranStruct;
        }
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        tranStruct.setExdata(fArray);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 7, 1, 0);
        tranStruct.type |= 0x6000;
        return tranStruct;
    }

    public static TranStruct newDistOb(double[] dArray) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], dArray);
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 8, 1, 0);
        return tranStruct;
    }

    public static TranStruct newDistOb(TranStruct tranStruct) {
        return tranStruct;
    }

    public static TranStruct newDistOb(Object object) {
        return JavaLinkDist.newDistOb(object, localServer);
    }

    public static TranStruct newDistErr(Object object) {
        return JavaLinkDist.newDistErr(object, localServer);
    }

    public static TranStruct newDistOb(Object object, JavaLinkDist javaLinkDist) {
        if (object == null) {
            return JavaLinkDist.nullDistOb();
        }
        String string = object.getClass().getName();
        if (string.equals(structName)) {
            return (TranStruct)object;
        }
        try {
            LispException lispException = (LispException)object;
            return JavaLinkDist.newDistOb(lispException.lispErr);
        }
        catch (Exception exception) {
            try {
                Throwable throwable = (Throwable)object;
                return JavaLinkDist.newDistErr(object, javaLinkDist);
            }
            catch (Exception exception2) {
                int n;
                int n2;
                String[] stringArray;
                int[] nArray;
                if (string.startsWith("[")) {
                    nArray = new int[]{0, 0, Array.getLength(object)};
                    stringArray = new String[]{string};
                    n2 = 1;
                    n = 4;
                } else if (string.equals("java.lang.Class")) {
                    nArray = new int[]{0, 0};
                    stringArray = new String[]{string, ((Class)object).getName()};
                    n2 = 0;
                    n = 5;
                } else if (string.equals("java.lang.reflect.Constructor")) {
                    nArray = new int[]{0, 0};
                    stringArray = JavaLinkDist.addSig(((Constructor)object).getParameterTypes(), string, ((Constructor)object).getDeclaringClass().getName(), "");
                    n2 = 0;
                    n = 6;
                } else if (string.equals("java.lang.reflect.Method")) {
                    nArray = new int[]{0, 0};
                    stringArray = JavaLinkDist.addSig(((Method)object).getParameterTypes(), string, ((Method)object).getDeclaringClass().getName(), ((Method)object).getName());
                    n2 = 0;
                    n = 7;
                } else {
                    nArray = new int[]{0, 0};
                    stringArray = new String[]{string};
                    n2 = 0;
                    n = 1;
                }
                TranStruct tranStruct = new TranStruct(javaLinkDist.localName, 0, nArray, stringArray, new double[0]);
                JavaLinkDist.setRemote(tranStruct, 2, 1);
                JavaLinkDist.setType(tranStruct, 0, n2, n);
                javaLinkDist.registerJavaObject(object, tranStruct);
                return tranStruct;
            }
        }
    }

    static String[] addSig(Class[] classArray, String string, String string2, String string3) {
        int n = 2;
        if (0 < string3.length()) {
            ++n;
        }
        String[] stringArray = new String[n + classArray.length];
        stringArray[0] = string;
        stringArray[1] = string2;
        if (n == 3) {
            stringArray[2] = string3;
        }
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[n + i] = classArray[i].getName();
        }
        return stringArray;
    }

    public static TranStruct newDistErr(Object object, JavaLinkDist javaLinkDist) {
        TranStruct tranStruct = new TranStruct(javaLinkDist.localName, 0, new int[2], new String[2], new double[0]);
        tranStruct.strings[0] = object.getClass().getName();
        tranStruct.strings[1] = object.toString();
        JavaLinkDist.setRemote(tranStruct, 2, 1);
        JavaLinkDist.setType(tranStruct, 0, 0, 61);
        javaLinkDist.registerJavaObject(object, tranStruct);
        return tranStruct;
    }

    public static TranStruct newDistSym(String string, String string2, int n) {
        TranStruct tranStruct = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[2], new double[0]);
        tranStruct.strings[0] = string;
        tranStruct.strings[1] = string2;
        tranStruct.nums[0] = n;
        JavaLinkDist.setImmediate(tranStruct);
        JavaLinkDist.setType(tranStruct, 10, 0, 0);
        return tranStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean liveP(TranStruct tranStruct) {
        TranStruct tranStruct2 = tranStruct;
        synchronized (tranStruct2) {
            if (JavaLinkDist.immediateP(tranStruct)) {
                return true;
            }
            if (JavaLinkDist.localP(tranStruct) && connectIndex != tranStruct.nums[1]) {
                JavaLinkDist.setRemote(tranStruct, 0, 3);
                return false;
            }
            return 0 == JavaLinkDist.getTypeBits(tranStruct, 1, 2);
        }
    }

    static boolean immediateP(TranStruct tranStruct) {
        return 0 == JavaLinkDist.getTypeBits(tranStruct, 1, 0);
    }

    static boolean indirectP(TranStruct tranStruct) {
        return 1 == JavaLinkDist.getTypeBits(tranStruct, 1, 0);
    }

    static boolean localP(TranStruct tranStruct) {
        return tranStruct.home.equalsIgnoreCase(JavaLinkDist.defaultLocal().localName);
    }

    static boolean remoteP(TranStruct tranStruct) {
        return !tranStruct.home.equalsIgnoreCase(TR_HOMEImmediate) && !tranStruct.home.equalsIgnoreCase(JavaLinkDist.defaultLocal().localName);
    }

    static boolean lastUseP(TranStruct tranStruct) {
        return 1 == JavaLinkDist.getTypeBits(tranStruct, 1, 1);
    }

    public static TranStruct lastUse(TranStruct tranStruct) {
        return JavaLinkDist.setRemote(tranStruct, 0, 2);
    }

    static boolean aggrP(TranStruct tranStruct, int n) {
        return n == JavaLinkDist.getTypeBits(tranStruct, 8, 16);
    }

    static boolean rankP(TranStruct tranStruct, int n) {
        int n2 = JavaLinkDist.getTypeBits(tranStruct, 5, 3);
        if (n2 == 31) {
            return n == tranStruct.nums[2];
        }
        return n == n2;
    }

    static boolean baseP(TranStruct tranStruct, int n) {
        return n == JavaLinkDist.getTypeBits(tranStruct, 5, 8);
    }

    public static boolean nullP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 31);
    }

    public static boolean booleanP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 9);
    }

    public static boolean integerP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && (JavaLinkDist.baseP(tranStruct, 1) || JavaLinkDist.baseP(tranStruct, 2) || JavaLinkDist.baseP(tranStruct, 3));
    }

    public static boolean byteP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 1);
    }

    public static boolean shortP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 2);
    }

    public static boolean intP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 3);
    }

    public static boolean longP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 4);
    }

    public static boolean charP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 5);
    }

    public static boolean realP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && (JavaLinkDist.baseP(tranStruct, 7) || JavaLinkDist.baseP(tranStruct, 8));
    }

    public static boolean singleP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 7);
    }

    public static boolean doubleP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 8);
    }

    public static boolean stringP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 6);
    }

    public static boolean symbolP(TranStruct tranStruct) {
        return JavaLinkDist.immediateP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.baseP(tranStruct, 10);
    }

    public static boolean errorP(TranStruct tranStruct) {
        return JavaLinkDist.indirectP(tranStruct) && JavaLinkDist.liveP(tranStruct) && JavaLinkDist.remoteP(tranStruct) && JavaLinkDist.rankP(tranStruct, 0) && JavaLinkDist.aggrP(tranStruct, 61);
    }

    public static boolean pointerP(TranStruct tranStruct) {
        return JavaLinkDist.indirectP(tranStruct) && JavaLinkDist.liveP(tranStruct);
    }

    public static boolean boolValue(TranStruct tranStruct) {
        return 0 != JavaLinkDist.intValue(tranStruct);
    }

    public static int intValue(TranStruct tranStruct) {
        return JavaLinkDist.intValue(tranStruct, 0);
    }

    public static int intValue(TranStruct tranStruct, int n) {
        if (n < tranStruct.nums.length) {
            return tranStruct.nums[n];
        }
        return 0;
    }

    public static long longValue(TranStruct tranStruct) {
        long l = JavaLinkDist.intValue(tranStruct, 0);
        long l2 = JavaLinkDist.intValue(tranStruct, 1);
        long l3 = JavaLinkDist.intValue(tranStruct, 2);
        long l4 = JavaLinkDist.intValue(tranStruct, 3);
        if (l4 == 0L) {
            l4 = 1L;
        }
        return l4 * (l + (l2 + (l3 << 29) << 29));
    }

    public static double doubleValue(TranStruct tranStruct) {
        return JavaLinkDist.doubleValue(tranStruct, 0);
    }

    public static double doubleValue(TranStruct tranStruct, int n) {
        if (n < tranStruct.reals.length) {
            return tranStruct.reals[0];
        }
        return 0.0;
    }

    public static char charValue(TranStruct tranStruct) {
        return JavaLinkDist.charValue(tranStruct, 0, 0);
    }

    public static char charValue(TranStruct tranStruct, int n) {
        return JavaLinkDist.charValue(tranStruct, n, 0);
    }

    public static char charValue(TranStruct tranStruct, int n, int n2) {
        if (n2 < tranStruct.strings.length && n < tranStruct.strings[n2].length()) {
            return tranStruct.strings[n2].charAt(n);
        }
        return '\u0000';
    }

    public static String stringValue(TranStruct tranStruct) {
        return JavaLinkDist.stringValue(tranStruct, 0);
    }

    public static String stringValue(TranStruct tranStruct, int n) {
        if (n < tranStruct.strings.length) {
            return tranStruct.strings[n];
        }
        return "";
    }

    public static String symbolName(TranStruct tranStruct) {
        return JavaLinkDist.stringValue(tranStruct, 0);
    }

    public static String symbolPackage(TranStruct tranStruct) {
        return JavaLinkDist.stringValue(tranStruct, 1);
    }

    public static int symbolCaseModes(TranStruct tranStruct) {
        return JavaLinkDist.intValue(tranStruct, 0);
    }

    public static Object pointerValue(TranStruct tranStruct) {
        return JavaLinkDist.pointerValue(tranStruct, localServer);
    }

    public static Object pointerValue(TranStruct tranStruct, JavaLinkDist javaLinkDist) {
        return javaLinkDist.extractJavaRef(tranStruct);
    }

    public static JavaLinkDist defaultLocal() {
        return localServer;
    }

    public static JavaLinkDistIF defaultRemote() {
        return remoteServer;
    }

    public static boolean defaultRemoteP() {
        if (null == remoteServer) {
            return false;
        }
        return remoteReady;
    }

    public static boolean defaultRemoteP(boolean bl) {
        if (!bl) {
            return false;
        }
        if (null == remoteServer) {
            return false;
        }
        remoteReady = true;
        return true;
    }

    public static JavaLinkDistIF defaultRemote(JavaLinkDist javaLinkDist) {
        if (javaLinkDist.remoteSelf != null) {
            return javaLinkDist.remoteSelf;
        }
        return remoteServer;
    }

    public static void discardInLisp(TranStruct tranStruct) {
        if (JavaLinkDist.liveP(tranStruct) && JavaLinkDist.remoteP(tranStruct)) {
            int[] nArray = new int[]{tranStruct.nums[0]};
            JavaLinkDist.defaultRemote().discard(nArray);
            JavaLinkDist.setRemote(tranStruct, 0, 3);
        }
    }

    public static TranStruct[] applyInLisp(int n, TranStruct tranStruct, TranStruct tranStruct2) {
        TranStruct[] tranStructArray = new TranStruct[]{tranStruct, tranStruct2};
        return JavaLinkDist.invokeInLisp(n, JavaLinkDist.newDistOb("cl:apply"), tranStructArray);
    }

    public static TranStruct[] applyInLispEx(int n, TranStruct tranStruct, TranStruct tranStruct2) throws JLinkerException {
        TranStruct[] tranStructArray = new TranStruct[]{tranStruct, tranStruct2};
        return JavaLinkDist.invokeInLispEx(n, JavaLinkDist.newDistOb("cl:apply"), tranStructArray);
    }

    public static TranStruct[] invokeInLisp(int n, String string, int n2) {
        return JavaLinkDist.invokeInLisp(n, JavaLinkDist.newDistOb(string), new TranStruct[]{JavaLinkDist.newDistOb(n2)});
    }

    public static TranStruct[] invokeInLispEx(int n, String string, int n2) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(n, JavaLinkDist.newDistOb(string), new TranStruct[]{JavaLinkDist.newDistOb(n2)});
    }

    public static TranStruct[] invokeInLisp(int n, String string, String string2) {
        return JavaLinkDist.invokeInLisp(n, JavaLinkDist.newDistOb(string), new TranStruct[]{JavaLinkDist.newDistOb(string2)});
    }

    public static TranStruct[] invokeInLispEx(int n, String string, String string2) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(n, JavaLinkDist.newDistOb(string), new TranStruct[]{JavaLinkDist.newDistOb(string2)});
    }

    public static TranStruct[] invokeInLisp(int n, String string) {
        return JavaLinkDist.invokeInLisp(n, JavaLinkDist.newDistOb(string), new TranStruct[0]);
    }

    public static TranStruct[] invokeInLispEx(int n, String string) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(n, JavaLinkDist.newDistOb(string), new TranStruct[0]);
    }

    public static TranStruct[] invokeInLisp(int n, TranStruct tranStruct, TranStruct[] tranStructArray) {
        TranStruct[] tranStructArray2 = JavaLinkDist.defaultRemote().invoke(n, tranStruct, tranStructArray);
        for (int i = 0; i < tranStructArray.length; ++i) {
            if (!JavaLinkDist.lastUseP(tranStructArray[i])) continue;
            JavaLinkDist.setRemote(tranStructArray[i], 0, 3);
        }
        return tranStructArray2;
    }

    public static TranStruct[] invokeInLispEx(int n, TranStruct tranStruct, TranStruct[] tranStructArray) throws JLinkerException {
        TranStruct[] tranStructArray2 = JavaLinkDist.invokeInLisp(n, tranStruct, tranStructArray);
        if (0 == tranStructArray2.length) {
            if (n == -1) {
                return tranStructArray2;
            }
            if (n == 0) {
                return tranStructArray2;
            }
            throw new InvokeException("Nothing returned from Lisp");
        }
        if (JavaLinkDist.integerP(tranStructArray2[0]) && JavaLinkDist.intValue(tranStructArray2[0]) == tranStructArray2.length - 1) {
            return tranStructArray2;
        }
        if (1 == tranStructArray2.length && JavaLinkDist.errorP(tranStructArray2[0])) {
            throw new LispException(JavaLinkDist.stringValue(tranStructArray2[0], 1), tranStructArray2[0]);
        }
        if (1 == tranStructArray2.length && JavaLinkDist.stringP(tranStructArray2[0]) && JavaLinkDist.stringValue(tranStructArray2[0]).equalsIgnoreCase("Throw in Lisp")) {
            throw new LispThrow();
        }
        if (1 == tranStructArray2.length) {
            throw new InvokeException("Unexpected value: " + tranStructArray2[0].toString());
        }
        throw new InvokeException("Unexpected result: " + tranStructArray2.toString());
    }

    static {
        connectIndex = -1;
        topIndex = 0x20000000;
        structClass = TranStruct.CLASS;
        structName = structClass.getName();
    }

    public static class LispThrow
    extends JLinkerException {
        LispThrow() {
            super("Throw in Lisp");
        }
    }

    public static class LispException
    extends JLinkerException {
        Object lispErr;

        LispException(String string, Object object) {
            super(string);
            this.lispErr = object;
        }
    }

    public static class InvokeException
    extends JLinkerException {
        InvokeException(String string) {
            super(string);
        }
    }

    public static class JLinkerException
    extends Exception {
        JLinkerException(String string) {
            super(string);
        }
    }
}

