/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCallImplementation;
import com.franz.jlinker.LispCallSocket;

public class LispCall {
    public static final int STYLE_ONEWAY = -1;
    public static final int STYLE_IGNORE = 0;
    public static final int STYLE_REF = 1;
    public static final int STYLE_COPY = 2;
    public static final int STYLE_ASYNC_BR = 3;
    static final int STYLE_ASYNC = 3;
    public static final int STYLE_ASYNC_GO = 4;
    static final int STYLE_TOP = 4;
    public static final int STATE_NEW = 0;
    public static final int STATE_COLLECTING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_WAITING = 4;
    public static final int STATE_WAITDONE = 5;
    public static final int STATE_CLOSED = 6;
    public static final int RES_NULL = 0;
    public static final int RES_BOOLEAN = 1;
    public static final int RES_INTEGER = 2;
    public static final int RES_LONG = 3;
    public static final int RES_REAL = 4;
    public static final int RES_STRING = 5;
    public static final int RES_SYMBOL = 11;
    public static final int RES_LISP_POINTER = 12;
    public static final int RES_ERROR = 13;
    public static final int RES_INT_ARRAY = 21;
    public static final int RES_DOUBLE_ARRAY = 22;
    public static final int RES_STRING_ARRAY = 23;
    public static final int RES_JAVA_POINTER = 24;
    public static final int RES_WRONG_STATE = 91;
    public static final int RES_MISSING = 92;
    public static final int RES_WRAPPER = 90;
    public static final int RES_UNKNOWN = 99;
    int state;
    boolean retain = true;
    int callStyle = 2;
    Object lispOp = null;
    int lispOpKind = 0;
    Object args = null;
    Object res = null;
    Holder chain = null;
    int count = 0;
    Object waitref = null;
    int waitres = -99;
    public LispCallImplementation implementation;
    public static LispCallImplementation prototype = new LispCallSocket();

    int newHolder(Object object) {
        this.chain = new Holder(object, this.chain);
        ++this.count;
        return this.count;
    }

    public LispCall() {
        this.implementation = prototype.builder(this, 2, true, "");
        this.state = 0;
    }

    public LispCall(boolean bl) {
        this.implementation = prototype.builder(this, 2, bl, "");
        this.retain = bl;
        this.state = 0;
    }

    public LispCall(int n) {
        this.implementation = prototype.builder(this, n, true, "");
        this.setStyle(n);
        this.state = 0;
    }

    public LispCall(String string) {
        this.implementation = prototype.builder(this, 2, true, string);
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public Object getOp() {
        return this.lispOp;
    }

    public int getStyle() {
        return this.callStyle;
    }

    public void setOp(String string) {
        this.lispOpKind = 0;
        this.implementation.setOp(string);
    }

    public void setOp(Object object) {
        this.castObject(object);
        this.lispOpKind = 1;
        this.implementation.setOp(object);
    }

    void castObject(Object object) {
        if (!this.implementation.getOpClass().isInstance(object)) {
            throw new ClassCastException("Cannot cast object of class " + object.getClass().getName() + " to " + this.implementation.getOpClass().getName());
        }
    }

    public void setStyle(int n) {
        if (-1 > n || n > 4) {
            throw new IllegalArgumentException("Unknown call style " + n + ".");
        }
        this.callStyle = n;
    }

    public synchronized boolean getRetain() {
        return this.retain;
    }

    public synchronized void setRetain(boolean bl) {
        this.retain = bl;
    }

    public synchronized int addArg(byte by) {
        return this.implementation.addArg(by);
    }

    public synchronized int addArg(short s) {
        return this.implementation.addArg(s);
    }

    public synchronized int addArg(int n) {
        return this.implementation.addArg(n);
    }

    public synchronized int addArg(long l) {
        return this.implementation.addArg(l);
    }

    public synchronized int addArg(boolean bl) {
        return this.implementation.addArg(bl);
    }

    public synchronized int addArg(byte[] byArray) {
        return this.implementation.addArg(byArray);
    }

    public synchronized int addArg(short[] sArray) {
        return this.implementation.addArg(sArray);
    }

    public synchronized int addArg(int[] nArray) {
        return this.implementation.addArg(nArray);
    }

    public synchronized int addArg(String string) {
        return this.implementation.addArg(string);
    }

    public synchronized int addArg(String[] stringArray) {
        return this.implementation.addArg(stringArray);
    }

    public synchronized int addArg(float f) {
        return this.implementation.addArg(f);
    }

    public synchronized int addArg(double d) {
        return this.implementation.addArg(d);
    }

    public synchronized int addArg(float[] fArray) {
        return this.implementation.addArg(fArray);
    }

    public synchronized int addArg(double[] dArray) {
        return this.implementation.addArg(dArray);
    }

    public synchronized int addArg(Object object) {
        return this.implementation.addArg(object);
    }

    public synchronized int addSymbol(String string) {
        return this.implementation.addSymbol(string);
    }

    public synchronized int addSymbol(String string, String string2) {
        return this.implementation.addSymbol(string, string2);
    }

    public synchronized int addSymbol(String string, String string2, int n) {
        return this.implementation.addSymbol(string, string2, n);
    }

    public synchronized int call() throws JavaLinkDist.JLinkerException {
        switch (this.implementation.mayCall()) {
            case 0: {
                throw new IllegalStateException("Lisp is not ready for a call.");
            }
            case -1: {
                throw new IllegalStateException("May not call Lisp in this thread.");
            }
        }
        return this.implementation.call();
    }

    public synchronized int callOneWay() throws JavaLinkDist.JLinkerException {
        this.callStyle = -1;
        return this.call();
    }

    public synchronized int callIgnore() throws JavaLinkDist.JLinkerException {
        this.callStyle = 0;
        return this.call();
    }

    public synchronized int callRef() throws JavaLinkDist.JLinkerException {
        this.callStyle = 1;
        return this.call();
    }

    public synchronized int callCopy() throws JavaLinkDist.JLinkerException {
        this.callStyle = 2;
        return this.call();
    }

    public synchronized int callAsyncBr() throws JavaLinkDist.JLinkerException {
        this.callStyle = 3;
        return this.call();
    }

    public synchronized int callAsyncGo() throws JavaLinkDist.JLinkerException {
        this.callStyle = 4;
        return this.call();
    }

    public synchronized Object getValue() {
        return this.getValue(0);
    }

    public synchronized Object getValue(int n) {
        if (this.state != 3) {
            this.throwWrongState("getValue", "");
        }
        if (this.res == null) {
            this.throwWrongState("getValue", " when result from Lisp is null");
        }
        return this.implementation.getValue(n);
    }

    int typeOf(Object object) {
        this.castObject(object);
        return this.implementation.typeOf(object);
    }

    public static String nameOfType(int n) {
        switch (n) {
            case 0: {
                return "Null";
            }
            case 1: {
                return "Boolean";
            }
            case 2: {
                return "Integer";
            }
            case 3: {
                return "Long";
            }
            case 4: {
                return "Real";
            }
            case 5: {
                return "String";
            }
            case 13: {
                return "Error";
            }
            case 11: {
                return "Symbol";
            }
            case 12: {
                return "Lisp-Pointer";
            }
            case 21: {
                return "Int-Array";
            }
            case 22: {
                return "Double-Array";
            }
            case 24: {
                return "Java-Pointer";
            }
            case 23: {
                return "String-Array";
            }
            case 91: {
                return "Wrong-State";
            }
            case 92: {
                return "Missing";
            }
            case 99: {
                return "Unknown";
            }
            case 90: {
                return "Wrapper";
            }
        }
        return "Unknown-" + n;
    }

    public synchronized int typeOf() {
        return this.typeOf(0);
    }

    public synchronized int typeOf(int n) {
        if (this.state != 3) {
            return 91;
        }
        if (this.res == null) {
            return 92;
        }
        return this.implementation.typeOf(n);
    }

    public synchronized int intValue() {
        return this.intValue(0);
    }

    public synchronized int intValue(int n) {
        return this.implementation.intValue(n);
    }

    public synchronized long longValue() {
        return this.longValue(0);
    }

    public synchronized long longValue(int n) {
        return this.implementation.longValue(n);
    }

    public synchronized double doubleValue() {
        return this.doubleValue(0);
    }

    public synchronized double doubleValue(int n) {
        return this.implementation.doubleValue(n);
    }

    public synchronized boolean booleanValue() {
        return this.booleanValue(0);
    }

    public synchronized boolean booleanValue(int n) {
        return this.implementation.booleanValue(n);
    }

    public synchronized String stringValue() {
        return this.stringValue(0);
    }

    public synchronized String stringValue(int n) {
        return this.implementation.stringValue(n);
    }

    public synchronized int[] intArrayValue() {
        return this.intArrayValue(0);
    }

    public synchronized int[] intArrayValue(int n) {
        return this.implementation.intArrayValue(n);
    }

    public synchronized String[] stringArrayValue() {
        return this.stringArrayValue(0);
    }

    public synchronized String[] stringArrayValue(int n) {
        return this.implementation.stringArrayValue(n);
    }

    public synchronized double[] doubleArrayValue() {
        return this.doubleArrayValue(0);
    }

    public synchronized double[] doubleArrayValue(int n) {
        return this.implementation.doubleArrayValue(n);
    }

    public synchronized Object objectValue() {
        return this.objectValue(0);
    }

    public synchronized Object objectValue(int n) {
        return this.implementation.objectValue(n);
    }

    public synchronized String symbolName() {
        return this.symbolName(0);
    }

    public synchronized String symbolName(int n) {
        return this.implementation.symbolName(n);
    }

    public synchronized String symbolPackage() {
        return this.symbolPackage(0);
    }

    public synchronized String symbolPackage(int n) {
        return this.implementation.symbolPackage(n);
    }

    public synchronized String lispType() {
        return this.lispType(0);
    }

    public synchronized String lispType(int n) {
        return this.implementation.lispType(n);
    }

    public synchronized int query() {
        int n = -99;
        try {
            n = this.query(false, false);
        }
        catch (JavaLinkDist.JLinkerException jLinkerException) {
            // empty catch block
        }
        return n;
    }

    public synchronized int query(boolean bl, boolean bl2) throws JavaLinkDist.JLinkerException {
        return this.implementation.query(bl, bl2);
    }

    public synchronized void close() {
        this.waitref = null;
        this.waitres = -99;
        this.res = null;
        this.args = null;
        this.count = 0;
        this.chain = null;
        if (this.state != 0) {
            this.state = 6;
        }
        this.implementation.close();
    }

    public synchronized boolean reset() {
        this.waitref = null;
        this.waitres = -99;
        this.res = null;
        if (this.state == 1) {
            this.implementation.assemble("reset");
        }
        this.count = 0;
        this.chain = null;
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.args == null) {
                    this.state = 1;
                    break;
                }
                this.state = 2;
                break;
            }
            case 6: {
                if (this.lispOp == null) {
                    this.state = 0;
                    break;
                }
                this.state = 1;
                break;
            }
            default: {
                this.throwWrongState("reset", "");
            }
        }
        this.implementation.reset();
        return this.state == 2;
    }

    public synchronized void setArg(int n, boolean bl) {
        this.implementation.setArg(n, bl);
    }

    public synchronized void setArg(int n, int n2) {
        this.implementation.setArg(n, n2);
    }

    public synchronized void setArg(int n, long l) {
        this.implementation.setArg(n, l);
    }

    public synchronized void setArg(int n, double d) {
        this.implementation.setArg(n, d);
    }

    public synchronized void setArg(int n, String string) {
        this.implementation.setArg(n, string);
    }

    public synchronized void setArg(int n, Object object) {
        this.implementation.setArg(n, object);
    }

    public synchronized void setArg(int n, int[] nArray) {
        this.implementation.setArg(n, nArray);
    }

    public synchronized void setArg(int n, double[] dArray) {
        this.implementation.setArg(n, dArray);
    }

    public synchronized void setArg(int n, String[] stringArray) {
        this.implementation.setArg(n, stringArray);
    }

    public synchronized void setSymbol(int n, String string) {
        this.implementation.setSymbol(n, string);
    }

    void throwWrongState(String string, String string2) {
        String string3;
        switch (this.state) {
            case 0: {
                string3 = "STATE_NEW";
                break;
            }
            case 1: {
                string3 = "STATE_COLLECTING";
                break;
            }
            case 2: {
                string3 = "STATE_READY";
                break;
            }
            case 3: {
                string3 = "STATE_DONE";
                break;
            }
            case 4: {
                string3 = "STATE_WAITING";
                break;
            }
            case 5: {
                string3 = "STATE_WAITDONE";
                break;
            }
            case 6: {
                string3 = "STATE_CLOSED";
                break;
            }
            default: {
                string3 = "STATE_???";
            }
        }
        throw new IllegalStateException(string + " cannot be called in " + string3 + " state" + string2 + ".");
    }

    public int mayCall() {
        return this.implementation.mayCall();
    }

    public static int dispatchEvent(String string, Object object, String[] stringArray, int[] nArray) {
        return JavaLinkCommon.ltoj_anchor.callLisp(string, object, stringArray, nArray);
    }

    class Holder {
        Holder next;
        Object arg;

        Holder(Object object, Holder holder) {
            this.next = holder;
            this.arg = object;
        }
    }
}

