/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.util.export.ExportDialog;

public class TestUnicodeMap
extends JFrame
implements ActionListener {
    ExportDialog dialog;
    JPanel panel;
    TestPanel symbols;

    public TestUnicodeMap() {
        super("Text Test");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TestUnicodeMap.this.quit();
            }
        });
        this.dialog = new ExportDialog();
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenu page = new JMenu("Page");
        JMenu font = new JMenu("Font");
        JMenuItem export = new JMenuItem("Export...");
        export.addActionListener(this);
        file.add(export);
        file.addSeparator();
        JMenuItem quit = new JMenuItem("Quit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.quit();
            }
        });
        file.add(quit);
        JMenuItem item = new JMenuItem("Latin");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u0000");
                TestUnicodeMap.this.symbols.setEndString("\u00ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("Greek");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u0300");
                TestUnicodeMap.this.symbols.setEndString("\u03ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("Punctuation");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u2000");
                TestUnicodeMap.this.symbols.setEndString("\u20ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("Arrows");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u2100");
                TestUnicodeMap.this.symbols.setEndString("\u21ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("MathOps");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u2200");
                TestUnicodeMap.this.symbols.setEndString("\u22ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("Dingbats");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setStartString("\u2700");
                TestUnicodeMap.this.symbols.setEndString("\u27ff");
                TestUnicodeMap.this.symbols.repaint();
            }
        });
        page.add(item);
        item = new JMenuItem("Courier");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setFont("courier");
                TestUnicodeMap.this.repaint();
            }
        });
        font.add(item);
        item = new JMenuItem("Times");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setFont("serif");
                TestUnicodeMap.this.repaint();
            }
        });
        font.add(item);
        item = new JMenuItem("Helvetica");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestUnicodeMap.this.symbols.setFont("sansserif");
                TestUnicodeMap.this.repaint();
            }
        });
        font.add(item);
        menuBar.add(file);
        menuBar.add(page);
        menuBar.add(font);
        this.setJMenuBar(menuBar);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.white), BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.symbols = new TestPanel();
        this.symbols.setBorder(border);
        this.panel.add(this.symbols);
        content.add((Component)this.panel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            this.dialog.showExportDialog((Component)this, "Export...", (Component)this.panel, "untitled");
        }
    }

    public void quit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to quit?", "Confirm Quit", 0);
        if (n == 0) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        TestUnicodeMap test = new TestUnicodeMap();
        test.pack();
        test.setSize(new Dimension(400, 600));
        test.setVisible(true);
    }

    class TestPanel
    extends JPanel {
        String[] label = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        String startString = "\u0000";
        String endString = "\u00ff";
        String fontname = "serif";
        int fontsize = 0;

        TestPanel() {
        }

        public void setStartString(String startString) {
            this.startString = startString;
        }

        public void setEndString(String endString) {
            this.endString = endString;
        }

        public void setFont(String fontname) {
            this.fontname = fontname;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (g != null) {
                int i;
                VectorGraphics vg = VectorGraphics.create((Graphics)g);
                Dimension dim = this.getSize();
                Insets insets = this.getInsets();
                vg.setColor(Color.white);
                vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
                int dw = dim.width / 17;
                int dh = dim.height / 17;
                vg.setColor(Color.black);
                this.fontsize = dh * 2 / 3;
                Font font = new Font(this.fontname, 2, this.fontsize);
                vg.setFont(font);
                StringBuffer character = new StringBuffer(" ");
                int iy = dh / 2 + dh;
                int ix = dw / 2 + dw;
                for (i = 0; i < 16; ++i) {
                    vg.drawString(this.label[i], (double)(dw / 2), (double)iy, 2, 2, false, Color.cyan, 2.0, false, Color.yellow);
                    vg.drawString(this.label[i], (double)ix, (double)(dh / 2), 2, 2, false, Color.cyan, 2.0, false, Color.yellow);
                    iy += dh;
                    ix += dw;
                }
                iy = dh / 2 + dh;
                ix = dw / 2;
                for (i = (int)this.startString.charAt(0); i <= this.endString.charAt(0); ++i) {
                    if (i % 16 == 0) {
                        iy = dh / 2 + dh;
                        ix += dw;
                    }
                    character.setCharAt(0, (char)i);
                    vg.drawString(character.toString(), (double)ix, (double)iy, 2, 2, false, Color.cyan, 2.0, true, Color.yellow);
                    iy += dh;
                }
            }
        }
    }
}

