/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import org.freehep.util.export.ExportDialog;
import org.freehep.util.export.VectorGraphicsTransferable;

public class TestingFrame
extends JFrame {
    private String title;
    private ExportDialog dialog;
    private JComponent singlePanel;
    private JTabbedPane multiPanel;

    public TestingFrame(String title) {
        super(title);
        this.title = title;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TestingFrame.this.quit();
            }
        });
        this.dialog = new ExportDialog();
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        JMenuItem export = new JMenuItem("Export...");
        file.add(export);
        export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestingFrame.this.export();
            }
        });
        JMenuItem quit = new JMenuItem("Quit");
        file.add(quit);
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestingFrame.this.quit();
            }
        });
        JMenu edit = new JMenu("Edit");
        menuBar.add(edit);
        JMenuItem copy = new JMenuItem("Copy");
        edit.add(copy);
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestingFrame.this.copy();
            }
        });
        this.setJMenuBar(menuBar);
    }

    public void export() {
        if (this.multiPanel != null) {
            this.dialog.showExportDialog((Component)this, "Export...", this.multiPanel.getSelectedComponent(), this.title);
        } else if (this.singlePanel != null) {
            this.dialog.showExportDialog((Component)this, "Export...", (Component)this.singlePanel, this.title);
        } else {
            System.err.println("Failed to export");
        }
    }

    public void addPanel(JComponent c) {
        this.addPanel(null, c);
    }

    public void addPanel(String name, JComponent c) {
        if (name == null) {
            this.singlePanel = c;
            this.setContentPane(this.singlePanel);
        } else {
            if (this.multiPanel == null) {
                this.multiPanel = new JTabbedPane();
                this.setContentPane(this.multiPanel);
            }
            this.multiPanel.addTab(name, c);
        }
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.white), BorderFactory.createMatteBorder(2, 2, 2, 2, Color.green));
        c.setBorder(border);
    }

    public void copy() {
        Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        VectorGraphicsTransferable transferable = new VectorGraphicsTransferable(this.multiPanel == null ? this.singlePanel : this.multiPanel.getSelectedComponent());
        clipBoard.setContents((Transferable)transferable, (ClipboardOwner)transferable);
    }

    public void quit() {
        int n = JOptionPane.showConfirmDialog(this, "Do you really want to quit?", "Confirm Quit", 0);
        if (n == 0) {
            System.exit(0);
        }
    }
}

