/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.freehep.swing.ErrorDialog;
import org.freehep.swing.layout.TableLayout;
import org.freehep.util.export.ExportFileType;
import org.freehep.util.export.ExportFileTypeGroups;

public class ExportDialog
extends JOptionPane {
    private static final String rootKey = ExportDialog.class.getName();
    private static final String SAVE_AS_TYPE = rootKey + ".SaveAsType";
    private static final String SAVE_AS_FILE = rootKey + ".SaveAsFile";
    private String creator;
    private JButton browse = new JButton("Browse...");
    private JButton advanced = new JButton("Options...");
    private JTextField file = new JTextField(40);
    private JComboBox type;
    private Component component;
    private boolean trusted = true;
    private Vector list = new Vector();
    private Properties props = new Properties();
    private String baseDir = null;

    public void setUserProperties(Properties properties) {
        this.props = properties;
    }

    public void addExportFileType(ExportFileType fileType) {
        this.list.addElement(fileType);
    }

    public void addAllExportFileTypes() {
        ExportFileTypeGroups groups = new ExportFileTypeGroups(ExportFileType.getExportFileTypes());
        for (String group : groups.getGroupNames()) {
            List exportTypes = groups.getExportFileTypes(group);
            if (exportTypes.size() <= 0) continue;
            this.list.add(new JLabel(groups.getLabel(group), 0));
            Collections.sort(exportTypes);
            Iterator j = exportTypes.iterator();
            while (j.hasNext()) {
                this.addExportFileType((ExportFileType)j.next());
            }
        }
    }

    public ExportDialog() {
        this(null);
    }

    public ExportDialog(String creator) {
        this(creator, true);
    }

    public ExportDialog(String creator, boolean addAllExportFileTypes) {
        super(null, -1, 2);
        this.creator = creator;
        try {
            this.baseDir = System.getProperty("user.home");
        }
        catch (SecurityException x) {
            this.trusted = false;
        }
        ButtonListener bl = new ButtonListener();
        JPanel panel = new JPanel(new TableLayout());
        if (this.trusted) {
            panel.add("* * [5 5 5 5] w", this.file);
            panel.add("* * * 1 [5 5 5 5] wh", this.browse);
        }
        this.type = new JComboBox(this.list);
        this.type.setMaximumRowCount(16);
        panel.add("* * 1 1 [5 5 5 5] w", this.type);
        panel.add("* * * 1 [5 5 5 5] wh", this.advanced);
        this.browse.addActionListener(bl);
        this.advanced.addActionListener(bl);
        this.type.setRenderer(new SaveAsRenderer());
        this.type.addActionListener(bl);
        this.setMessage(panel);
        if (addAllExportFileTypes) {
            this.addAllExportFileTypes();
        }
    }

    public void showExportDialog(Component parent, String title, Component target, Dimension size, String defFile) {
        this.props.setProperty("size-w", String.valueOf(size.width));
        this.props.setProperty("size-h", String.valueOf(size.height));
        this.showExportDialog(parent, title, target, defFile);
    }

    public void showExportDialog(Component parent, String title, Component target, String defFile) {
        String dType;
        this.component = target;
        if (this.list.size() > 0) {
            this.type.setSelectedIndex(1);
        }
        if ((dType = this.props.getProperty(SAVE_AS_TYPE)) != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                ExportFileType saveAs;
                Object obj = this.list.elementAt(i);
                if (!(obj instanceof ExportFileType) || !(saveAs = (ExportFileType)obj).getFileFilter().getDescription().equals(dType)) continue;
                this.type.setSelectedItem(saveAs);
                break;
            }
        }
        this.advanced.setEnabled(this.currentType() != null && this.currentType().hasOptionPanel());
        if (this.trusted) {
            String saveFile = this.props.getProperty(SAVE_AS_FILE);
            if (saveFile != null) {
                this.baseDir = new File(saveFile).getParent();
                defFile = saveFile;
            } else {
                defFile = this.baseDir + File.separator + defFile;
            }
            File f = new File(defFile);
            if (this.currentType() != null) {
                f = this.currentType().adjustFilename(f, this.currentType().getFileExtension(f), this.props);
            }
            this.file.setText(f.toString());
        } else {
            this.file.setEnabled(false);
            this.browse.setEnabled(false);
        }
        JDialog dlg = this.createDialog(parent, title);
        dlg.pack();
        dlg.setVisible(true);
    }

    private ExportFileType currentType() {
        return (ExportFileType)this.type.getSelectedItem();
    }

    protected String selectFile() {
        JFileChooser dlg = new JFileChooser();
        String f = this.file.getText();
        if (f != null) {
            dlg.setSelectedFile(new File(f));
        }
        dlg.setFileFilter(this.currentType().getFileFilter());
        if (dlg.showDialog(this, "Select") == 0) {
            return dlg.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    protected boolean writeFile(Component component, ExportFileType t) throws IOException {
        int ok;
        File f = new File(this.file.getText());
        if (f.exists() && (ok = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
            return false;
        }
        t.exportToFile(f, component, (Component)this, this.props, this.creator);
        this.props.put(SAVE_AS_FILE, this.file.getText());
        this.props.put(SAVE_AS_TYPE, this.currentType().getFileFilter().getDescription());
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Integer && (Integer)value == 0) {
            try {
                if (!this.writeFile(this.component, this.currentType())) {
                    return;
                }
            }
            catch (Throwable x) {
                ErrorDialog.showErrorDialog(this, "Error writing graphics file", x);
                return;
            }
        }
        super.setValue(value);
    }

    private static class SaveAsRenderer
    extends DefaultListCellRenderer {
        private SaveAsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ExportFileType) {
                this.setText(((ExportFileType)value).getFileFilter().getDescription());
            } else if (value instanceof JLabel) {
                return (Component)value;
            }
            return this;
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ExportFileType previousType = null;

        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ExportDialog.this.browse) {
                String fileName = ExportDialog.this.selectFile();
                if (fileName != null) {
                    if (ExportDialog.this.currentType() != null) {
                        File f = new File(fileName);
                        ExportDialog.this.currentType().adjustFilename(f, ExportDialog.this.currentType().getFileExtension(f), ExportDialog.this.props);
                        ExportDialog.this.file.setText(f.getPath());
                    } else {
                        ExportDialog.this.file.setText(fileName);
                    }
                }
            } else if (source == ExportDialog.this.advanced) {
                JPanel panel;
                int rc;
                if (ExportDialog.this.currentType() != null && (rc = JOptionPane.showConfirmDialog(ExportDialog.this, panel = ExportDialog.this.currentType().createOptionPanel(ExportDialog.this.props), "Options for " + ExportDialog.this.currentType().getDescription(), 2, -1)) == 0) {
                    ExportDialog.this.currentType().applyChangedOptions(panel, ExportDialog.this.props);
                    File f1 = new File(ExportDialog.this.file.getText());
                    File f2 = ExportDialog.this.currentType().adjustFilename(f1, ExportDialog.this.currentType().getFileExtension(f1), ExportDialog.this.props);
                    if (!f1.equals(f2) && ExportDialog.this.file.isEnabled()) {
                        ExportDialog.this.file.setText(f2.toString());
                    }
                }
            } else if (source == ExportDialog.this.type) {
                if (ExportDialog.this.type.getSelectedItem() instanceof ExportFileType) {
                    if (this.previousType == null) {
                        this.previousType = ExportDialog.this.currentType();
                    }
                    ExportDialog.this.advanced.setEnabled(ExportDialog.this.currentType().hasOptionPanel());
                    File f1 = new File(ExportDialog.this.file.getText());
                    File f2 = ExportDialog.this.currentType().adjustFilename(f1, this.previousType.getFileExtension(f1), ExportDialog.this.props);
                    if (!f1.equals(f2) && ExportDialog.this.file.isEnabled()) {
                        ExportDialog.this.file.setText(f2.toString());
                    }
                    this.previousType = ExportDialog.this.currentType();
                } else {
                    ExportDialog.this.type.setSelectedItem(this.previousType);
                }
            }
        }
    }
}

