/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.export;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.freehep.util.export.ExportFileType;

public class VectorGraphicsTransferable
implements ClipboardOwner,
Transferable {
    private Component component;
    private DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private Map types = new HashMap();
    private static Map defaultTypes;

    public VectorGraphicsTransferable(Component c) {
        this(c, true);
    }

    public VectorGraphicsTransferable(Component c, boolean addDefaultAssociations) {
        this.component = c;
        if (addDefaultAssociations) {
            this.addDefaultFileTypes();
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.match(this.imageFlavor)) {
            Image img = this.component.createImage(this.component.getWidth(), this.component.getHeight());
            Graphics g = img.getGraphics();
            this.component.print(g);
            g.dispose();
            return img;
        }
        ExportFileType type = (ExportFileType)this.types.get(dataFlavor);
        if (type != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            type.exportToFile((OutputStream)out, this.component, this.component, null, this.component.getName());
            out.close();
            return new ByteArrayInputStream(out.toByteArray());
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] result = new DataFlavor[this.types.size() + 1];
        this.types.keySet().toArray(result);
        result[this.types.size()] = this.imageFlavor;
        return result;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (dataFlavor.match(this.imageFlavor)) {
            return true;
        }
        return this.types.containsKey(dataFlavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void addExportFileType(DataFlavor flavor, ExportFileType type) {
        this.types.put(flavor, type);
    }

    private void addDefaultFileTypes() {
        if (defaultTypes == null) {
            defaultTypes = VectorGraphicsTransferable.createDefaultTypes();
        }
        this.types.putAll(defaultTypes);
    }

    private static Map createDefaultTypes() {
        HashMap result = new HashMap();
        VectorGraphicsTransferable.addType(result, "ENHMETAFILE", "image/emf", "Enhanced Meta File", "org.freehep.graphicsio.emf.EMFExportFileType");
        return result;
    }

    private static void addType(Map result, String atom, String mimeType, String description, String className) {
        try {
            DataFlavor df = new DataFlavor(mimeType, description);
            SystemFlavorMap map = (SystemFlavorMap)SystemFlavorMap.getDefaultFlavorMap();
            map.addUnencodedNativeForFlavor(df, atom);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = loader == null ? Class.forName(className) : loader.loadClass(className);
            ExportFileType type = (ExportFileType)cls.newInstance();
            result.put(df, type);
        }
        catch (Throwable x) {
            System.err.println("Unable to install flavor for mime type '" + mimeType + "' (this is expected if not using JDK 1.4)");
        }
    }
}

