/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.acroforms.xfa;

import java.awt.Rectangle;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;

public class XFAFormObject
extends FormObject {
    public static final int LAYOUT_POSITION = 1;
    public static final int LAYOUT_LEFTtoRIGHT = 2;
    public static final int LAYOUT_RIGHTtoLEFT = 3;
    public static final int LAYOUT_TABLE = 4;
    public static final int LAYOUT_TOPtoBOTTOM = 5;
    public int layout;
    public String script;
    public String scriptType;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int INLINE = 0;
    public int heightOfCaption;
    public int widthOfCaption;
    public int captionPosition = 0;
    public static final int SQUARE = 50;
    public static final int ROUND = 51;
    public int outline;
    public static final int CHOICE_CLICK = 1;
    public static final int CHOICE_ENTRY = 2;
    public static final int CHOICE_ALWAYS = 3;
    public int choiceShown;
    public static final int BORDER_DASHED = 1;
    public static final int BORDER_DOTTED = 2;
    public static final int BORDER_DASHDOT = 3;
    public static final int BORDER_DASHDOTDOT = 4;
    public static final int BORDER_SOLID = 5;
    public static final int BORDER_LOWERED = 6;
    public static final int BORDER_RAISED = 7;
    public static final int BORDER_ETCHED = 8;
    public static final int BORDER_EMBOSSED = 9;
    public int borderStroke;
    public static final int ACTION_CHANGE = 1;
    public static final int ACTION_MOUSECLICK = 2;
    public static final int ACTION_DOCSAVED = 3;
    public static final int ACTION_PRERENDER = 4;
    public static final int ACTION_GAINFOCUS = 5;
    public static final int ACTION_LOSSFOCUS = 6;
    public static final int ACTION_FIELDFULL = 7;
    public static final int ACTION_INIT = 8;
    public static final int ACTION_MOUSEPRESS = 9;
    public static final int ACTION_MOUSEENTER = 10;
    public static final int ACTION_MOUSEEXIT = 11;
    public static final int ACTION_MOUSERELEASE = 12;
    public static final int ACTION_WEBSENT = 13;
    public static final int ACTION_WEBSENDING = 14;
    public static final int ACTION_POSTSAVE = 15;
    public static final int ACTION_PRESAVE = 16;
    public static final int ACTION_POSTPRINT = 17;
    public static final int ACTION_SUBMITVIAHTTP = 18;
    public static final int ACTION_DOMLOADED = 19;
    public int activity = -1;
    public String typeface;
    public int numericValue;
    public boolean editable;
    public int marginBottomInset;
    public int marginTopInset;
    public int marginLeftInset;
    public int marginRightInset;
    public static final int DELEGATETOSERVER = 30;
    public static final int FORMAT_XDP = 1;
    public static final int FORMAT_URLENCODED = 2;
    public static final int FORMAT_PDF = 3;
    public static final int FORMAT_XFD = 4;
    public static final int FORMAT_XML = 5;
    public static final int ENCODE_DEFAULT = 0;
    public static final int ENCODE_ISO_8859_1 = 1;
    public static final int ENCODE_ISO_8859_2 = 2;
    public static final int ENCODE_ISO_8859_7 = 3;
    public static final int ENCODE_SHIFT_JIS = 4;
    public static final int ENCODE_KSC_5601 = 5;
    public static final int ENCODE_BIG_FIVE = 6;
    public static final int ENCODE_GB_2312 = 7;
    public static final int ENCODE_UTF_8 = 8;
    public static final int ENCODE_UTF_16 = 9;
    public static final int ENCODE_UCS_2 = 10;
    public static final int ENCODE_FONTSPECIFIC = 15;
    public int submitDataFormat;
    public String submitURL;
    public int submitTextEncode;
    public int longMedium;
    public int shortMedium;
    public String stdPaperName;
    public static final int JUSTIFY_EXCEPT_LAST_ALIGNMENT = 2;
    public static final int JUSTIFY_ALIGNMENT = 3;
    public static final int RADIX_ALIGNMENT = 4;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public float verticalAllgin;

    public XFAFormObject() {
        this.isXFAObject = true;
    }

    public FormObject duplicate() {
        XFAFormObject xFAFormObject = (XFAFormObject)super.duplicate();
        xFAFormObject.layout = this.layout;
        xFAFormObject.script = this.script;
        xFAFormObject.heightOfCaption = this.heightOfCaption;
        xFAFormObject.widthOfCaption = this.widthOfCaption;
        xFAFormObject.captionPosition = this.captionPosition;
        xFAFormObject.outline = this.outline;
        xFAFormObject.choiceShown = this.choiceShown;
        xFAFormObject.borderStroke = this.borderStroke;
        xFAFormObject.activity = this.activity;
        xFAFormObject.typeface = this.typeface;
        xFAFormObject.numericValue = this.numericValue;
        xFAFormObject.editable = this.editable;
        xFAFormObject.marginBottomInset = this.marginBottomInset;
        xFAFormObject.marginTopInset = this.marginTopInset;
        xFAFormObject.marginLeftInset = this.marginLeftInset;
        xFAFormObject.marginRightInset = this.marginRightInset;
        xFAFormObject.submitDataFormat = this.submitDataFormat;
        xFAFormObject.submitURL = this.submitURL;
        xFAFormObject.submitTextEncode = this.submitTextEncode;
        xFAFormObject.longMedium = this.longMedium;
        xFAFormObject.shortMedium = this.shortMedium;
        xFAFormObject.stdPaperName = this.stdPaperName;
        xFAFormObject.verticalAllgin = this.verticalAllgin;
        return xFAFormObject;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  layout=");
        stringBuffer.append(this.layout);
        stringBuffer.append("\n  scriptname=");
        stringBuffer.append(this.script);
        stringBuffer.append("\n  heightofcaption=");
        stringBuffer.append(this.heightOfCaption);
        stringBuffer.append("\n  widthofcaption=");
        stringBuffer.append(this.widthOfCaption);
        stringBuffer.append("\n  captionposition=");
        stringBuffer.append(this.captionPosition);
        stringBuffer.append("\n  outline=");
        stringBuffer.append(this.outline);
        stringBuffer.append("\n  choiceshown=");
        stringBuffer.append(this.choiceShown);
        stringBuffer.append("\n  borderstroke=");
        stringBuffer.append(this.borderStroke);
        stringBuffer.append("\n  activity=");
        stringBuffer.append(this.activity);
        stringBuffer.append("\n  typeface=");
        stringBuffer.append(this.typeface);
        stringBuffer.append("\n  numericvalue=");
        stringBuffer.append(this.numericValue);
        stringBuffer.append("\n  editable=");
        stringBuffer.append(this.editable);
        stringBuffer.append("\n  maginbottom=");
        stringBuffer.append(this.marginBottomInset);
        stringBuffer.append("\n  margintop=");
        stringBuffer.append(this.marginTopInset);
        stringBuffer.append("\n  marginleft=");
        stringBuffer.append(this.marginLeftInset);
        stringBuffer.append("\n  marginright=");
        stringBuffer.append(this.marginRightInset);
        stringBuffer.append("\n  submitdataformat=");
        stringBuffer.append(this.submitDataFormat);
        stringBuffer.append("\n  submiturl=");
        stringBuffer.append(this.submitURL);
        stringBuffer.append("\n  submittextencoding=");
        stringBuffer.append(this.submitTextEncode);
        stringBuffer.append("\n  longmedium=");
        stringBuffer.append(this.longMedium);
        stringBuffer.append("\n  shortmedium=");
        stringBuffer.append(this.shortMedium);
        stringBuffer.append("\n  stdpapername=");
        stringBuffer.append(this.stdPaperName);
        stringBuffer.append("\n  verticalalign=");
        stringBuffer.append(this.verticalAllgin);
        return super.toString() + stringBuffer;
    }

    public void setHorizontalAlign(Object object) {
        this.Q = 2;
        if (object.equals("center")) {
            this.Q = 0;
        } else if (object.equals("justify")) {
            this.Q = 2;
        } else if (object.equals("justifyAll")) {
            this.Q = 3;
        } else if (object.equals("left")) {
            this.Q = 2;
        } else if (object.equals("radix")) {
            this.Q = 4;
        } else if (object.equals("right")) {
            this.Q = 4;
        } else {
            LogWriter.writeFormLog("XFAFormObject.setHorizontalAlign not taking " + object, false);
        }
    }

    public void setVerticalAllign(String string) {
        if (string.equals("middle")) {
            this.verticalAllgin = 0.5f;
        } else if (string.equals("top")) {
            this.verticalAllgin = 0.0f;
        } else if (string.equals("bottom")) {
            this.verticalAllgin = 1.0f;
        } else {
            LogWriter.writeFormLog("XFAFormObject.setVerticalAlign not taking " + string, false);
        }
    }

    public void setLayout(String string) {
        if (string.equals("position")) {
            this.layout = 1;
        } else if (string.equals("lr-tb")) {
            this.layout = 2;
        } else if (string.equals("rl-tb")) {
            this.layout = 3;
        } else if (string.equals("row")) {
            LogWriter.writeFormLog("row layout NOT IMPLEMENTED", false);
        } else if (string.equals("table")) {
            this.layout = 4;
        } else if (string.equals("tb")) {
            this.layout = 5;
        }
    }

    public static void setLocale(String string) {
        LogWriter.writeFormLog("XFAFormObject.setLocale NOT IMPLEMENTED =" + string, false);
    }

    public void setScript(String string) {
        this.script = string;
    }

    public static void setBindtypeOnMerge(String string) {
    }

    public static void setPositionToVector(String string) {
    }

    public void setCaptionReserve(int n) {
        if (this.captionPosition != 0) {
            if (this.captionPosition == 3 || this.captionPosition == 4) {
                this.heightOfCaption = n;
            } else if (this.captionPosition == 1 || this.captionPosition == 2) {
                this.widthOfCaption = n;
            }
        }
    }

    public void setCaptionPlacement(String string) {
        if (string.equals("left")) {
            this.captionPosition = 1;
        } else if (string.equals("right")) {
            this.captionPosition = 2;
        } else if (string.equals("top")) {
            this.captionPosition = 3;
        } else if (string.equals("bottom")) {
            this.captionPosition = 4;
        } else if (string.equals("inline")) {
            this.captionPosition = 0;
        }
    }

    public void setOutline(String string) {
        if (string.equals("square")) {
            this.outline = 50;
        } else if (string.equals("round")) {
            this.outline = 51;
        }
    }

    public static void setContentType(String string) {
    }

    public void setChoiceOpening(String string) {
        if (string.equals("userControl")) {
            this.choiceShown = 1;
        } else if (string.equals("OnEntry")) {
            this.choiceShown = 2;
        } else if (string.equals("always")) {
            this.choiceShown = 3;
        }
    }

    public void setBorderStroke(String string) {
        if (string.equals("solid")) {
            this.borderStroke = 5;
        } else if (string.equals("dashed")) {
            this.borderStroke = 1;
        } else if (string.equals("dotted")) {
            this.borderStroke = 2;
        } else if (string.equals("dashDot")) {
            this.borderStroke = 3;
        } else if (string.equals("dashDotDot")) {
            this.borderStroke = 4;
        } else if (string.equals("lowered")) {
            this.borderStroke = 6;
        } else if (string.equals("raised")) {
            this.borderStroke = 7;
        } else if (string.equals("etched")) {
            this.borderStroke = 8;
        } else if (string.equals("embossed")) {
            this.borderStroke = 9;
        }
    }

    public void setEventAction(String string) {
        if (string.equals("change")) {
            this.activity = 1;
        } else if (string.equals("click")) {
            this.activity = 2;
        } else if (string.equals("docClose")) {
            this.activity = 3;
        } else if (string.equals("docReady")) {
            this.activity = 4;
        } else if (string.equals("enter")) {
            this.activity = 5;
        } else if (string.equals("exit")) {
            this.activity = 6;
        } else if (string.equals("full")) {
            this.activity = 7;
        } else if (string.equals("initialize")) {
            this.activity = 8;
        } else if (string.equals("mouseDown")) {
            this.activity = 9;
        } else if (string.equals("mouseEnter")) {
            this.activity = 10;
        } else if (string.equals("mouseExit")) {
            this.activity = 11;
        } else if (string.equals("mouseUp")) {
            this.activity = 12;
        } else if (string.equals("postExecute")) {
            this.activity = 13;
        } else if (string.equals("postPrint")) {
            this.activity = 17;
        } else if (string.equals("postSave")) {
            this.activity = 15;
        } else if (string.equals("preExecute")) {
            this.activity = 14;
        } else if (string.equals("preSave")) {
            this.activity = 16;
        } else if (string.equals("preSubmit")) {
            this.activity = 18;
        } else if (string.equals("ready")) {
            this.activity = 19;
        }
    }

    public void setTypeface(String string) {
        this.typeface = string;
    }

    public void setIntegerValue(String string) {
        if (string == null) {
            return;
        }
        try {
            this.numericValue = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LogWriter.writeFormLog("NumberFormatException XFAFormObject", false);
        }
    }

    public void setEditability(String string) {
        if (string.equals("0")) {
            this.editable = false;
        } else if (string.equals("1")) {
            this.editable = true;
        }
    }

    public void setWidth(int n) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.width = n;
    }

    public void setHeight(int n) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.height = n;
    }

    public void setX(int n) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.x = n;
    }

    public void setY(int n) {
        if (this.BBox == null) {
            this.BBox = new Rectangle(0, 0, 0, 0);
        }
        this.BBox.y = n;
    }

    public void setMarginBottomInset(int n) {
        this.marginBottomInset = n;
    }

    public void setMarginTopInset(int n) {
        this.marginTopInset = n;
    }

    public void setMarginLeftInset(int n) {
        this.marginLeftInset = n;
    }

    public void setMarginRightInset(int n) {
        this.marginRightInset = n;
    }

    public void setLongMeduim(int n) {
        this.longMedium = n;
    }

    public void setShortMedium(int n) {
        this.shortMedium = n;
    }

    public void setStdPaperName(String string) {
        this.stdPaperName = string;
    }

    public void setSubmitFormat(String string) {
        if (string.equals("xdp")) {
            this.submitDataFormat = 1;
        } else if (string.equals("delegate")) {
            this.submitDataFormat = 30;
        } else if (string.equals("formdata")) {
            this.submitDataFormat = 2;
        } else if (string.equals("pdf")) {
            this.submitDataFormat = 3;
        } else if (string.equals("xfd")) {
            this.submitDataFormat = 4;
        } else if (string.equals("xml")) {
            this.submitDataFormat = 5;
        }
    }

    public void setSubmitURL(String string) {
        this.submitURL = string;
    }

    public void setSubmitTextEncoding(String string) {
        if (this.submitDataFormat == 2) {
            return;
        }
        if (string.equalsIgnoreCase("none")) {
            this.submitTextEncode = 0;
        } else if (string.equalsIgnoreCase("ISO-8859-1")) {
            this.submitTextEncode = 1;
        } else if (string.equalsIgnoreCase("iso-8859-2")) {
            this.submitTextEncode = 2;
        } else if (string.equalsIgnoreCase("iso-8859-7")) {
            this.submitTextEncode = 3;
        } else if (string.equalsIgnoreCase("shift-jis")) {
            this.submitTextEncode = 4;
        } else if (string.equalsIgnoreCase("ksc-5601")) {
            this.submitTextEncode = 5;
        } else if (string.equalsIgnoreCase("big-five")) {
            this.submitTextEncode = 6;
        } else if (string.equalsIgnoreCase("gb-2312")) {
            this.submitTextEncode = 7;
        } else if (string.equalsIgnoreCase("utf-8")) {
            this.submitTextEncode = 8;
        } else if (string.equalsIgnoreCase("utf-16")) {
            this.submitTextEncode = 9;
        } else if (string.equalsIgnoreCase("ucs-2")) {
            this.submitTextEncode = 10;
        } else if (string.equalsIgnoreCase("fontSpecific")) {
            this.submitTextEncode = 15;
        }
    }

    public void setScriptType(String string) {
        this.scriptType = string;
    }
}

