/*
 * Decompiled with CFR 0.152.
 */
package org.jfr.examples;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jfr.parser.GenericStreamDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class TxtViewer
extends JPanel {
    ObjectStore localStore = new ObjectStore();
    DynamicVectorRenderer dvr = new DynamicVectorRenderer(1, true, 1000, this.localStore);
    GenericStreamDecoder painter = new GenericStreamDecoder(this.dvr);
    private PdfPageData pageData = new PdfPageData();
    int pageWidth = 600;
    int pageHeight = 800;
    int rotation = 0;
    int insetW = 5;
    int insetH = 5;
    int rightMargin = 600;
    float scaling = 1.0f;
    private Rectangle[] areas;
    private JFrame frame = new JFrame();
    private String loadedText = "";

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        TxtViewer txtViewer = new TxtViewer();
        txtViewer.setupViewer();
    }

    private void setupViewer() {
        this.frame.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(1);
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
        this.frame.setTitle("Text File Viewer 0.1");
        int n = 300;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.pageWidth = dimension.width / 2;
        this.pageHeight = dimension.height / 2;
        if (this.pageWidth < n) {
            this.pageWidth = n;
        }
        this.frame.setSize(this.pageWidth, this.pageHeight);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.pageData.setPageRotation(0, 1);
        this.pageData.setMediaBox(new float[]{0.0f, 0.0f, this.pageWidth, this.pageHeight});
        this.pageData.checkSizeSet(1);
        this.rightMargin = this.pageWidth;
        this.dvr.setBackgroundColor(Color.white);
        this.dvr.init(this.pageWidth, this.pageHeight, this.rotation);
        try {
            this.example();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void example() throws Exception {
        float f = 0.0f;
        float f2 = 0.0f;
        String[] stringArray = this.painter.getFontList();
        this.painter.setRightMargin(this.rightMargin);
        this.painter.setLeftMargin(0.0);
        this.painter.setTextLocationMatrix(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
        int n = stringArray.length;
        if (n > 17) {
            n = 17;
        }
        this.painter.setLeftMargin(10.0);
        this.painter.setForeground(new PdfColor(0, 255, 0));
        if (stringArray.length > 1) {
            this.painter.lineDown(2);
            this.painter.setForeground(new PdfColor(0, 0, 0));
            this.painter.setFont(stringArray[1], 16);
            this.loadTXTFile();
            this.renderLeftAlignedText(this.loadedText);
        } else {
            ShowGUIMessage.showGUIMessage("No fonts setup", "No fonts installed");
        }
        this.updateUI();
    }

    private void renderLeftAlignedText(String string) {
        double d = this.painter.getRightMargin();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            double d2;
            String string2 = stringTokenizer.nextToken();
            double d3 = this.painter.getCurrentXpt();
            if (d3 + (d2 = this.painter.getStringLength(string2)) > d) {
                this.painter.lineDown(1);
            }
            char c = '\r';
            char c2 = '\n';
            int n = 9;
            String string3 = String.valueOf(c) + c2;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n2 < string2.length()) {
                String string4;
                n4 = string2.indexOf(string3, n2);
                n3 = string2.indexOf(n, n2);
                if (n3 == -1 && n4 == -1) {
                    string4 = string2.substring(n2, string2.length());
                    d3 = this.painter.setText(string4);
                    n2 = string2.length();
                }
                if (n3 == -1) {
                    n3 = 99999;
                }
                if (n4 == -1) {
                    n4 = 99999;
                }
                if (n3 < n4) {
                    System.out.println("TAB");
                    string4 = string2.substring(n2, n3);
                    d3 = this.painter.setText(string4);
                    this.painter.tab();
                    n2 = n3 + 1;
                }
                if (n3 <= n4) continue;
                System.out.println("NEW_LINE");
                string4 = string2.substring(n2, n4);
                d3 = this.painter.setText(string4);
                this.painter.lineDown(1);
                n2 = n4 + 2;
            }
            this.painter.setText(" ");
        }
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        int n = (int)((float)this.insetW + (float)this.pageWidth * this.scaling);
        int n2 = (int)((float)this.insetH + (float)this.pageHeight * this.scaling);
        dimension = this.rotation == 90 | this.rotation == 270 ? new Dimension(n2, n) : new Dimension(n, n2);
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    private AffineTransform getScalingForImage(int n, int n2, float f) {
        double d = (float)this.pageData.getMediaBoxX(n) * f;
        double d2 = (float)this.pageData.getMediaBoxY(n) * f;
        double d3 = (float)this.pageData.getMediaBoxHeight(n) * f;
        double d4 = (float)this.pageData.getCropBoxWidth(n) * f;
        double d5 = (float)this.pageData.getCropBoxHeight(n) * f;
        double d6 = (float)this.pageData.getCropBoxX(n) * f;
        double d7 = (float)this.pageData.getCropBoxY(n) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = (int)(d4 + (d6 - d));
        int n4 = (int)(d5 + (d7 - d2));
        if (n2 == 270) {
            affineTransform.rotate(-1.5707963267948966, n3 / 2, n4 / 2);
            double d8 = affineTransform.getTranslateX();
            double d9 = affineTransform.getTranslateY();
            affineTransform.translate((double)n4 - d9, -d8);
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d6 + d), -(d3 - d5 - (d7 - d2)));
        } else if (n2 == 180) {
            affineTransform.rotate(Math.PI, n3 / 2, n4 / 2);
            affineTransform.translate(-(d6 + d), (double)n4 + (d7 + d2) - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n2 == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d7 + d2 - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d3 - d5 - (d7 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = this.getScalingForImage(0, 0, this.scaling);
        AffineTransform affineTransform3 = graphics2D.getTransform();
        graphics2D.transform(affineTransform2);
        this.dvr.paint(graphics2D, null, null, null, false, true);
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        if (this.areas != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setColor(Color.blue);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            if (this.areas != null) {
                int n = this.areas.length;
                for (int i = 0; i < n; ++i) {
                    if (this.areas[i] == null) continue;
                    graphics2D.fillRect(this.areas[i].x, this.areas[i].y, this.areas[i].width, this.areas[i].height);
                }
            }
            graphics2D.setComposite(composite);
        }
        graphics2D.setTransform(affineTransform3);
    }

    private void loadTXTFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showOpenDialog(this.frame);
        File file = jFileChooser.getSelectedFile();
        char c = '\r';
        char c2 = '\n';
        try {
            FileReader fileReader = new FileReader(file.getAbsolutePath());
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                this.loadedText = this.loadedText + string + c + c2;
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("[PDF] Error loading file");
        }
    }
}

