/*
 * Decompiled with CFR 0.152.
 */
package org.jfr.examples;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jfr.parser.GenericStreamDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class Viewer
extends JPanel {
    ObjectStore localStore = new ObjectStore();
    DynamicVectorRenderer dvr = new DynamicVectorRenderer(1, true, 1000, this.localStore);
    GenericStreamDecoder painter = new GenericStreamDecoder(this.dvr);
    private PdfPageData pageData = new PdfPageData();
    int pageWidth = 600;
    int pageHeight = 800;
    int rotation = 0;
    int insetW = 5;
    int insetH = 5;
    int rightMargin = 600;
    float scaling = 1.0f;
    private Rectangle[] areas;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        Viewer viewer = new Viewer();
        viewer.setupViewer();
    }

    private void setupViewer() {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowListener(){

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(1);
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(80);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(80);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.setTitle("Java Font Rasterizer demo 0.1");
        int n = 300;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.pageWidth = dimension.width / 2;
        this.pageHeight = dimension.height / 2;
        if (this.pageWidth < n) {
            this.pageWidth = n;
        }
        jFrame.setSize(this.pageWidth, this.pageHeight);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        this.pageData.setPageRotation(0, 1);
        this.pageData.setMediaBox(new float[]{0.0f, 0.0f, this.pageWidth, this.pageHeight});
        this.pageData.checkSizeSet(1);
        this.rightMargin = this.pageWidth;
        this.dvr.setBackgroundColor(Color.white);
        this.dvr.init(this.pageWidth, this.pageHeight, this.rotation);
        try {
            this.example();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void example() throws Exception {
        int n;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 8.0f;
        String[] stringArray = this.painter.getFontList();
        if (stringArray == null || stringArray.length < 1) {
            throw new Exception("No fonts configured");
        }
        this.painter.setRightMargin(this.rightMargin);
        this.painter.setLeftMargin(0.0);
        this.painter.setTextLocationMatrix(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
        int n2 = stringArray.length;
        if (n2 > 17) {
            n2 = 17;
        }
        for (n = 0; n < n2; ++n) {
            if ((n & 1) == 1) {
                this.painter.setForeground(new PdfColor(255, 0, 0));
            } else {
                this.painter.setForeground(new PdfColor(0, 0, 255));
            }
            this.painter.setFont(stringArray[n], 16);
            this.painter.setText(stringArray[n] + "   ");
        }
        this.painter.setLeftMargin(10.0);
        this.painter.setForeground(new PdfColor(0, 255, 0));
        if (stringArray.length > 1) {
            this.painter.lineDown(2);
            this.painter.setForeground(new PdfColor(0, 0, 0));
            for (n = 1; n < 6; ++n) {
                this.painter.setFont(stringArray[1], (int)(f3 * (float)n));
                this.painter.lineDown(2);
                this.renderLeftAlignedText("This is an example of a paragraph which should wrap on the screen and move onto the next line with an indent at the start");
            }
        } else {
            ShowGUIMessage.showGUIMessage("No fonts setup", "No fonts installed");
        }
        this.updateUI();
    }

    private void renderLeftAlignedText(String string) {
        double d = this.painter.getRightMargin();
        double d2 = this.painter.getLeftMargin();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            double d3;
            String string2 = stringTokenizer.nextToken();
            double d4 = this.painter.getCurrentXpt();
            if (d4 + (d3 = this.painter.getStringLength(string2)) > d) {
                this.painter.lineDown(1);
                this.painter.setCurrentXpt(d2);
            }
            d4 = this.painter.setText(string2);
            this.painter.setText(" ");
        }
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        int n = (int)((float)this.insetW + (float)this.pageWidth * this.scaling);
        int n2 = (int)((float)this.insetH + (float)this.pageHeight * this.scaling);
        dimension = this.rotation == 90 | this.rotation == 270 ? new Dimension(n2, n) : new Dimension(n, n2);
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public final Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    private AffineTransform getScalingForImage(int n, int n2, float f) {
        double d = (float)this.pageData.getMediaBoxX(n) * f;
        double d2 = (float)this.pageData.getMediaBoxY(n) * f;
        double d3 = (float)this.pageData.getMediaBoxHeight(n) * f;
        double d4 = (float)this.pageData.getCropBoxWidth(n) * f;
        double d5 = (float)this.pageData.getCropBoxHeight(n) * f;
        double d6 = (float)this.pageData.getCropBoxX(n) * f;
        double d7 = (float)this.pageData.getCropBoxY(n) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = (int)(d4 + (d6 - d));
        int n4 = (int)(d5 + (d7 - d2));
        if (n2 == 270) {
            affineTransform.rotate(-1.5707963267948966, n3 / 2, n4 / 2);
            double d8 = affineTransform.getTranslateX();
            double d9 = affineTransform.getTranslateY();
            affineTransform.translate((double)n4 - d9, -d8);
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d6 + d), -(d3 - d5 - (d7 - d2)));
        } else if (n2 == 180) {
            affineTransform.rotate(Math.PI, n3 / 2, n4 / 2);
            affineTransform.translate(-(d6 + d), (double)n4 + (d7 + d2) - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n2 == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d7 + d2 - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d3 - d5 - (d7 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        AffineTransform affineTransform2 = this.getScalingForImage(0, 0, this.scaling);
        AffineTransform affineTransform3 = graphics2D.getTransform();
        graphics2D.transform(affineTransform2);
        this.dvr.paint(graphics2D, null, null, null, false, true);
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        if (this.areas != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setColor(Color.blue);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.7f));
            if (this.areas != null) {
                int n = this.areas.length;
                for (int i = 0; i < n; ++i) {
                    if (this.areas[i] == null) continue;
                    graphics2D.fillRect(this.areas[i].x, this.areas[i].y, this.areas[i].width, this.areas[i].height);
                }
            }
            graphics2D.setComposite(composite);
        }
        graphics2D.setTransform(affineTransform3);
    }
}

