/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jpedal.Display;
import org.jpedal.PageOffsets;
import org.jpedal.PdfDecoder;
import org.jpedal.SingleDisplay;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;

public class PdfPanel
extends JPanel {
    public boolean turnoverOn = true;
    public boolean useNewGraphicsMode = true;
    private static final long serialVersionUID = -5480323101993399978L;
    double indent = 0.0;
    protected int userOffsetX = 0;
    protected int userOffsetY = 0;
    protected int userPrintOffsetX = 0;
    protected int userPrintOffsetY = 0;
    protected int facingCursorX = 10000;
    protected int facingCursorY = 10000;
    protected PdfLayerList layers;
    int[] highlightedImage = null;
    private boolean ImageExtractionAllowed = true;
    protected Display pages;
    protected AcroRenderer formRenderer;
    public static Color highlightColor = new Color(10, 100, 170);
    public static Color backgroundColor = null;
    public static float highlightComposite = 0.35f;
    protected Rectangle[] alternateOutlines;
    String altName;
    private int lastIndent = -1;
    PageOffsets currentOffset;
    protected boolean renderPage = false;
    protected boolean isPrintAutoRotateAndCenter = false;
    protected boolean usePDFPaperSize = false;
    protected int pageScalingMode = 2;
    protected int displayView = 1;
    private int scrollInterval = 10;
    protected int pageCount = 0;
    private boolean showCrop = false;
    boolean isNewRotationSet = false;
    protected boolean displayViewportBorder = false;
    protected boolean isDecoding = false;
    protected boolean isGeneratingPage = false;
    protected boolean formsDecoding = false;
    protected int alignment = 1;
    protected int displayRotation = 0;
    protected Rectangle viewableArea = null;
    private Vector_Int merge_level;
    private Vector_Shape merge_outline;
    private Color[] debugColors;
    AffineTransform demoAf = null;
    private RepaintManager currentManager = RepaintManager.currentManager(this);
    protected int pageNumber = 1;
    protected AffineTransform displayScaling;
    protected AffineTransform viewScaling = null;
    protected JScrollBar scroll = null;
    protected PdfPageData pageData = new PdfPageData();
    private Rectangle lastHighlight = null;
    protected Rectangle cursorBoxOnScreen = null;
    protected Rectangle lastCursorBoxOnScreen = null;
    private boolean drawCrossHairs = false;
    private int boxContained = -1;
    private Color selectedHandleColor = Color.red;
    private int handlesGap = 5;
    private Color outlineColor;
    protected Rectangle currentHighlightedObject = null;
    private Color outlineHighlightColor;
    private Color[] highlightColors;
    private static final int strip = 2;
    private Rectangle2D[] outlineZone = null;
    private int[] processedByRegularExpression = null;
    protected int insetW = 0;
    protected int insetH = 0;
    private boolean[] highlightedZonesSelected = null;
    private boolean[] hasDrownedObjects = null;
    Rectangle userAnnot = null;
    private int defaultSize;
    int y_size = this.defaultSize = 100;
    int max_y;
    int max_x;
    int x_size = this.defaultSize;
    int[] cx = null;
    int[] cy = null;
    protected float scaling = 1.0f;
    private int highlightMode = 0;
    public static final int SHOW_OBJECTS = 1;
    public static final int SHOW_LINES = 2;
    public static final int SHOW_BOXES = 4;
    protected int size = 20;
    protected Font highlightFont = null;
    protected Border myBorder = null;
    protected DropTarget dropTarget = null;
    public ObjectStore objectStoreRef = new ObjectStore();
    protected DynamicVectorRenderer currentDisplay = new DynamicVectorRenderer(1, this.objectStoreRef, false);
    protected boolean useBorder = true;
    private int[] selectionOrder;
    private Map lineAreas = new HashMap();
    private Map lineWritingMode = new HashMap();
    public Map areas = new HashMap();
    private Object[] linkedItems;
    private Object[] children;
    private int[] parents;
    protected boolean useAcceleration = true;
    private Shape[] fragmentShapes;
    int x_size_cropped;
    int y_size_cropped;
    private AffineTransform cursorAf;
    private Rectangle actualBox;
    private boolean drawInteractively = false;
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    private int pageUsedForTransform;
    protected int additionalPageCount = 0;
    protected int xOffset = 0;
    private boolean displayForms = true;
    public boolean extractingAsImage = false;
    protected ViewStack viewStack = new ViewStack();

    public Map getHighlightAreas() {
        return this.areas;
    }

    public void setHighlightAreas(Map map) {
        this.areas = map;
    }

    public void addAView(int n, Rectangle rectangle, Integer n2) {
        this.viewStack.add(n, rectangle, n2);
    }

    public void setExtractingAsImage(boolean bl) {
        this.extractingAsImage = bl;
    }

    public void initNonPDF(PdfDecoder pdfDecoder) {
        this.pages = new SingleDisplay(this.pageNumber, this.pageCount, this.currentDisplay);
        this.pages.setup(true, null, pdfDecoder);
    }

    public Rectangle getCombinedAreas(Rectangle rectangle, boolean bl) {
        if (this.currentDisplay != null) {
            return this.currentDisplay.getCombinedAreas(rectangle, bl);
        }
        return null;
    }

    public final BufferedImage getPageAsThumbnail(int n, DynamicVectorRenderer dynamicVectorRenderer) {
        if (dynamicVectorRenderer == null) {
            dynamicVectorRenderer = this.currentDisplay;
            ObjectStore.cachePage(new Integer(this.pageNumber), dynamicVectorRenderer);
        }
        BufferedImage bufferedImage = this.getImageFromRenderer(n, dynamicVectorRenderer, this.pageNumber);
        return bufferedImage;
    }

    protected BufferedImage getImageFromRenderer(int n, DynamicVectorRenderer dynamicVectorRenderer, int n2) {
        int n3 = this.pageData.getMediaBoxHeight(n2);
        int n4 = this.pageData.getMediaBoxX(n2);
        int n5 = this.pageData.getMediaBoxY(n2);
        int n6 = this.pageData.getCropBoxWidth(n2);
        int n7 = this.pageData.getCropBoxHeight(n2);
        int n8 = this.pageData.getCropBoxX(n2);
        int n9 = this.pageData.getCropBoxY(n2);
        if (n9 > 0) {
            n9 = n3 - n7 - n9;
        }
        float f = (float)n / (float)n7;
        int n10 = this.pageData.getRotation(n2);
        int n11 = -1;
        if (n10 == 90 | n10 == 270) {
            int n12 = n6;
            n6 = n7;
            n7 = n12;
            n11 = 1;
            n12 = n8;
            n8 = n9;
            n9 = n12;
        }
        AffineTransform affineTransform = this.getScalingForImage(n2, n10, f);
        int n13 = n4 - n8;
        int n14 = n5 - n9;
        affineTransform.translate(n13, n11 * n14);
        return dynamicVectorRenderer.getPageAsImage(f, n8, n9, n6, n7, n2, affineTransform, 1);
    }

    public final void setHighlightedZones(int n, int[] nArray, int[] nArray2, Shape[] shapeArray, Object[] objectArray, int[] nArray3, Object[] objectArray2, int[] nArray4, Rectangle2D[] rectangle2DArray, boolean[] blArray, boolean[] blArray2, Color[] colorArray, int[] nArray5, int[] nArray6) {
        this.cx = nArray;
        this.cy = nArray2;
        this.fragmentShapes = shapeArray;
        this.linkedItems = objectArray;
        this.parents = nArray3;
        this.children = objectArray2;
        this.outlineZone = rectangle2DArray;
        this.processedByRegularExpression = nArray6;
        this.highlightedZonesSelected = blArray;
        this.hasDrownedObjects = blArray2;
        this.highlightMode = n;
        this.highlightColors = colorArray;
        this.selectionOrder = nArray5;
        this.alternateOutlines = null;
    }

    public final void setInset(int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
    }

    public void ensurePointIsVisible(Point point) {
        super.scrollRectToVisible(new Rectangle(point.x, this.y_size - point.y, this.scrollInterval, this.scrollInterval));
    }

    public void setUserOffsets(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                this.userOffsetX = n;
                this.userOffsetY = n2;
                break;
            }
            case 1: {
                this.userPrintOffsetX = n;
                this.userPrintOffsetY = -n2;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = this.getHeight();
                SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                this.repaint();
                break;
            }
            case 998: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                this.repaint();
                break;
            }
            case 999: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                this.repaint();
                break;
            }
            case 996: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                this.repaint();
                break;
            }
            case 997: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                this.repaint();
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int n) {
        switch (n) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public final Dimension getMaximumSize() {
        Dimension dimension = null;
        if (this.displayView != 1) {
            dimension = this.pages.getPageSize(this.displayView);
        }
        if (dimension == null) {
            dimension = this.displayRotation == 90 | this.displayRotation == 270 ? new Dimension((int)((float)(this.y_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.x_size_cropped + this.insetH + this.insetH) : new Dimension((int)((float)(this.x_size_cropped + this.insetW + this.insetW) + (float)this.xOffset * this.scaling + (float)(this.additionalPageCount * (this.insetW + this.insetW))), this.y_size_cropped + this.insetH + this.insetH);
        }
        if (dimension == null) {
            dimension = this.getMinimumSize();
        }
        return dimension;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(100 + this.insetW, 100 + this.insetH);
    }

    public Dimension getPreferredSize() {
        return this.getMaximumSize();
    }

    public Rectangle[] getHighlightedAreas(int n) {
        if (this.areas == null) {
            return null;
        }
        Integer n2 = new Integer(n);
        Rectangle[] rectangleArray = (Rectangle[])this.areas.get(n2);
        if (rectangleArray != null) {
            int n3 = rectangleArray.length;
            Rectangle[] rectangleArray2 = new Rectangle[n3];
            for (int i = 0; i < n3; ++i) {
                rectangleArray2[i] = rectangleArray[i] == null ? null : new Rectangle(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
            }
            return rectangleArray2;
        }
        return null;
    }

    public Rectangle setFoundParagraph(int n, int n2, int n3) {
        Rectangle[] rectangleArray = this.getLineAreas(n3);
        if (rectangleArray != null) {
            Rectangle rectangle = new Rectangle(n, n2, 1, 1);
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            boolean bl = false;
            int n4 = 0;
            for (int i = 0; i != rectangleArray.length; ++i) {
                if (!rectangleArray[i].intersects(rectangle)) continue;
                n4 = i;
                bl = true;
                break;
            }
            if (bl) {
                int n5;
                double d = rectangleArray[n4].x;
                double d2 = rectangleArray[n4].getCenterX();
                double d3 = rectangleArray[n4].x + rectangleArray[n4].width;
                double d4 = rectangleArray[n4].getCenterY();
                int n6 = rectangleArray[n4].height;
                rectangle2.x = rectangleArray[n4].x;
                rectangle2.y = rectangleArray[n4].y;
                rectangle2.width = rectangleArray[n4].width;
                rectangle2.height = rectangleArray[n4].height;
                boolean bl2 = true;
                boolean bl3 = true;
                Vector_Rectangle vector_Rectangle = new Vector_Rectangle(0);
                vector_Rectangle.addElement(rectangleArray[n4]);
                block1: while (bl2) {
                    bl2 = false;
                    for (n5 = 0; n5 != rectangleArray.length; ++n5) {
                        if (!rectangleArray[n5].contains(d, d4 + (double)n6) && !rectangleArray[n5].contains(d2, d4 + (double)n6) && !rectangleArray[n5].contains(d3, d4 + (double)n6)) continue;
                        vector_Rectangle.addElement(rectangleArray[n5]);
                        bl2 = true;
                        d4 = rectangleArray[n5].getCenterY();
                        n6 = rectangleArray[n5].height;
                        if (rectangle2.x > rectangleArray[n5].x) {
                            rectangle2.width = rectangle2.x + rectangle2.width - rectangleArray[n5].x;
                            rectangle2.x = rectangleArray[n5].x;
                        }
                        if (rectangle2.x + rectangle2.width < rectangleArray[n5].x + rectangleArray[n5].width) {
                            rectangle2.width = rectangleArray[n5].x + rectangleArray[n5].width - rectangle2.x;
                        }
                        if (rectangle2.y > rectangleArray[n5].y) {
                            rectangle2.height = rectangle2.y + rectangle2.height - rectangleArray[n5].y;
                            rectangle2.y = rectangleArray[n5].y;
                        }
                        if (rectangle2.y + rectangle2.height >= rectangleArray[n5].y + rectangleArray[n5].height) continue block1;
                        rectangle2.height = rectangleArray[n5].y + rectangleArray[n5].height - rectangle2.y;
                        continue block1;
                    }
                }
                d = rectangleArray[n4].x;
                d2 = rectangleArray[n4].getCenterX();
                d3 = rectangleArray[n4].x + rectangleArray[n4].width;
                d4 = rectangleArray[n4].getCenterY();
                n6 = rectangleArray[n4].height;
                block3: while (bl3) {
                    bl3 = false;
                    for (n5 = 0; n5 != rectangleArray.length; ++n5) {
                        if (!rectangleArray[n5].contains(d, d4 - (double)n6) && !rectangleArray[n5].contains(d2, d4 - (double)n6) && !rectangleArray[n5].contains(d3, d4 - (double)n6)) continue;
                        vector_Rectangle.addElement(rectangleArray[n5]);
                        bl3 = true;
                        d4 = rectangleArray[n5].getCenterY();
                        n6 = rectangleArray[n5].height;
                        if (rectangle2.x > rectangleArray[n5].x) {
                            rectangle2.width = rectangle2.x + rectangle2.width - rectangleArray[n5].x;
                            rectangle2.x = rectangleArray[n5].x;
                        }
                        if (rectangle2.x + rectangle2.width < rectangleArray[n5].x + rectangleArray[n5].width) {
                            rectangle2.width = rectangleArray[n5].x + rectangleArray[n5].width - rectangle2.x;
                        }
                        if (rectangle2.y > rectangleArray[n5].y) {
                            rectangle2.height = rectangle2.y + rectangle2.height - rectangleArray[n5].y;
                            rectangle2.y = rectangleArray[n5].y;
                        }
                        if (rectangle2.y + rectangle2.height >= rectangleArray[n5].y + rectangleArray[n5].height) continue block3;
                        rectangle2.height = rectangleArray[n5].y + rectangleArray[n5].height - rectangle2.y;
                        continue block3;
                    }
                }
                vector_Rectangle.trim();
                this.addHighlights(vector_Rectangle.get(), true, n3);
                return rectangle2;
            }
            return null;
        }
        return null;
    }

    public void addHighlights(Rectangle[] rectangleArray, boolean bl, int n) {
        block38: {
            if (rectangleArray == null) break block38;
            if (DynamicVectorRenderer.textBasedHighlight && !bl) {
                for (int i = 0; i != rectangleArray.length; ++i) {
                    int n2;
                    int n3;
                    if (rectangleArray[i] == null) continue;
                    Point point = new Point(rectangleArray[i].x + 1, rectangleArray[i].y + 1);
                    Point point2 = new Point(rectangleArray[i].x + rectangleArray[i].width - 1, rectangleArray[i].y + rectangleArray[i].height - 1);
                    if (this.areas == null) {
                        this.areas = new HashMap();
                    }
                    Rectangle[] rectangleArray2 = this.getLineAreas(n);
                    int[] nArray = this.getLineWritingMode(n);
                    int n4 = -1;
                    int n5 = -1;
                    boolean bl2 = false;
                    if (rectangleArray2 == null) continue;
                    for (n3 = 0; n3 != rectangleArray2.length; ++n3) {
                        if (rectangleArray2[n3].contains(point)) {
                            n4 = n3;
                        }
                        if (rectangleArray2[n3].contains(point2)) {
                            n5 = n3;
                        }
                        if (n4 != -1 && n5 != -1) break;
                    }
                    if (n4 > n5) {
                        n3 = n4;
                        n4 = n5;
                        n5 = n3;
                        bl2 = true;
                    }
                    if (n4 == n5 && point.x > point2.x) {
                        Point point3 = point;
                        point = point2;
                        point2 = point3;
                    }
                    if (n4 == -1 || n5 == -1) continue;
                    Integer n6 = new Integer(n);
                    Rectangle[] rectangleArray3 = (Rectangle[])this.areas.get(n6);
                    rectangleArray3 = new Rectangle[n5 - n4 + 1];
                    for (n2 = 0; n2 <= n5 - n4; ++n2) {
                        rectangleArray3[n2] = rectangleArray2[n4 + n2];
                    }
                    if (rectangleArray3.length > 0) {
                        n2 = 0;
                        int n7 = rectangleArray3.length - 1;
                        if (rectangleArray3[n2] != null && rectangleArray3[n7] != null) {
                            switch (nArray[n4]) {
                                case 0: {
                                    if (bl2) {
                                        if (point2.x - 15 <= rectangleArray3[n2].x) break;
                                        rectangleArray3[n2].width -= point2.x - rectangleArray3[n2].x;
                                        rectangleArray3[n2].x = point2.x;
                                        break;
                                    }
                                    if (point.x - 15 <= rectangleArray3[n2].x) break;
                                    rectangleArray3[n2].width -= point.x - rectangleArray3[n2].x;
                                    rectangleArray3[n2].x = point.x;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (bl2) {
                                        if (point2.y - 15 <= rectangleArray3[n2].y) break;
                                        rectangleArray3[n2].height -= point2.y - rectangleArray3[n2].y;
                                        rectangleArray3[n2].y = point2.y;
                                        break;
                                    }
                                    if (point.y - 15 <= rectangleArray3[n2].y) break;
                                    rectangleArray3[n2].height -= point.y - rectangleArray3[n2].y;
                                    rectangleArray3[n2].y = point.y;
                                    break;
                                }
                                case 3: {
                                    if (bl2) {
                                        if (point2.y - 15 <= rectangleArray3[n2].y) break;
                                        rectangleArray3[n2].height -= point2.y - rectangleArray3[n2].y;
                                        rectangleArray3[n2].y = point2.y;
                                        break;
                                    }
                                    if (point.y - 15 <= rectangleArray3[n2].y) break;
                                    rectangleArray3[n2].height -= point.y - rectangleArray3[n2].y;
                                    rectangleArray3[n2].y = point.y;
                                }
                            }
                            switch (nArray[n5]) {
                                case 0: {
                                    if (bl2) {
                                        if (point.x + 15 >= rectangleArray3[n7].x + rectangleArray3[n7].width) break;
                                        rectangleArray3[n7].width = point.x - rectangleArray3[n7].x;
                                        break;
                                    }
                                    if (point2.x + 15 >= rectangleArray3[n7].x + rectangleArray3[n7].width) break;
                                    rectangleArray3[n7].width = point2.x - rectangleArray3[n7].x;
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    if (bl2) {
                                        if (point.y + 15 >= rectangleArray3[n7].y + rectangleArray3[n7].height) break;
                                        rectangleArray3[n7].height = point.y - rectangleArray3[n7].y;
                                        break;
                                    }
                                    if (point2.y + 15 >= rectangleArray3[n7].y + rectangleArray3[n7].height) break;
                                    rectangleArray3[n7].height = point2.y - rectangleArray3[n7].y;
                                    break;
                                }
                                case 3: {
                                    if (bl2) {
                                        if (point.y + 15 >= rectangleArray3[n7].y + rectangleArray3[n7].height) break;
                                        rectangleArray3[n7].height = point.y - rectangleArray3[n7].y;
                                        break;
                                    }
                                    if (point2.y + 15 >= rectangleArray3[n7].y + rectangleArray3[n7].height) break;
                                    rectangleArray3[n7].height = point2.y - rectangleArray3[n7].y;
                                }
                            }
                        }
                    }
                    this.areas.put(n6, rectangleArray3);
                }
            } else {
                for (int i = 0; i != rectangleArray.length; ++i) {
                    Rectangle[] rectangleArray4;
                    Integer n8;
                    if (rectangleArray[i] == null) continue;
                    if (rectangleArray[i].width < 0) {
                        rectangleArray[i].width = -rectangleArray[i].width;
                        rectangleArray[i].x -= rectangleArray[i].width;
                    }
                    if (rectangleArray[i].height < 0) {
                        rectangleArray[i].height = -rectangleArray[i].height;
                        rectangleArray[i].y -= rectangleArray[i].height;
                    }
                    if (this.areas != null) {
                        n8 = new Integer(n);
                        rectangleArray4 = (Rectangle[])this.areas.get(n8);
                        if (rectangleArray4 != null) {
                            int n9;
                            boolean bl3 = false;
                            int n10 = rectangleArray4.length;
                            for (n9 = 0; n9 < n10; ++n9) {
                                if (rectangleArray4[n9] == null || rectangleArray4[n9] == null || rectangleArray4[n9].x != rectangleArray[i].x || rectangleArray4[n9].y != rectangleArray[i].y || rectangleArray4[n9].width != rectangleArray[i].width || rectangleArray4[n9].height != rectangleArray[i].height) continue;
                                bl3 = true;
                                n9 = n10;
                            }
                            if (!bl3) {
                                n9 = rectangleArray4.length + 1;
                                Rectangle[] rectangleArray5 = new Rectangle[n9];
                                for (int j = 0; j < rectangleArray4.length; ++j) {
                                    if (rectangleArray4[j] == null) continue;
                                    rectangleArray5[j + 1] = new Rectangle(rectangleArray4[j].x, rectangleArray4[j].y, rectangleArray4[j].width, rectangleArray4[j].height);
                                }
                                rectangleArray4 = rectangleArray5;
                                rectangleArray4[0] = rectangleArray[i];
                            }
                            this.areas.put(n8, rectangleArray4);
                            continue;
                        }
                        this.areas.put(n8, rectangleArray);
                        continue;
                    }
                    this.areas = new HashMap();
                    n8 = new Integer(n);
                    rectangleArray4 = new Rectangle[]{rectangleArray[i]};
                    this.areas.put(n8, rectangleArray4);
                }
            }
        }
    }

    public void clearHighlights() {
        this.areas = null;
    }

    public void removeFoundTextArea(Rectangle rectangle, int n) {
        if (rectangle == null || this.areas == null) {
            return;
        }
        Integer n2 = new Integer(n);
        Rectangle[] rectangleArray = (Rectangle[])this.areas.get(n2);
        if (rectangleArray != null) {
            int n3 = rectangleArray.length;
            for (int i = 0; i < n3; ++i) {
                if (rectangleArray[i] == null || !rectangleArray[i].contains(rectangle) && (rectangleArray[i].x != rectangle.x || rectangleArray[i].y != rectangle.y || rectangleArray[i].width != rectangle.width || rectangleArray[i].height != rectangle.height)) continue;
                rectangleArray[i] = null;
                i = n3;
            }
            this.areas.put(n2, rectangleArray);
        }
        this.pages.refreshDisplay();
    }

    public void removeFoundTextAreas(Rectangle[] rectangleArray, int n) {
        if (rectangleArray == null) {
            this.areas = null;
        } else {
            int n2;
            int n3 = rectangleArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                this.removeFoundTextArea(rectangleArray[n2], n);
            }
            n2 = 1;
            Integer n4 = new Integer(n);
            Rectangle[] rectangleArray2 = (Rectangle[])this.areas.get(n4);
            if (rectangleArray2 != null) {
                for (int i = 0; i < rectangleArray2.length; ++i) {
                    if (rectangleArray2[i] == null) continue;
                    n2 = 0;
                    i = rectangleArray2.length;
                }
                if (n2 != 0) {
                    rectangleArray2 = null;
                    this.areas.put(n4, rectangleArray2);
                }
            }
        }
        this.pages.refreshDisplay();
    }

    public final void updateCursorBoxOnScreen(Rectangle rectangle, Color color) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.displayView != 1) {
            return;
        }
        int n5 = this.x_size;
        int n6 = this.y_size;
        if (rectangle != null) {
            int n7;
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
            int n8 = this.pageData.getCropBoxX(this.pageNumber);
            int n9 = this.pageData.getCropBoxY(this.pageNumber);
            int n10 = this.pageData.getCropBoxWidth(this.pageNumber);
            int n11 = this.pageData.getCropBoxHeight(this.pageNumber);
            if (n3 > 0 && n3 < n9) {
                n3 += n9;
            }
            if (n4 < n8) {
                n7 = n8 - n4;
                n2 -= n7;
                n4 = n8;
            }
            if (n3 < n9) {
                n7 = n9 - n3;
                n -= n7;
                n3 += n7;
            }
            if (n4 + n2 > n10 + n8 + this.xOffset) {
                n2 = n8 + this.xOffset + n10 - n4;
            }
            if (n3 + n > n9 + n11) {
                n = n9 + n11 - n3;
            }
            this.cursorBoxOnScreen = new Rectangle(n4, n3, n2, n);
        } else {
            this.cursorBoxOnScreen = null;
        }
        this.outlineColor = color;
        n4 = 30;
        n3 = 0;
        if (this.alignment == 2) {
            n2 = this.getBounds().width;
            n = this.getPDFWidth();
            if (this.displayView != 1) {
                n = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            n3 = (n2 - n) / 2;
        }
        if (this.lastCursorBoxOnScreen != null) {
            if (this.displayRotation == 0 || this.displayRotation == 180) {
                this.currentManager.addDirtyRegion(this, this.insetW + n3, this.insetH, n5 + 5 + this.xOffset, n6);
            } else {
                this.currentManager.addDirtyRegion(this, this.insetH + n3, this.insetW, n6 + 5 + this.xOffset, n5);
            }
            this.lastCursorBoxOnScreen = null;
        }
        if (this.cursorBoxOnScreen != null) {
            this.currentManager.addDirtyRegion(this, (int)((float)this.cursorBoxOnScreen.x * this.scaling) - n4, (int)((float)(this.max_y - this.cursorBoxOnScreen.y - this.cursorBoxOnScreen.height) * this.scaling) - n4, (int)((float)this.cursorBoxOnScreen.width * this.scaling) + n4 + n4, (int)((float)this.cursorBoxOnScreen.height * this.scaling) + n4 + n4);
        }
        if (this.viewScaling != null) {
            this.currentManager.markCompletelyDirty(this);
        }
        this.repaint();
    }

    public void repaintArea(Rectangle rectangle, int n) {
        int n2 = 10;
        if (n2 < this.insetH) {
            n2 = this.insetH;
        }
        if (n2 < this.insetW) {
            n2 = this.insetW;
        }
        int n3 = (int)((float)rectangle.x * this.scaling) - n2;
        int n4 = (int)((float)(n - rectangle.y - rectangle.height) * this.scaling) - n2;
        int n5 = (int)((float)(rectangle.x + rectangle.width) * this.scaling) + n2 + n2;
        int n6 = (int)((float)(rectangle.y + rectangle.height) * this.scaling) + n2 + n2;
        this.currentManager.addDirtyRegion(this, n3, n4, n5, n6);
    }

    public final void removeHiglightedObject() {
        this.clearHighlights();
        if (this.lastHighlight != null) {
            int n = this.lastHighlight.x - 2;
            int n2 = this.lastHighlight.y - 2;
            int n3 = this.lastHighlight.width + 2 + 2;
            int n4 = this.lastHighlight.height + 2 + 2;
            this.currentManager.addDirtyRegion(this, n, n2, n3, n4);
            this.currentHighlightedObject = null;
        }
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (!this.isDecoding && this.cursorBoxOnScreen != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                if (this.cursorAf != null) {
                    graphics2D.setTransform(this.cursorAf);
                    Shape shape = graphics2D.getClip();
                    if (this.alignment == 2 && shape != null) {
                        graphics2D.setClip(null);
                    }
                    this.paintRectangle(graphics2D);
                    graphics2D.setClip(shape);
                    graphics2D.setTransform(affineTransform);
                }
            }
        }
        catch (Exception exception) {
            this.pages.flushPageCaches();
        }
        catch (Error error) {
            this.pages.flushPageCaches();
            this.pages.stopGeneratingPage();
            this.paint(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        boolean bl;
        SwingGUI swingGUI = (SwingGUI)((PdfDecoder)this).getExternalHandler(11);
        boolean bl2 = bl = swingGUI != null && swingGUI.getPageTurnScalingAppropriate();
        if (SwingUtilities.isEventDispatchThread()) {
            this.threadSafePaint(graphics);
        } else {
            final Graphics graphics2 = graphics;
            Runnable runnable = new Runnable(){

                public void run() {
                    PdfPanel.this.threadSafePaint(graphics2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private synchronized void threadSafePaint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        super.paintComponent(graphics);
        if (this.displayView == 6) {
            this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, false, this.pageData, this.insetW, this.insetH);
        }
        if (this.displayScaling == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(this.userOffsetX, this.userOffsetY);
        if (this.renderPage && this.displayForms) {
            int n8 = this.pageNumber;
            n7 = this.pageNumber;
            if (this.displayView != 1 && this.displayView != 5) {
                n8 = this.pages.getStartPage();
                n7 = this.pages.getEndPage();
                if (n8 == 0 || n7 == 0 || this.lastEnd != n7 || this.lastStart != n8) {
                    this.lastFormPage = -1;
                }
                this.lastEnd = n7;
                this.lastStart = n8;
            }
            if (this.lastFormPage != this.pageNumber && !this.isDecoding && this.formRenderer != null) {
                this.formRenderer.displayComponentsOnscreen(n8, n7);
                if (this.formRenderer.getCompData().getStartComponentCountForPage(this.pageNumber) != -1) {
                    this.lastFormPage = this.pageNumber;
                }
            }
        }
        if (DynamicVectorRenderer.debugPaint) {
            System.err.println("threadsafePaint called " + this.displayView);
        }
        this.pages.init(this.scaling, this.pageCount, this.displayRotation, this.pageNumber, this.currentDisplay, false, this.pageData, this.insetW, this.insetH);
        if (this.alignment == 2) {
            double d = this.getBounds().getWidth();
            if (this.displayView == 5) {
                d = this.getVisibleRect().getWidth();
            }
            n6 = this.getPDFWidth();
            if (this.displayView != 1) {
                n6 = (int)this.pages.getPageSize(this.displayView).getWidth();
            }
            if (this.displayView == 5) {
                this.indent = (this.getVisibleRect().width - this.pages.getWidthForPage(this.pageNumber)) / 2 - this.insetW - this.getBounds().x;
            } else if (this.displayView == 3) {
                PdfDecoder pdfDecoder = (PdfDecoder)this;
                n5 = this.pageNumber;
                if ((n5 & 1) == 1) {
                    --n5;
                }
                n4 = 0;
                n3 = 0;
                n4 = (this.displayRotation + pdfDecoder.getPdfPageData().getRotation(n5)) % 180 == 90 ? pdfDecoder.getPdfPageData().getCropBoxHeight(n5) : pdfDecoder.getPdfPageData().getCropBoxWidth(n5);
                n3 = n5 + 1 > this.pageCount ? n4 : ((this.displayRotation + pdfDecoder.getPdfPageData().getRotation(n5 + 1)) % 180 == 90 ? pdfDecoder.getPdfPageData().getCropBoxHeight(n5 + 1) : pdfDecoder.getPdfPageData().getCropBoxWidth(n5 + 1));
                n2 = n4 + n3;
                n = 0;
                if (!this.turnoverOn || pdfDecoder.getPdfPageData().hasMultipleSizes() || this.pageCount == 2) {
                    n = 10 / 2;
                }
                this.indent = (d - (double)((float)n2 * this.scaling)) / 2.0 - (double)n - (double)this.insetW;
            } else {
                this.indent = (d - (double)n6) / 2.0;
            }
            if (this.displayView == 1) {
                this.lastIndent = (int)this.indent;
            } else if ((this.displayView == 2 || this.displayView == 5) && this.lastIndent != -1) {
                this.indent = this.lastIndent;
                this.lastIndent = -1;
            } else {
                this.lastIndent = -1;
            }
            graphics2D.translate(this.indent, 0.0);
            if (this.formRenderer != null) {
                if (this.displayView == 5) {
                    this.indent -= (double)(this.pageNumber - 1) * PageOffsets.getPageFlowPageWidth((int)((float)this.pageData.getCropBoxWidth(this.pageNumber) * this.scaling), this.scaling);
                }
                this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.userOffsetX, this.userOffsetY, this.displayView, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
                this.formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
            }
        } else if (this.formRenderer != null) {
            this.lastIndent = -1;
            this.formRenderer.getCompData().setPageValues(this.scaling, this.displayRotation, (int)this.indent, this.userOffsetX, this.userOffsetY, this.displayView, this.currentOffset.widestPageNR, this.currentOffset.widestPageR);
            this.formRenderer.getCompData().resetScaledLocation(this.scaling, this.displayRotation, (int)this.indent);
        }
        Rectangle rectangle = null;
        if (this.areas != null) {
            this.pages.initRenderer(this.areas, graphics2D, this.myBorder, (int)this.indent);
        } else {
            this.pages.initRenderer(null, graphics2D, this.myBorder, (int)this.indent);
        }
        if (!this.isDecoding || this.drawInteractively) {
            this.actualBox = this.pages.drawPage(this.viewScaling, this.displayScaling, this.pageUsedForTransform);
        } else {
            this.currentDisplay.paintBackground(graphics2D, rectangle);
        }
        if (this.displayView == 1) {
            if (this.currentHighlightedObject == null && this.lastHighlight != null) {
                this.lastHighlight = null;
            }
            if (this.viewScaling != null) {
                graphics2D.transform(this.viewScaling);
            }
            if (this.highlightedZonesSelected != null) {
                this.paintHighlights(graphics2D);
            }
            if (this.cursorBoxOnScreen != null) {
                this.cursorAf = graphics2D.getTransform();
            } else {
                this.actualBox = null;
            }
            this.pages.resetToDefaultClip();
            if (this.currentHighlightedObject != null) {
                graphics2D.setColor(this.outlineHighlightColor);
                graphics2D.draw(this.currentHighlightedObject);
            }
            if (this.showCrop) {
                graphics2D.setColor(Color.orange);
                this.pages.completeForm(graphics2D);
            }
        }
        if (this.highlightedImage != null) {
            n7 = (int)((float)this.highlightedImage[0] * this.scaling);
            n6 = (int)((float)this.highlightedImage[1] * this.scaling);
            int n9 = (int)((float)this.highlightedImage[2] * this.scaling);
            n5 = (int)((float)this.highlightedImage[3] * this.scaling);
            if (n9 < 0) {
                n9 = -n9;
                n7 -= n9;
            }
            if (n5 < 0) {
                n5 = -n5;
                n6 -= n5;
            }
            n2 = n9;
            n = n5;
            if (this.displayRotation == 90) {
                n = n9;
                n2 = n5;
                n4 = this.insetW + n6;
                n3 = this.insetH + n7;
            } else if (this.displayRotation == 180) {
                n4 = (int)((float)this.max_x * this.scaling - (float)n7 - (float)n9) + this.insetW;
                n3 = this.insetH + n6;
            } else if (this.displayRotation == 270) {
                n = n9;
                n2 = n5;
                n3 = (int)((float)this.max_x * this.scaling - (float)n7 - (float)n9) + this.insetW;
                n4 = (int)((float)this.max_y * this.scaling - (float)n6 - (float)n5) + this.insetH;
            } else {
                n4 = this.insetW + n7;
                n3 = (int)((float)this.max_y * this.scaling - (float)n6 - (float)n5) + this.insetH;
            }
            Color color = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setComposite(AlphaComposite.getInstance(3, PdfDecoder.highlightComposite));
            if (DynamicVectorRenderer.invertHighlight) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setXORMode(Color.BLACK);
            } else {
                graphics2D.setColor(PdfDecoder.highlightColor);
                graphics2D.drawRect(n4, n3, n2, n);
            }
            graphics2D.fillRect(n4, n3, n2, n);
            graphics2D.setColor(color);
            graphics2D.setComposite(composite);
            graphics2D.setStroke(stroke);
        }
        this.pages.drawBorder();
        graphics2D.setTransform(affineTransform);
    }

    public void scrollRectToHighlight(Rectangle rectangle, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n < 1 || n > this.pageCount || this.displayView == 1) {
            n = this.pageNumber;
        }
        int n6 = this.pageData.getCropBoxWidth(n);
        int n7 = this.pageData.getCropBoxHeight(n);
        int n8 = this.pageData.getCropBoxX(n);
        int n9 = this.pageData.getCropBoxY(n);
        switch (this.displayRotation) {
            case 0: {
                n2 = (int)((float)(rectangle.x - n8) * this.scaling) + this.insetW;
                n3 = (int)((float)(n7 - (rectangle.y - n9)) * this.scaling) + this.insetH;
                n4 = (int)((float)rectangle.width * this.scaling);
                n5 = (int)((float)rectangle.height * this.scaling);
                break;
            }
            case 90: {
                n2 = (int)((float)(rectangle.y - n9) * this.scaling) + this.insetH;
                n3 = (int)((float)(rectangle.x - n8) * this.scaling) + this.insetW;
                n4 = (int)((float)rectangle.height * this.scaling);
                n5 = (int)((float)rectangle.width * this.scaling);
                break;
            }
            case 180: {
                n2 = (int)((float)(n6 - (rectangle.x - n8)) * this.scaling) + this.insetW;
                n3 = (int)((float)(rectangle.y - n9) * this.scaling) + this.insetH;
                n4 = (int)((float)rectangle.width * this.scaling);
                n5 = (int)((float)rectangle.height * this.scaling);
                break;
            }
            case 270: {
                n2 = (int)((float)(n7 - (rectangle.y - n9)) * this.scaling) + this.insetH;
                n3 = (int)((float)(n6 - (rectangle.x - n8)) * this.scaling) + this.insetW;
                n4 = (int)((float)rectangle.height * this.scaling);
                n5 = (int)((float)rectangle.width * this.scaling);
            }
        }
        if (this.displayView != 1) {
            n2 += this.pages.getXCordForPage(n);
            n3 += this.pages.getYCordForPage(n);
        }
        n2 = n2 > this.getVisibleRect().x + this.getVisibleRect().width / 2 ? (n2 += this.getVisibleRect().width / 2 - rectangle.width / 2) : (n2 -= this.getVisibleRect().width / 2 - rectangle.width / 2);
        n3 = n3 > this.getVisibleRect().y + this.getVisibleRect().height / 2 ? (n3 += this.getVisibleRect().height / 2 - rectangle.height / 2) : (n3 -= this.getVisibleRect().height / 2 - rectangle.height / 2);
        Rectangle rectangle2 = new Rectangle(n2 - this.scrollInterval, n3 - this.scrollInterval, n4 + this.scrollInterval * 2, n5 + this.scrollInterval * 2);
        this.scrollRectToVisible(rectangle2);
    }

    public void setDrawCrossHairs(boolean bl, int n, Color color) {
        this.drawCrossHairs = bl;
        this.boxContained = n;
        this.selectedHandleColor = color;
    }

    private void paintRectangle(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = this.scaling < 0.0f ? new BasicStroke(1.0f / -this.scaling) : new BasicStroke(1.0f / this.scaling);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(this.outlineColor);
        if (!DynamicVectorRenderer.textBasedHighlight || this.extractingAsImage) {
            graphics2D.draw(this.cursorBoxOnScreen);
        }
        if (this.drawCrossHairs) {
            int n6 = this.cursorBoxOnScreen.x;
            n5 = this.cursorBoxOnScreen.y;
            n4 = n6 + this.cursorBoxOnScreen.width;
            n3 = n5 + this.cursorBoxOnScreen.height;
            n2 = this.pageData.getMediaBoxWidth(this.pageNumber);
            int n7 = this.pageData.getMediaBoxHeight(this.pageNumber);
            n = this.pageData.getMediaBoxX(this.pageNumber);
            int n8 = this.pageData.getMediaBoxY(this.pageNumber);
            if (this.scaling > 0.0f) {
                graphics2D.setStroke(new BasicStroke(3.0f / this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / this.scaling, 0.0f, 6.0f / this.scaling}, 0.0f));
            } else {
                graphics2D.setStroke(new BasicStroke(3.0f / -this.scaling, 1, 1, 0.0f, new float[]{0.0f, 6.0f / -this.scaling, 0.0f, 6.0f / -this.scaling}, 0.0f));
            }
            graphics2D.drawLine(n6, n5, n, n5);
            graphics2D.drawLine(n6, n5, n6, n8);
            graphics2D.drawLine(n4, n5, n2, n5);
            graphics2D.drawLine(n4, n5, n4, n8);
            graphics2D.drawLine(n6, n3, n, n3);
            graphics2D.drawLine(n6, n3, n6, n7);
            graphics2D.drawLine(n4, n3, n2, n3);
            graphics2D.drawLine(n4, n3, n4, n7);
            Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n6 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 + Math.abs(n4 - n6) / 2 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 + Math.abs(n3 - n5) / 2 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n6 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n5 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2), new Rectangle(n4 - this.handlesGap, n3 - this.handlesGap, this.handlesGap * 2, this.handlesGap * 2)};
            graphics2D.setStroke(basicStroke);
            if (this.boxContained != -1 && this.boxContained < rectangleArray.length) {
                if (this.selectedHandleColor != null) {
                    Color color = graphics2D.getColor();
                    graphics2D.setColor(this.selectedHandleColor);
                    graphics2D.fill(rectangleArray[this.boxContained]);
                    graphics2D.setColor(color);
                } else {
                    graphics2D.fill(rectangleArray[this.boxContained]);
                }
            }
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (i == this.boxContained) continue;
                graphics2D.draw(rectangleArray[i]);
            }
        }
        graphics2D.setStroke(stroke);
        if (this.actualBox == null) {
            this.lastCursorBoxOnScreen = this.cursorBoxOnScreen;
        } else {
            Rectangle rectangle = this.cursorBoxOnScreen.getBounds();
            n5 = (int)rectangle.getMinX();
            n4 = (int)rectangle.getMinY();
            n3 = (int)rectangle.getMaxX();
            n2 = (int)rectangle.getMaxY();
            Rectangle rectangle2 = this.actualBox.getBounds();
            n = (int)rectangle2.getMinX();
            if (n < n5) {
                n5 = n;
            }
            if ((n = (int)rectangle2.getMinY()) < n4) {
                n4 = n;
            }
            if ((n = (int)rectangle2.getMaxX()) > n3) {
                n3 = n;
            }
            if ((n = (int)rectangle2.getMaxY()) > n2) {
                n2 = n;
            }
            this.lastCursorBoxOnScreen = new Rectangle(n5 - 5, n4 - 5, 10 + n3 - n5, 10 + (n2 - n4));
        }
    }

    private void paintHighlights(Graphics2D graphics2D) {
        if (this.alternateOutlines != null) {
            int n;
            int n2 = this.alternateOutlines.length;
            for (n = 0; n < n2; ++n) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                graphics2D.setColor(Color.darkGray);
                graphics2D.fill(this.alternateOutlines[n]);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
                graphics2D.draw(this.alternateOutlines[n]);
            }
            if (this.merge_outline != null && !this.altName.equals("Nothing") && !this.altName.equals("Lines")) {
                n = this.merge_outline.size() - 1;
                for (int i = 0; i < n; ++i) {
                    Area area = this.merge_outline.elementAt(i);
                    int n3 = this.merge_level.elementAt(i);
                    if (!(n3 == 2 & area != null)) continue;
                    graphics2D.setColor(this.debugColors[n3]);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                    graphics2D.draw(area.getBounds());
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
                    graphics2D.fill(area);
                }
            }
        } else {
            int n = this.highlightedZonesSelected.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray;
                if (this.highlightedZonesSelected[i]) {
                    if (this.hasDrownedObjects == null) {
                        this.highlightStoryOnscreen(graphics2D, i, false);
                        continue;
                    }
                    this.highlightStoryOnscreen(graphics2D, i, this.hasDrownedObjects[i]);
                    continue;
                }
                if ((this.highlightMode & 1) != 1 || this.fragmentShapes[i] == null) continue;
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                if (this.highlightColors[i] == null) {
                    graphics2D.setColor(Color.darkGray);
                } else {
                    graphics2D.setColor(this.highlightColors[i]);
                }
                graphics2D.fill(this.fragmentShapes[i]);
                graphics2D.draw(this.outlineZone[i]);
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
                graphics2D.draw(this.outlineZone[i]);
                if (this.children != null && (nArray = (int[])this.children[i]) != null) {
                    this.drawRelationships(false, graphics2D, i + "-", nArray);
                }
                if (this.linkedItems == null || (nArray = (int[])this.linkedItems[i]) == null) continue;
                this.numberItems(false, graphics2D, i + "-", nArray);
            }
            if (this.selectionOrder != null) {
                this.drawRelationships(false, graphics2D, "", this.selectionOrder);
            }
        }
    }

    private void highlightStoryOnscreen(Graphics2D graphics2D, int n, boolean bl) {
        int n2;
        Stroke stroke = graphics2D.getStroke();
        if (bl) {
            BasicStroke basicStroke = new BasicStroke(8.0f, 0, 2, 0.0f, new float[]{12.0f, 12.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
        }
        if (this.fragmentShapes[n] != null) {
            if (this.highlightColors[n] == null) {
                graphics2D.setColor(highlightColor);
            } else {
                graphics2D.setColor(this.highlightColors[n]);
            }
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.fill(this.fragmentShapes[n]);
            graphics2D.draw(this.outlineZone[n]);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.9f));
            graphics2D.draw(this.outlineZone[n]);
            int n3 = this.outlineZone[n].getBounds().x;
            n2 = this.outlineZone[n].getBounds().y;
            graphics2D.drawLine(n3, n2 + (int)this.outlineZone[n].getBounds().getHeight(), n3 + (int)this.outlineZone[n].getBounds().getWidth(), n2);
            if (this.processedByRegularExpression[n] > 0) {
                graphics2D.drawLine(n3 + (int)this.outlineZone[n].getBounds().getWidth(), n2 + (int)this.outlineZone[n].getBounds().getHeight(), n3, n2);
            }
        }
        if (bl) {
            int n4 = this.outlineZone[n].getBounds().x;
            n2 = this.outlineZone[n].getBounds().y;
            n4 = n4 + (int)this.outlineZone[n].getBounds().getWidth() / 2 - 12;
            graphics2D.setColor(Color.yellow);
            graphics2D.fillOval(n4, n2 += (int)this.outlineZone[n].getBounds().getHeight() / 2, 50, 50);
            graphics2D.setColor(Color.black);
            graphics2D.fillOval(n4 + 27, n2 + 30, 8, 8);
            graphics2D.fillOval(n4 + 15, n2 + 30, 8, 8);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.drawOval(n4, n2, 50, 50);
            graphics2D.drawArc(n4 + 12, n2 + 5, 26, 15, 170, 200);
        }
        graphics2D.setStroke(stroke);
    }

    private void numberItems(boolean bl, Graphics2D graphics2D, String string, int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 == -1) {
                i = n;
                continue;
            }
            String string2 = string + n2;
            if (this.linkedItems == null) {
                if (this.fragmentShapes[n3] != null) {
                    this.numberItem(graphics2D, n3, string2);
                }
                ++n2;
                continue;
            }
            int[] nArray2 = (int[])this.linkedItems[n3];
            if (nArray2 != null) {
                ++n2;
                int n4 = nArray2.length;
                int n5 = 0;
                for (int j = 0; j < n4; ++j) {
                    int n6 = nArray2[j];
                    ++n5;
                    if (n6 == -1) {
                        j = n4;
                        continue;
                    }
                    if (this.fragmentShapes[n3] == null) continue;
                    this.numberItem(graphics2D, n6, string2 + '.' + n5);
                }
                continue;
            }
            if (this.parents[n3] != -1) continue;
            if (this.fragmentShapes[n3] != null) {
                this.numberItem(graphics2D, n3, string2);
            }
            ++n2;
        }
    }

    private void drawRelationships(boolean bl, Graphics2D graphics2D, String string, int[] nArray) {
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == -1) {
                i = n;
                continue;
            }
            if (this.children == null) continue;
            int[] nArray2 = (int[])this.children[n2];
            if (nArray2 != null) {
                int n3 = nArray2.length;
                int n4 = 0;
                for (int j = 0; j < n3; ++j) {
                    int n5 = nArray2[j];
                    ++n4;
                    if (n5 == -1) {
                        j = n3;
                        continue;
                    }
                    if (this.fragmentShapes[n5] == null) continue;
                    Stroke stroke = graphics2D.getStroke();
                    BasicStroke basicStroke = new BasicStroke(5.0f);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.setColor(highlightColor);
                    if (n2 != n5) {
                        graphics2D.drawLine(this.cx[n2], this.cy[n2], this.cx[n5], this.cy[n5]);
                        graphics2D.fillOval(this.cx[n5] - 15, this.cy[n5] - 15, 30, 30);
                        graphics2D.setColor(Color.red);
                        graphics2D.fillOval(this.cx[n2] - 20, this.cy[n2] - 20, 40, 40);
                    }
                    graphics2D.setStroke(stroke);
                    this.highlightedZonesSelected[n5] = true;
                    if (this.linkedItems[n5] != null) {
                        int[] nArray3 = (int[])this.linkedItems[n5];
                        for (int k = 0; k != nArray3.length; ++k) {
                            if (nArray3[k] == -1) continue;
                            this.highlightStoryOnscreen(graphics2D, nArray3[k], this.hasDrownedObjects[k]);
                            this.highlightedZonesSelected[nArray3[k]] = true;
                            this.numberItems(false, graphics2D, "", nArray2);
                        }
                        continue;
                    }
                    this.numberItems(false, graphics2D, "", nArray2);
                    this.highlightStoryOnscreen(graphics2D, n5, this.hasDrownedObjects[n5]);
                }
                continue;
            }
            this.numberItems(false, graphics2D, "", nArray);
        }
    }

    private void numberItem(Graphics2D graphics2D, int n, String string) {
        AffineTransform affineTransform = new AffineTransform();
        GlyphVector glyphVector = this.highlightFont.createGlyphVector(graphics2D.getFontRenderContext(), string);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(this.cx[n], -this.cy[n]);
        Area area = new Area(glyphVector.getOutline());
        area.transform(affineTransform);
        graphics2D.setColor(Color.black);
        graphics2D.fill(area.getBounds());
        graphics2D.setColor(Color.white);
        graphics2D.fill(area);
    }

    public final int getPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size + this.insetW + this.insetW;
        }
        return this.x_size + this.insetW + this.insetW;
    }

    public final int getRawPDFWidth() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.y_size;
        }
        return this.x_size;
    }

    public void setMessageFrame(Container container) {
        this.currentDisplay.setMessageFrame(container);
    }

    public final int getPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size + this.insetH + this.insetH;
        }
        return this.y_size + this.insetH + this.insetH;
    }

    public final int getRawPDFHeight() {
        if (this.displayRotation == 90 | this.displayRotation == 270) {
            return this.x_size;
        }
        return this.y_size;
    }

    public void disableBorderForPrinting() {
        this.useBorder = false;
    }

    public final void setPDFBorder(Border border) {
        this.myBorder = border;
        this.useBorder = true;
    }

    protected final AffineTransform getScalingForImage(int n, int n2, float f) {
        double d = (float)this.pageData.getMediaBoxX(n) * f;
        double d2 = (float)this.pageData.getMediaBoxY(n) * f;
        double d3 = (float)this.pageData.getMediaBoxHeight(n) * f;
        double d4 = (float)this.pageData.getCropBoxWidth(n) * f;
        double d5 = (float)this.pageData.getCropBoxHeight(n) * f;
        double d6 = (float)this.pageData.getCropBoxX(n) * f;
        double d7 = (float)this.pageData.getCropBoxY(n) * f;
        AffineTransform affineTransform = new AffineTransform();
        int n3 = (int)(d4 + (d6 - d));
        int n4 = (int)(d5 + (d7 - d2));
        if (n2 == 270) {
            affineTransform.rotate(-1.5707963267948966, n3 / 2, n4 / 2);
            double d8 = affineTransform.getTranslateX();
            double d9 = affineTransform.getTranslateY();
            affineTransform.translate((double)n4 - d9, -d8);
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(-(d6 + d), -(d3 - d5 - (d7 - d2)));
        } else if (n2 == 180) {
            affineTransform.rotate(Math.PI, n3 / 2, n4 / 2);
            affineTransform.translate(-(d6 + d), (double)n4 + (d7 + d2) - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else if (n2 == 90) {
            affineTransform.rotate(1.5707963267948966);
            affineTransform.translate(0.0, d7 + d2 - (d3 - d5 - (d7 - d2)));
            affineTransform.scale(1.0, -1.0);
        } else {
            affineTransform.translate(0.0, n4);
            affineTransform.scale(1.0, -1.0);
            affineTransform.translate(0.0, -(d3 - d5 - (d7 - d2)));
        }
        affineTransform.scale(f, f);
        return affineTransform;
    }

    public final void setPageRotation(int n) {
        this.displayRotation = n;
        if (this.displayView != 1) {
            n = 0;
        }
        this.pageUsedForTransform = this.pageNumber;
        this.displayScaling = this.displayView != 1 ? this.getScalingForImage(1, 0, this.scaling) : this.getScalingForImage(this.pageNumber, n, this.scaling);
        if (n == 90) {
            this.displayScaling.translate((float)this.insetH / this.scaling, (float)this.insetW / this.scaling);
        } else if (n == 270) {
            this.displayScaling.translate((float)(-this.insetH) / this.scaling, (float)(-this.insetW) / this.scaling);
        } else if (n == 180) {
            this.displayScaling.translate((float)(-this.insetW) / this.scaling, (float)this.insetH / this.scaling);
        } else {
            this.displayScaling.translate((float)this.insetW / this.scaling, (float)(-this.insetH) / this.scaling);
        }
        this.pages.refreshDisplay();
        if (this.viewableArea != null) {
            this.viewScaling = new AffineTransform();
            double d = (double)this.viewableArea.width / (double)this.pageData.getCropBoxWidth(this.pageNumber);
            double d2 = (double)this.viewableArea.height / (double)this.pageData.getCropBoxHeight(this.pageNumber);
            double d3 = d;
            if (d2 < d) {
                d3 = d2;
            }
            double d4 = this.viewableArea.x;
            double d5 = (double)this.viewableArea.y + ((double)this.viewableArea.height - (double)this.pageData.getCropBoxHeight(this.pageNumber) * d3);
            this.viewScaling.translate(d4, d5);
            this.viewScaling.scale(d3, d3);
        } else {
            this.viewScaling = null;
        }
    }

    public void setHardwareAccelerationforScreen(boolean bl) {
        this.useAcceleration = bl;
    }

    public int getScrollInterval() {
        return this.scrollInterval;
    }

    public void setScrollInterval(int n) {
        this.scrollInterval = n;
    }

    public void setDrawInteractively(boolean bl) {
        this.drawInteractively = bl;
    }

    public int getDisplayView() {
        return this.displayView;
    }

    public int getPrintPageScalingMode() {
        return this.pageScalingMode;
    }

    public void setPrintPageScalingMode(int n) {
        this.pageScalingMode = n;
    }

    public void setUsePDFPaperSize(boolean bl) {
        this.usePDFPaperSize = bl;
    }

    public void setHighlightedImage(int[] nArray) {
        this.highlightedImage = nArray;
    }

    public int[] getHighlightImage() {
        return this.highlightedImage;
    }

    public boolean isImageExtractionAllowed() {
        return this.ImageExtractionAllowed;
    }

    public void setImageExtractionAllowed(boolean bl) {
        this.ImageExtractionAllowed = bl;
    }

    public float getScaling() {
        return this.scaling;
    }

    public int getInsetH() {
        return this.insetH;
    }

    public int getInsetW() {
        return this.insetW;
    }

    protected void setDisplayForms(boolean bl) {
        this.displayForms = bl;
    }

    public Rectangle getCursorBoxOnScreen() {
        return this.cursorBoxOnScreen;
    }

    public boolean isExtractingAsImage() {
        return this.extractingAsImage;
    }

    public Rectangle getCurrentPageCoords() {
        if (this.pages != null) {
            return this.pages.getCurrentPageCoords();
        }
        return null;
    }

    public JScrollBar getPageFlowBar() {
        return this.scroll;
    }

    public void addToLineAreas(Rectangle rectangle, int n, int n2) {
        boolean bl = true;
        if (this.lineAreas == null) {
            this.lineAreas = new HashMap();
            this.lineAreas.put(new Integer(n2), new Rectangle[]{rectangle});
            this.lineWritingMode = new HashMap();
            this.lineWritingMode.put(new Integer(n2), new int[]{n});
        } else {
            Rectangle[] rectangleArray = (Rectangle[])this.lineAreas.get(new Integer(n2));
            int[] nArray = (int[])this.lineWritingMode.get(new Integer(n2));
            if (rectangle != null) {
                int n3;
                int n4;
                for (int i = 0; i != rectangleArray.length; ++i) {
                    n4 = rectangleArray[i].x;
                    n3 = rectangleArray[i].y;
                    int n5 = rectangleArray[i].width;
                    int n6 = rectangleArray[i].height;
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    int n9 = rectangle.width;
                    int n10 = rectangle.height;
                    int n11 = nArray[i];
                    int n12 = n;
                    if (n != 0) {
                        switch (n) {
                            case 1: {
                                n4 = rectangleArray[i].x;
                                n3 = rectangleArray[i].y;
                                n5 = rectangleArray[i].width;
                                n6 = rectangleArray[i].height;
                                n7 = rectangle.x;
                                n8 = rectangle.y;
                                n9 = rectangle.width;
                                n10 = rectangle.height;
                                break;
                            }
                            case 2: {
                                n4 = rectangleArray[i].y;
                                n3 = rectangleArray[i].x;
                                n5 = rectangleArray[i].height;
                                n6 = rectangleArray[i].width;
                                n7 = rectangle.y;
                                n8 = rectangle.x;
                                n9 = rectangle.height;
                                n10 = rectangle.width;
                                break;
                            }
                            case 3: {
                                n4 = rectangleArray[i].y;
                                n3 = rectangleArray[i].x;
                                n5 = rectangleArray[i].height;
                                n6 = rectangleArray[i].width;
                                n7 = rectangle.y;
                                n8 = rectangle.x;
                                n9 = rectangle.height;
                                n10 = rectangle.width;
                                break;
                            }
                        }
                    }
                    if (n11 != n12 || n3 <= n8 - 5 || n3 >= n8 + 5 || n6 > n10 + n10 / 5 || n6 < n10 - n10 / 5 || !(n4 > n7 + n9 - 5 && n4 < n7 + n9 + 5 || n4 + n5 > n7 - 5 && n4 + n5 < n7 + 5) && !rectangleArray[i].intersects(rectangle)) continue;
                    bl = false;
                    rectangleArray[i] = PdfPanel.mergePartLines(rectangleArray[i], rectangle);
                }
                if (bl) {
                    Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length + 1];
                    for (n4 = 0; n4 != rectangleArray.length; ++n4) {
                        rectangleArray2[n4] = rectangleArray[n4];
                    }
                    rectangleArray2[rectangleArray2.length - 1] = rectangle;
                    int[] nArray2 = new int[nArray.length + 1];
                    for (n3 = 0; n3 != rectangleArray.length; ++n3) {
                        nArray2[n3] = nArray[n3];
                    }
                    nArray2[nArray2.length - 1] = n;
                    this.lineAreas.put(new Integer(n2), rectangleArray2);
                    this.lineWritingMode.put(new Integer(n2), nArray2);
                }
            }
        }
    }

    private static Rectangle mergePartLines(Rectangle rectangle, Rectangle rectangle2) {
        int n = rectangle2.x;
        int n2 = rectangle2.x + rectangle2.width;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        int n5 = rectangle.x;
        int n6 = rectangle.x + rectangle.width;
        int n7 = rectangle.y;
        int n8 = rectangle.y + rectangle.height;
        rectangle2.x = n < n5 ? n : n5;
        rectangle2.y = n3 < n7 ? n3 : n7;
        rectangle2.height = n4 > n8 ? n4 - rectangle2.y : n8 - rectangle2.y;
        rectangle2.width = n2 > n6 ? n2 - rectangle2.x : n6 - rectangle2.x;
        return rectangle2;
    }

    public int[] getLineWritingMode(int n) {
        if (this.lineWritingMode == null) {
            return null;
        }
        int[] nArray = (int[])this.lineWritingMode.get(new Integer(n));
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void setLineWritingMode(Map map) {
        this.lineWritingMode = map;
    }

    public Rectangle[] getLineAreas(int n) {
        if (this.lineAreas == null) {
            return null;
        }
        Rectangle[] rectangleArray = (Rectangle[])this.lineAreas.get(new Integer(n));
        if (rectangleArray == null) {
            return null;
        }
        int n2 = rectangleArray.length;
        Rectangle[] rectangleArray2 = new Rectangle[n2];
        for (int i = 0; i < n2; ++i) {
            rectangleArray2[i] = rectangleArray[i] == null ? null : new Rectangle(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
        }
        return rectangleArray2;
    }

    public void setLineAreas(Map map) {
        this.lineAreas = map;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this.addAView(-1, rectangle, null);
        super.scrollRectToVisible(rectangle);
    }

    protected class ViewStack {
        private ArrayList ourStack = new ArrayList();
        private int index = -1;
        private int length = 0;

        protected ViewStack() {
        }

        protected Viewable back() {
            if (this.index - 1 > -1 && this.index - 1 < this.length) {
                --this.index;
                return (Viewable)this.ourStack.get(this.index);
            }
            return null;
        }

        protected Viewable forward() {
            if (this.index + 1 > -1 && this.index + 1 < this.length) {
                ++this.index;
                return (Viewable)this.ourStack.get(this.index);
            }
            return null;
        }

        protected synchronized void add(int n, Rectangle rectangle, Integer n2) {
            this.ourStack.ensureCapacity(this.index + 2);
            this.ourStack.add(this.index + 1, new Viewable(n, rectangle, n2));
            ++this.index;
            this.length = this.index + 1;
        }

        protected class Viewable {
            private int page;
            private Rectangle location;
            private Integer type;

            protected Viewable(int n, Rectangle rectangle, Integer n2) {
                this.page = n;
                this.location = rectangle;
                this.type = n2;
            }

            protected Rectangle getLocation() {
                return this.location;
            }

            protected int getPage() {
                return this.page;
            }

            protected Integer getType() {
                return this.type;
            }
        }
    }
}

