/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.color.RotatedTexturePaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PatternObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public class PatternColorSpace
extends GenericColorSpace {
    private Map cachedPaints = new HashMap();
    private Map colorspacesObjects;
    PdfObjectReader currentPdfFile = null;
    private boolean isPrinting = false;
    private boolean colorsReversed;

    public PatternColorSpace(boolean bl, PdfObjectReader pdfObjectReader, Map map) {
        this.value = 1146450818;
        this.isPrinting = bl;
        this.colorspacesObjects = map;
        this.currentPdfFile = pdfObjectReader;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
    }

    public void setColor(String[] stringArray, int n) {
        PatternObject patternObject = (PatternObject)this.patterns.get(stringArray[0]);
        String string = patternObject.getObjectRefAsString();
        if (string != null && this.cachedPaints.containsKey(string)) {
            this.currentColor = (PdfPaint)this.cachedPaints.get(string);
            return;
        }
        this.currentPdfFile.checkResolved(patternObject);
        byte[] byArray = this.currentPdfFile.readStream(patternObject, true, true, true, false, false, null);
        int n2 = patternObject.getInt(1755231159);
        Object object = null;
        float[] fArray = patternObject.getFloatArray(1145198201);
        if (fArray != null) {
            if (n2 == 1) {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                if (fArray[5] < 0.0f) {
                    fArray[4] = 0.0f;
                    fArray[5] = 0.0f;
                }
                object = fArrayArray;
            } else {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                this.colorsReversed = fArrayArray[2][0] < 0.0f;
                object = Matrix.multiply(fArrayArray, this.CTM);
            }
        }
        if (n2 == 1) {
            this.currentColor = this.setupTiling(patternObject, fArray, (float[][])object, byArray);
        } else if (n2 == 2) {
            this.currentColor = this.setupShading(patternObject, (float[][])object);
        }
    }

    private PdfPaint setupTiling(PdfObject pdfObject, float[] fArray, float[][] fArray2, byte[] byArray) {
        int n;
        int n2;
        this.inputs = fArray;
        PdfPaint pdfPaint = null;
        boolean bl = true;
        BufferedImage bufferedImage = null;
        AffineTransform affineTransform = null;
        float[][] fArray3 = null;
        if (fArray2 != null) {
            fArray3 = new float[3][3];
            for (n2 = 0; n2 < 3; ++n2) {
                for (n = 0; n < 3; ++n) {
                    fArray3[n][n2] = fArray2[n][n2];
                }
            }
        }
        if (fArray2 != null && fArray2[0][0] != 0.0f && (double)fArray2[0][1] < 0.001 && (double)fArray2[0][1] > -0.001) {
            fArray2[0][1] = 0.0f;
        }
        if (fArray2 != null && fArray2[1][1] != 0.0f && (double)fArray2[1][0] < 0.001 && (double)fArray2[1][0] > -0.001) {
            fArray2[1][0] = 0.0f;
        }
        if (fArray != null) {
            for (n2 = 0; n2 < 6; ++n2) {
                if (fArray[n2] == 0.0f || !((double)fArray[n2] < 0.001) || !((double)fArray[n2] > -0.001)) continue;
                fArray[n2] = 0.0f;
            }
        }
        if (fArray2 != null && fArray2[0][0] < 0.0f && fArray2[1][1] < 0.0f) {
            fArray2[0][0] = -fArray2[0][0];
            fArray2[1][1] = -fArray2[1][1];
            if (fArray != null) {
                fArray[0] = -fArray[0];
                fArray[3] = -fArray[3];
            }
        }
        n2 = 0;
        n = 0;
        boolean bl2 = false;
        if (fArray2 != null) {
            int n3 = n2 = fArray2[1][0] != 0.0f && fArray2[0][1] != 0.0f && fArray2[0][0] != 0.0f && fArray2[1][1] != 0.0f ? 1 : 0;
            if (n2 != 0 && fArray2[0][0] != 0.0f && (double)fArray2[0][0] < 0.001 && fArray2[1][1] != 0.0f && (double)fArray2[1][1] < 0.001) {
                n2 = 0;
                fArray2[0][0] = -fArray2[0][1];
                fArray2[1][1] = -fArray2[1][0];
                fArray2[1][0] = 0.0f;
                fArray2[0][1] = 0.0f;
            }
            if ((n2 == 0 || !(fArray2[0][0] > 0.0f) || !(fArray2[0][1] < 0.0f) || !(fArray2[1][0] > 0.0f) || !(fArray2[1][1] > 0.0f)) && n2 != 0 && fArray2[0][0] < 0.0f && fArray2[0][1] < 0.0f && fArray2[1][0] < 0.0f && fArray2[1][1] > 0.0f) {
                fArray2[0][0] = -fArray2[0][0];
                fArray2[1][0] = -fArray2[1][0];
                bl2 = true;
            }
            int n4 = n = fArray2[1][1] < 0.0f || fArray2[0][1] < 0.0f ? 1 : 0;
            if (fArray2[0][0] > 0.0f && fArray2[0][1] < 0.0f && fArray2[1][0] > 0.0f && fArray2[1][1] > 0.0f) {
                n = 0;
            }
            if (fArray2[0][0] > 0.1f && (n2 != 0 || n != 0)) {
                bl = false;
            }
            if (n != 0 && fArray2[0][1] > 0.0f && fArray2[1][0] > 0.0f) {
                n = 0;
            }
        }
        int n5 = (int)pdfObject.getFloatNumber(591672680);
        int n6 = (int)pdfObject.getFloatNumber(591672681);
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n6 < 0) {
            n6 = -n6;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        int n7 = 0;
        int n8 = 0;
        if (fArray2 != null) {
            if (fArray2[1][1] < 0.0f) {
                fArray2[2][1] = n6;
            }
            if ((double)fArray2[1][0] != 0.0) {
                fArray2[2][1] = -fArray2[1][0];
            }
        }
        ObjectStore objectStore = new ObjectStore();
        DynamicVectorRenderer dynamicVectorRenderer = this.decodePatternContent(pdfObject, fArray2, byArray, objectStore);
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl3 = false;
        if (fArray2 != null) {
            f3 = fArray2[0][0];
            if (f3 == 0.0f) {
                f3 = fArray2[0][1];
            }
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if ((f4 = fArray2[1][1]) == 0.0f) {
                f4 = fArray2[1][0];
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
        }
        if (fArray2 != null) {
            if (fArray != null && fArray[0] > 1.0f && fArray[3] > 1.0f && n2 == 0) {
                bufferedImage = new BufferedImage((int)((float)n5 * f3), (int)((float)n6 * f4), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setClip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                dynamicVectorRenderer.paint(graphics2D, null, new AffineTransform(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray[4], -fArray[5] / 2.0f), null, false, false);
            } else {
                BufferedImage bufferedImage2 = null;
                f = fArray2[0][0];
                f2 = fArray2[1][1];
                if (f == 0.0f) {
                    f = fArray2[0][1];
                }
                if (f < 0.0f) {
                    f = -f;
                }
                if (f2 == 0.0f) {
                    f2 = fArray2[1][0];
                }
                if (f2 < 0.0f) {
                    f2 = -f2;
                }
                f *= (float)n5;
                f2 *= (float)n6;
                int n9 = n5;
                int n10 = n6;
                if (n2 == 0) {
                    int n11;
                    int n12;
                    int n13;
                    if (n != 0) {
                        int n14 = (int)((float)n5 / f);
                        int n15 = (int)((float)n6 / f2);
                        if (n14 > 0 && n15 > 0) {
                            n9 = (int)((float)(n14 + 1) * f);
                            n10 = (int)((float)(n15 + 1) * f2);
                            n5 = n9;
                            n6 = n10;
                        }
                    } else if (fArray != null && fArray[0] > 0.0f && fArray[0] < 1.0f && fArray[3] > 0.0f && fArray[3] < 1.0f) {
                        n9 = (int)f;
                        n10 = (int)f2;
                        if (n10 == 0) {
                            n10 = 1;
                        }
                        if ((n7 = (int)fArray[4]) > n5) {
                            while (n7 > 0 && (n7 -= n5) != 0) {
                            }
                            n7 /= 2;
                        }
                        if ((n8 = (int)fArray[5]) > n10) {
                            while (n8 > 0) {
                                n8 -= n10;
                            }
                        }
                    }
                    if (bl3) {
                        bufferedImage = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                        affineTransform = AffineTransform.getScaleInstance((float)n5 / f3, (float)n6 / f4);
                    } else {
                        bufferedImage = new BufferedImage(n9, n10, 2);
                    }
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    AffineTransform affineTransform2 = graphics2D.getTransform();
                    graphics2D.setClip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                    int n16 = 0;
                    Rectangle rectangle = dynamicVectorRenderer.getOccupiedArea().getBounds();
                    int n17 = 0;
                    int n18 = 0;
                    if (rectangle.x < 0) {
                        n13 = rectangle.width - rectangle.x;
                        n17 = rectangle.x;
                    } else {
                        n13 = rectangle.width + rectangle.x;
                    }
                    if (rectangle.y < 0) {
                        n12 = rectangle.height - rectangle.y;
                        n18 = rectangle.y;
                    } else {
                        n12 = rectangle.height + rectangle.y;
                    }
                    if (n12 == 0) {
                        n12 = 1;
                    }
                    if (bl) {
                        bufferedImage2 = new BufferedImage(n13, n12, 2);
                        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
                        graphics2D2.translate(-n17, -n18);
                        dynamicVectorRenderer.paint(graphics2D2, null, null, null, false, false);
                    }
                    if ((n11 = rectangle.x) < 0 && !bl) {
                        n16 = (int)((float)(-n11) * fArray2[0][0]);
                    }
                    float f5 = n6;
                    if (bl) {
                        f5 = n6 + bufferedImage2.getHeight() * 2;
                    }
                    for (float f6 = 0.0f; f6 < f5; f6 += f2) {
                        for (float f7 = (float)n16; f7 < (float)n5; f7 += f) {
                            if (n != 0) {
                                graphics2D.translate(f7, -f6);
                            } else {
                                graphics2D.translate(f7, f6);
                            }
                            if (bl) {
                                AffineTransform affineTransform3 = new AffineTransform();
                                ColorSpaceConvertor.drawImage(graphics2D, bufferedImage2, affineTransform3, null);
                            } else {
                                dynamicVectorRenderer.paint(graphics2D, null, affineTransform, null, false, false);
                            }
                            graphics2D.setTransform(affineTransform2);
                        }
                    }
                }
            }
        } else {
            if (bl3) {
                bufferedImage = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                affineTransform = AffineTransform.getScaleInstance((float)n5 / f3, (float)n6 / f4);
            } else {
                bufferedImage = new BufferedImage(n5, n6, 2);
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            dynamicVectorRenderer.paint(graphics2D, null, null, null, false, false);
            if (n != 0 && bufferedImage.getHeight() > 1) {
                AffineTransform affineTransform4 = new AffineTransform();
                affineTransform4.translate(0.0, bufferedImage.getHeight());
                affineTransform4.scale(1.0, -1.0);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform4, ColorSpaces.hints);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        objectStore.flush();
        if (bufferedImage != null) {
            pdfPaint = new PdfTexturePaint(bufferedImage, new Rectangle(n7, n8, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        if (n2 != 0) {
            pdfPaint = new RotatedTexturePaint(bl2, fArray3, pdfObject, bl, dynamicVectorRenderer, fArray2, n5, n6, f, f2, affineTransform);
        }
        if (pdfPaint != null) {
            this.cachedPaints.put(pdfObject.getObjectRefAsString(), pdfPaint);
        }
        return pdfPaint;
    }

    private DynamicVectorRenderer decodePatternContent(PdfObject pdfObject, float[][] fArray, byte[] byArray, ObjectStore objectStore) {
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.colorspacesObjects);
        pdfStreamDecoder.setStreamType(1);
        pdfStreamDecoder.setStore(objectStore);
        DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(0, false, 20, objectStore);
        dynamicVectorRenderer.setOptimisedRotation(false);
        try {
            pdfStreamDecoder.init(false, true, 7, 0, new PdfPageData(), 0, dynamicVectorRenderer, this.currentPdfFile);
            if (pdfObject2 != null) {
                this.currentPdfFile.checkResolved(pdfObject2);
                pdfStreamDecoder.readResources(pdfObject2, true);
            }
            pdfStreamDecoder.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
            GraphicsState graphicsState = new GraphicsState(0, 0);
            if (fArray != null) {
                graphicsState.CTM = fArray;
            }
            pdfStreamDecoder.decodePageContent(null, 0, 0, graphicsState, byArray);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        pdfStreamDecoder = null;
        return dynamicVectorRenderer;
    }

    private PdfPaint setupShading(PdfObject pdfObject, float[][] fArray) {
        PdfObject pdfObject2 = pdfObject.getDictionary(878474856);
        PdfObject pdfObject3 = pdfObject2.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = ColorspaceFactory.getColorSpaceInstance(false, this.currentPdfFile, pdfObject3, this.colorspacesObjects, null, false);
        if (genericColorSpace.getID() == 1247168582 && pdfObject3.getParameterConstant(2054519176) == 1498837125) {
            genericColorSpace = new DeviceCMYKColorSpace();
        }
        if (pdfObject2 == null) {
            return null;
        }
        return null;
    }
}

