/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.popups;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.CheckNode;
import org.jpedal.examples.simpleviewer.gui.CheckRenderer;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    Map reverseMessage = new HashMap();
    String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    String propertiesLocation = "";
    PropertiesFile properties = null;
    JFrame jf = new JFrame("JPedal PDF Preferences");
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTabbedPane tabs = new JTabbedPane();
    JTextField dpi_Input;
    JComboBox searchStyle;
    JCheckBox border;
    JCheckBox downloadWindow;
    JCheckBox HiResPrint;
    JCheckBox constantTabs;
    JCheckBox enhancedViewer;
    JCheckBox enhancedFacing;
    JCheckBox enhancedGUI;
    JCheckBox rightClick;
    JCheckBox scrollwheelZoom;
    JCheckBox update = new JCheckBox("Check for updates on startup");
    JTextField maxMultiViewers;
    JTextField pageInsets;
    JLabel pageInsetsText;
    JTextField windowTitle;
    JLabel windowTitleText;
    JTextField iconLocation;
    JLabel iconLocationText;
    JTextField pageFlowPages;
    JLabel pageFlowPagesText;
    JTextField sideTabLength;
    JLabel sideTabLengthText;
    JTextField pageFlowCache;
    JLabel pageFlowCacheText;
    JTextField pageFlowReflectionHeight;
    JLabel pageFlowReflectionHeightText;
    JTextField pageFlowSideSize;
    JLabel pageFlowSideSizeText;
    JCheckBox pageFlowReflection = new JCheckBox("Show PageFlow reflection");
    JCheckBox useHinting;
    JCheckBox autoScroll;
    JCheckBox confirmClose;
    JCheckBox openLastDoc;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing", "PageFlow"});
    JPanel highlightBoxColor = new JPanel();
    JPanel highlightTextColor = new JPanel();
    JCheckBox invertHighlight = new JCheckBox("Highlight Inverts Page");
    JTextField highlightComposite = new JTextField(String.valueOf(PdfDecoder.highlightComposite));
    private Component parent;
    private boolean preferencesSetup = false;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    KeyListener numericalKeyListener = new KeyListener(){
        boolean consume = false;

        public void keyPressed(KeyEvent keyEvent) {
            this.consume = false;
            if (!(keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                this.consume = true;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.consume) {
                keyEvent.consume();
            }
        }
    };

    public void showPreferenceWindow(SwingGUI swingGUI) {
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(swingGUI);
        }
        if (this.properties.getValue("readOnly").toLowerCase().equals("true")) {
            JOptionPane.showMessageDialog(this, "You do not have permission alter jPedal properties.\nAccess to the properties window has therefore been disabled.", "Can not write to properties file", 1);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, "Current properties file is read only.\nAny alteration can only be saved as another properties file.", "Properties file is read only", 1);
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        this.jf.setLocationRelativeTo(this.parent);
        this.jf.setVisible(true);
    }

    private void saveGUIPreferences(SwingGUI swingGUI) {
        Component[] componentArray = this.tabs.getComponents();
        for (int i = 0; i != componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JPanel)) continue;
            Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
            for (int j = 0; j != componentArray2.length; ++j) {
                Object object;
                if (componentArray2[j] instanceof JScrollPane) {
                    object = ((JScrollPane)componentArray2[j]).getComponents();
                    for (int k = 0; k != ((Component[])object).length; ++k) {
                        if (!(object[k] instanceof JViewport)) continue;
                        Component[] componentArray3 = ((JViewport)object[k]).getComponents();
                        for (int i2 = 0; i2 != componentArray3.length; ++i2) {
                            JTree jTree;
                            CheckNode checkNode;
                            if (!(componentArray3[i2] instanceof JTree) || (checkNode = (CheckNode)(jTree = (JTree)componentArray3[i2]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(checkNode, swingGUI);
                        }
                    }
                }
                if (!(componentArray2[j] instanceof JButton)) continue;
                object = (JButton)componentArray2[j];
                String string = (String)this.reverseMessage.get(((AbstractButton)object).getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + " ").length()));
                if (((AbstractButton)object).getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + " ")) {
                    this.properties.setValue(string, "true");
                    swingGUI.alterProperty(string, true);
                    continue;
                }
                this.properties.setValue(string, "false");
                swingGUI.alterProperty(string, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode checkNode, SwingGUI swingGUI) {
        for (int i = 0; i != checkNode.getChildCount(); ++i) {
            CheckNode checkNode2 = (CheckNode)checkNode.getChildAt(i);
            String string = (String)this.reverseMessage.get(checkNode2.getText());
            if (checkNode2.isSelected()) {
                this.properties.setValue(string, "true");
                swingGUI.alterProperty(string, true);
            } else {
                this.properties.setValue(string, "false");
                swingGUI.alterProperty(string, false);
            }
            if (checkNode2.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(checkNode2, swingGUI);
        }
    }

    private void createPreferenceWindow(final SwingGUI swingGUI) {
        this.properties = swingGUI.getProperties();
        this.propertiesLocation = swingGUI.getPropertiesFileLocation();
        this.update.setToolTipText("Allow SimpleViewer to automatically check for updates");
        this.invertHighlight.setToolTipText("Set highlights to invert colours within the highlight area");
        this.highlightBoxColor.setToolTipText("Set the colour of the highlight area");
        this.highlightTextColor.setToolTipText("Set the colour of the text within the highlight area");
        String string = this.properties.getValue("DPI");
        this.dpi_Input = string.length() > 0 ? new JTextField(string) : new JTextField(PdfDecoder.dpi);
        this.dpi_Input.setToolTipText("Set the dpi value the page will be displayed at");
        string = this.properties.getValue("maxmultiviewers");
        this.maxMultiViewers = string.length() > 0 ? new JTextField(string) : new JTextField(20);
        this.maxMultiViewers.setToolTipText("Set the maximum amount of views availible in the multiviewer");
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.searchStyle.setToolTipText("Set how the search interface should be displayed");
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText("Set the starting view and keep it as default");
        this.pageInsetsText = new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText("Set the inset of the page on screen");
        this.windowTitleText = new JLabel(Messages.getMessage("PdfCustomGui.windowTitle"));
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText("Set a custom window title");
        this.iconLocationText = new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation"));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText("Set the location of a set of custom buttons");
        this.pageFlowCacheText = new JLabel(Messages.getMessage("PdfCustomGui.PageFlowCache"));
        this.pageFlowCache = new JTextField();
        this.pageFlowCache.setToolTipText("Set how many pages should be kept cached");
        this.sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText("Set the default starting length on the side tab");
        this.pageFlowPagesText = new JLabel(Messages.getMessage("PdfCustomGui.PageFlowPages"));
        this.pageFlowPages = new JTextField();
        this.pageFlowPages.setToolTipText("Set the amount of pages to display on either side of current page");
        this.pageFlowReflectionHeightText = new JLabel(Messages.getMessage("PdfCustomGui.PageFlowReflectionHeight"));
        this.pageFlowReflectionHeight = new JTextField();
        this.pageFlowReflectionHeight.setToolTipText("Set how far down the reflections should stretch");
        this.pageFlowSideSizeText = new JLabel(Messages.getMessage("PdfCustomGui.PageFlowSideSize"));
        this.pageFlowSideSize = new JTextField();
        this.pageFlowSideSize.setToolTipText("Set the side page size");
        this.pageFlowReflection = new JCheckBox(Messages.getMessage("PdfCustomGui.PageFlowReflection"));
        this.pageFlowReflection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.pageFlowReflectionHeightText.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
                SwingProperties.this.pageFlowReflectionHeight.setEnabled(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        this.pageFlowReflection.setToolTipText("Show the reflections below side scroll page");
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingProperties.this.useHinting.isSelected()) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfCustomGui.patentedHintingMessage"));
                }
            }
        });
        this.pageFlowReflection.setToolTipText("Use the patented hinting methods to enable certain foreign fonts");
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText("Set if autoscroll should be enabled / disabled");
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText("Set if we should confirm closing the viewer");
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText("Set if last document should be opened upon start up");
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText("Set if we should display a border for the page");
        this.downloadWindow = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.DownloadWindow_Show"));
        this.downloadWindow.setToolTipText("Set if the download window should be displayed");
        this.HiResPrint = new JCheckBox(Messages.getMessage("Printing.HiRes"));
        this.HiResPrint.setToolTipText("Set if hi res printing should be enabled / disabled");
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText("Set to keep sidetabs consistant between files");
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText("Set to use enahnced viewer mode");
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText("Set to turn facing mode to page turn mode");
        this.enhancedGUI = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedGUI"));
        this.enhancedGUI.setToolTipText("Set to enabled the enhanced gui");
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText("Set to enable / disable the right click functionality");
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText("Set to enable zooming when scrolling with ctrl pressed");
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText("Clears the history of previous files");
        this.clearHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                swingGUI.clearRecentDocuments();
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        for (int i = 0; i < 6; ++i) {
                            SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                };
                swingWorker.start();
            }
        });
        JButton jButton = new JButton("Save As");
        jButton.setToolTipText("Save preferences in a new file");
        JButton jButton2 = new JButton("Reset to Default");
        jButton2.setToolTipText("Reset  and save preferences to program defaults");
        this.jf.getContentPane().setLayout(new BorderLayout());
        this.jf.getContentPane().add((Component)this, "Center");
        this.jf.pack();
        this.jf.setSize(550, 450);
        this.confirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.setPreferences(swingGUI);
                if (SimpleViewer.showMessages) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + SwingProperties.this.propertiesLocation + "\n" + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
                }
                SwingProperties.this.jf.setVisible(false);
            }
        });
        this.confirm.setToolTipText("Save the preferences in the current loaded preferences file");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingProperties.this.jf.setVisible(false);
            }
        });
        this.cancel.setToolTipText("Leave preferences window without saving changes");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = swingGUI.getPropertiesFileLocation();
                JFileChooser jFileChooser = new JFileChooser();
                int n = jFileChooser.showSaveDialog(SwingProperties.this.jf);
                if (n != 1) {
                    if (n != -1) {
                        if (n == 0) {
                            File file = jFileChooser.getSelectedFile();
                            if (file.exists()) {
                                file.delete();
                            }
                            swingGUI.setPropertiesFileLocation(file.getAbsolutePath());
                            SwingProperties.this.setPreferences(swingGUI);
                        }
                    }
                }
                swingGUI.setPropertiesFileLocation(string);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(SwingProperties.this.jf, Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0);
                if (n == 0) {
                    String string = swingGUI.getPropertiesFileLocation();
                    File file = new File(string);
                    if (file.exists()) {
                        file.delete();
                    }
                    swingGUI.getProperties().loadProperties(string);
                    if (SimpleViewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingProperties.this.jf, Messages.getMessage("PdfPreferences.restart"));
                    }
                    SwingProperties.this.jf.setVisible(false);
                }
            }
        });
        this.highlightComposite.addKeyListener(new KeyListener(){
            boolean consume = false;

            public void keyPressed(KeyEvent keyEvent) {
                this.consume = false;
                if (!(((JTextField)keyEvent.getSource()).getText().indexOf(".") == -1 || keyEvent.getKeyChar() != '.' || keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9' || keyEvent.getKeyCode() == 8 && keyEvent.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.consume) {
                    keyEvent.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText("Set the transparency of the highlight");
        this.dpi_Input.addKeyListener(this.numericalKeyListener);
        this.maxMultiViewers.addKeyListener(this.numericalKeyListener);
        this.setLayout(new BorderLayout());
        JButtonBar jButtonBar = new JButtonBar(1);
        if (PdfDecoder.isRunningOnMac) {
            jButtonBar.setPreferredSize(new Dimension(120, 0));
        }
        this.add((Component)new ButtonBarPanel(jButtonBar), "Center");
        jButtonBar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        if (this.properties.isReadOnly()) {
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.confirm);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(this.confirm);
        jPanel.add(filler);
        jPanel.add(this.cancel);
        jPanel.add(filler);
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)jPanel, "South");
    }

    public void setPreferences(SwingGUI swingGUI) {
        int n = 0;
        int n2 = this.pageLayout.getSelectedIndex() + 1;
        if (n2 < 1 || n2 > 5) {
            n2 = 1;
        }
        if (this.border.isSelected()) {
            n = 1;
        }
        int n3 = this.highlightBoxColor.getBackground().getRGB();
        int n4 = this.highlightTextColor.getBackground().getRGB();
        boolean bl = this.invertHighlight.isSelected();
        this.properties.setValue("borderType", String.valueOf(n));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("pageMode", String.valueOf(n2));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String string = this.iconLocation.getText();
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + "/";
        }
        this.properties.setValue("iconLocation", String.valueOf(string));
        this.properties.setValue("pageFlowPages", String.valueOf(this.pageFlowPages.getText()));
        this.properties.setValue("pageFlowExtraCache", String.valueOf(this.pageFlowCache.getText()));
        this.properties.setValue("pageFlowReflection", String.valueOf(this.pageFlowReflection.isSelected()));
        this.properties.setValue("pageFlowSideSize", String.valueOf(this.pageFlowSideSize.getText()));
        this.properties.setValue("pageFlowReflectionHeight", String.valueOf(this.pageFlowReflectionHeight.getText()));
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("DPI", String.valueOf(this.dpi_Input.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("maxmultiviewers", String.valueOf(this.maxMultiViewers.getText()));
        this.properties.setValue("showDownloadWindow", String.valueOf(this.downloadWindow.isSelected()));
        this.properties.setValue("useHiResPrinting", String.valueOf(this.HiResPrint.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(n3));
        this.properties.setValue("highlightTextColor", String.valueOf(n4));
        this.properties.setValue("invertHighlights", String.valueOf(bl));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("enhancedGUI", String.valueOf(this.enhancedGUI.isSelected()));
        this.saveGUIPreferences(swingGUI);
    }

    public void setParent(Component component) {
        this.parent = component;
    }

    public void dispose() {
        this.removeAll();
        this.reverseMessage = null;
        this.menuTabs = null;
        this.propertiesLocation = null;
        if (this.jf != null) {
            this.jf.removeAll();
        }
        this.jf = null;
        this.confirm = null;
        this.cancel = null;
        if (this.tabs != null) {
            this.tabs.removeAll();
        }
        this.tabs = null;
        this.dpi_Input = null;
        this.searchStyle = null;
        this.border = null;
        this.downloadWindow = null;
        this.HiResPrint = null;
        this.constantTabs = null;
        this.enhancedViewer = null;
        this.enhancedFacing = null;
        this.enhancedGUI = null;
        this.rightClick = null;
        this.scrollwheelZoom = null;
        this.update = null;
        this.maxMultiViewers = null;
        this.pageInsets = null;
        this.pageInsetsText = null;
        this.windowTitle = null;
        this.windowTitleText = null;
        this.iconLocation = null;
        this.iconLocationText = null;
        this.pageFlowCacheText = null;
        this.pageFlowCache = null;
        this.sideTabLength = null;
        this.sideTabLengthText = null;
        this.pageFlowPagesText = null;
        this.pageFlowPages = null;
        this.pageFlowReflectionHeightText = null;
        this.pageFlowReflectionHeight = null;
        this.pageFlowSideSizeText = null;
        this.pageFlowSideSize = null;
        this.pageFlowReflection = null;
        this.useHinting = null;
        this.autoScroll = null;
        this.confirmClose = null;
        this.openLastDoc = null;
        this.pageLayout = null;
        if (this.highlightBoxColor != null) {
            this.highlightBoxColor.removeAll();
        }
        this.highlightBoxColor = null;
        if (this.highlightTextColor != null) {
            this.highlightTextColor.removeAll();
        }
        this.highlightTextColor = null;
        if (this.invertHighlight != null) {
            this.invertHighlight.removeAll();
        }
        this.invertHighlight = null;
        if (this.highlightComposite != null) {
            this.highlightComposite.removeAll();
        }
        this.highlightComposite = null;
        if (this.jf != null) {
            this.jf.removeAll();
        }
        this.parent = null;
        this.clearHistory = null;
        this.historyClearedLabel = null;
    }

    class ButtonBarPanel
    extends JPanel {
        private Component currentComponent;
        private boolean newPreferencesCode = true;

        public ButtonBarPanel(JButtonBar jButtonBar) {
            this.setLayout(new BorderLayout());
            this.add((Component)jButtonBar, "West");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.addButton("General", "/org/jpedal/examples/simpleviewer/res/display.png", this.createGeneralSettings(), jButtonBar, buttonGroup);
            this.addButton("Page Display", "/org/jpedal/examples/simpleviewer/res/pagedisplay.png", this.createPageDisplaySettings(), jButtonBar, buttonGroup);
            this.addButton("Interface", "/org/jpedal/examples/simpleviewer/res/interface.png", this.createInterfaceSettings(), jButtonBar, buttonGroup);
            this.addButton("Menu", "/org/jpedal/examples/simpleviewer/res/menu.png", this.createMenuSettings(), jButtonBar, buttonGroup);
        }

        private JPanel makePanel(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jLabel.setOpaque(true);
            jLabel.setBackground(jPanel.getBackground().brighter());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel2.setFont(jPanel2.getFont().deriveFont(1));
            jPanel2.setOpaque(true);
            jPanel2.setBackground(jPanel.getBackground().brighter());
            jPanel2.add((Component)jLabel, "West");
            jPanel.add((Component)jPanel2, "North");
            jPanel.setPreferredSize(new Dimension(400, 300));
            jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return jPanel;
        }

        private JPanel createGeneralSettings() {
            String string = SwingProperties.this.properties.getValue("DPI");
            if (string.length() > 0) {
                SwingProperties.this.dpi_Input.setText(string);
            }
            if ((string = SwingProperties.this.properties.getValue("useHinting")).length() > 0 && string.equals("true")) {
                SwingProperties.this.useHinting.setSelected(true);
            } else {
                SwingProperties.this.useHinting.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("useHiResPrinting");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.HiResPrint.setSelected(true);
            } else {
                SwingProperties.this.HiResPrint.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("autoScroll");
            if (string.equals("true")) {
                SwingProperties.this.autoScroll.setSelected(true);
            } else {
                SwingProperties.this.autoScroll.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("confirmClose");
            if (string.equals("true")) {
                SwingProperties.this.confirmClose.setSelected(true);
            } else {
                SwingProperties.this.confirmClose.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("automaticupdate");
            if (string.equals("true")) {
                SwingProperties.this.update.setSelected(true);
            } else {
                SwingProperties.this.update.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("openLastDocument");
            if (string.equals("true")) {
                SwingProperties.this.openLastDoc.setSelected(true);
            } else {
                SwingProperties.this.openLastDoc.setSelected(false);
            }
            JPanel jPanel = this.makePanel("General");
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel("General Options");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Dpi"));
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.dpi_Input, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.useHinting.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.useHinting, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.HiResPrint.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.HiResPrint.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.HiResPrint, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.autoScroll, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.confirmClose, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel("Startup");
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel3.setFont(jLabel3.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.update.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.update, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.openLastDoc, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(SwingProperties.this.clearHistory);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add(SwingProperties.this.historyClearedLabel);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel2.add((Component)jPanel3, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createPageDisplaySettings() {
            String string = SwingProperties.this.properties.getValue("enhancedViewerMode");
            if (string.length() > 0 && string.equals("true")) {
                SwingProperties.this.enhancedViewer.setSelected(true);
            } else {
                SwingProperties.this.enhancedViewer.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("borderType");
            if (string.length() > 0) {
                if (Integer.parseInt(string) == 1) {
                    SwingProperties.this.border.setSelected(true);
                } else {
                    SwingProperties.this.border.setSelected(false);
                }
            }
            if ((string = SwingProperties.this.properties.getValue("pageInsets")) != null && string.length() != 0) {
                SwingProperties.this.pageInsets.setText(string);
            } else {
                SwingProperties.this.pageInsets.setText("25");
            }
            string = SwingProperties.this.properties.getValue("pageMode");
            if (string.length() > 0) {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 5) {
                    n = 1;
                }
                SwingProperties.this.pageLayout.setSelectedIndex(n - 1);
            }
            if ((string = SwingProperties.this.properties.getValue("enhancedFacingMode")).length() > 0 && string.equals("true")) {
                SwingProperties.this.enhancedFacing.setSelected(true);
            } else {
                SwingProperties.this.enhancedFacing.setSelected(false);
            }
            string = SwingProperties.this.properties.getValue("pageFlowPages");
            if (string != null && string.length() != 0) {
                SwingProperties.this.pageFlowPages.setText(string);
            } else {
                SwingProperties.this.pageFlowPages.setText("8");
            }
            string = SwingProperties.this.properties.getValue("pageFlowExtraCache");
            if (string != null && string.length() != 0) {
                SwingProperties.this.pageFlowCache.setText(string);
            } else {
                SwingProperties.this.pageFlowCache.setText("10");
            }
            string = SwingProperties.this.properties.getValue("pageFlowSideSize");
            if (string != null && string.length() != 0) {
                SwingProperties.this.pageFlowSideSize.setText(string);
            } else {
                SwingProperties.this.pageFlowSideSize.setText("0.75");
            }
            string = SwingProperties.this.properties.getValue("pageFlowReflection");
            if (string.equals("true")) {
                SwingProperties.this.pageFlowReflection.setSelected(true);
                SwingProperties.this.pageFlowReflectionHeight.setEnabled(true);
                SwingProperties.this.pageFlowReflectionHeightText.setEnabled(true);
            } else {
                SwingProperties.this.pageFlowReflection.setSelected(false);
                SwingProperties.this.pageFlowReflectionHeight.setEnabled(false);
                SwingProperties.this.pageFlowReflectionHeightText.setEnabled(false);
            }
            string = SwingProperties.this.properties.getValue("pageFlowReflectionHeight");
            if (string != null && string.length() != 0) {
                SwingProperties.this.pageFlowReflectionHeight.setText(string);
            } else {
                SwingProperties.this.pageFlowReflectionHeight.setText("0.25");
            }
            JPanel jPanel = this.makePanel("Page Display");
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            JLabel jLabel = new JLabel("General Options");
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.enhancedViewer.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedViewer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedViewer, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.border.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.border, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.pageInsetsText, gridBagConstraints);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageInsets, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel("Display Modes");
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageLayout, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.enhancedFacing.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedFacing.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedFacing, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel4 = new JLabel("PageFlow2D Options");
            jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel4, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pageFlowPagesText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.pageFlowPagesText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageFlowPages, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pageFlowCacheText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.pageFlowCacheText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageFlowCache, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pageFlowSideSizeText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.pageFlowSideSizeText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageFlowSideSize, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pageFlowReflection.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.pageFlowReflection, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.pageFlowReflectionHeightText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.pageFlowReflectionHeightText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.pageFlowReflectionHeight, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jPanel.add((Component)jScrollPane, "Center");
            return jPanel;
        }

        private JPanel createInterfaceSettings() {
            String string;
            String string2 = SwingProperties.this.properties.getValue("enhancedGUI");
            if (string2.length() > 0 && string2.equals("true")) {
                SwingProperties.this.enhancedGUI.setSelected(true);
            } else {
                SwingProperties.this.enhancedGUI.setSelected(false);
            }
            string2 = SwingProperties.this.properties.getValue("allowRightClick");
            if (string2.length() > 0 && string2.equals("true")) {
                SwingProperties.this.rightClick.setSelected(true);
            } else {
                SwingProperties.this.rightClick.setSelected(false);
            }
            string2 = SwingProperties.this.properties.getValue("allowScrollwheelZoom");
            if (string2.length() > 0 && string2.equals("true")) {
                SwingProperties.this.scrollwheelZoom.setSelected(true);
            } else {
                SwingProperties.this.scrollwheelZoom.setSelected(false);
            }
            string2 = SwingProperties.this.properties.getValue("windowTitle");
            if (string2 != null && string2.length() != 0) {
                SwingProperties.this.windowTitle.setText(string2);
            }
            if ((string2 = SwingProperties.this.properties.getValue("iconLocation")) != null && string2.length() != 0) {
                SwingProperties.this.iconLocation.setText(string2);
            } else {
                SwingProperties.this.iconLocation.setText("/org/jpedal/examples/simpleviewer/res/");
            }
            string2 = SwingProperties.this.properties.getValue("searchWindowType");
            if (string2.length() > 0) {
                SwingProperties.this.searchStyle.setSelectedIndex(Integer.parseInt(string2));
            } else {
                SwingProperties.this.searchStyle.setSelectedIndex(0);
            }
            string2 = SwingProperties.this.properties.getValue("maxmultiviewers");
            if (string2 != null && string2.length() > 0) {
                SwingProperties.this.maxMultiViewers.setText(string2);
            }
            if ((string2 = SwingProperties.this.properties.getValue("sideTabBarCollapseLength")) != null && string2.length() != 0) {
                SwingProperties.this.sideTabLength.setText(string2);
            } else {
                SwingProperties.this.sideTabLength.setText("30");
            }
            string2 = SwingProperties.this.properties.getValue("consistentTabBar");
            if (string2.length() > 0 && string2.equals("true")) {
                SwingProperties.this.constantTabs.setSelected(true);
            } else {
                SwingProperties.this.constantTabs.setSelected(false);
            }
            string2 = SwingProperties.this.properties.getValue("highlightBoxColor");
            int n = 0;
            n = string2.length() > 0 ? Integer.parseInt(string2) : PdfDecoder.highlightColor.getRGB();
            final Color color = new Color(n);
            SwingProperties.this.highlightBoxColor.setBackground(color);
            string2 = SwingProperties.this.properties.getValue("highlightTextColor");
            int n2 = 0;
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            } else if (PdfDecoder.backgroundColor != null) {
                n2 = PdfDecoder.backgroundColor.getRGB();
            }
            final Color color2 = new Color(n2);
            SwingProperties.this.highlightTextColor.setBackground(color2);
            String string3 = SwingProperties.this.properties.getValue("highlightComposite");
            if (string3.length() > 0) {
                SwingProperties.this.highlightComposite.setText(string3);
            }
            if ((string = SwingProperties.this.properties.getValue("invertHighlights")).length() > 0 && string.toLowerCase().equals("true")) {
                SwingProperties.this.invertHighlight.setSelected(true);
            } else {
                SwingProperties.this.invertHighlight.setSelected(false);
            }
            final JButton jButton = new JButton("Change Highlight Colour");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JColorChooser jColorChooser = new JColorChooser(color);
                    Color color2 = JColorChooser.showDialog(null, "Highlight Color", color);
                    ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightBoxColor.setBackground(color2);
                }
            });
            final JButton jButton2 = new JButton("Change Highlighted Text Colour");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JColorChooser jColorChooser = new JColorChooser(color2);
                    Color color = JColorChooser.showDialog(null, "Highlighted Text Color", color2);
                    ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightTextColor.setBackground(color);
                }
            });
            final JLabel jLabel = new JLabel("Change Highlight Transparency");
            if (SwingProperties.this.invertHighlight.isSelected()) {
                SwingProperties.this.highlightBoxColor.setEnabled(false);
                SwingProperties.this.highlightTextColor.setEnabled(false);
                SwingProperties.this.highlightComposite.setEnabled(false);
                jButton2.setEnabled(false);
                jButton.setEnabled(false);
                jLabel.setEnabled(false);
            } else {
                SwingProperties.this.highlightBoxColor.setEnabled(true);
                SwingProperties.this.highlightTextColor.setEnabled(true);
                SwingProperties.this.highlightComposite.setEnabled(true);
                jButton2.setEnabled(true);
                jButton.setEnabled(true);
                jLabel.setEnabled(true);
            }
            SwingProperties.this.invertHighlight.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightBoxColor.setEnabled(false);
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightTextColor.setEnabled(false);
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightComposite.setEnabled(false);
                        jButton2.setEnabled(false);
                        jButton.setEnabled(false);
                        jLabel.setEnabled(false);
                    } else {
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightBoxColor.setEnabled(true);
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightTextColor.setEnabled(true);
                        ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.highlightComposite.setEnabled(true);
                        jButton2.setEnabled(true);
                        jButton.setEnabled(true);
                        jLabel.setEnabled(true);
                    }
                }
            });
            JPanel jPanel = this.makePanel("Interface");
            JTabbedPane jTabbedPane = new JTabbedPane();
            JPanel jPanel2 = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel2 = new JLabel("General");
            jLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel2.setFont(jLabel2.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            SwingProperties.this.enhancedGUI.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedGUI.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.enhancedGUI, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.windowTitleText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.windowTitle, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel2.add((Component)SwingProperties.this.iconLocationText, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.iconLocation, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            JLabel jLabel3 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.searchStyle, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel4 = new JLabel("Max MultiViewers");
            jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.maxMultiViewers, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel5 = new JLabel("Side Tab");
            jLabel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel5.setFont(jLabel5.getFont().deriveFont(1));
            jPanel2.add((Component)jLabel5, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.sideTabLengthText, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)SwingProperties.this.sideTabLength, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel2.add((Component)SwingProperties.this.constantTabs, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel2.add(Box.createVerticalGlue(), gridBagConstraints);
            jTabbedPane.add("Appearance", jScrollPane);
            JPanel jPanel3 = new JPanel();
            JScrollPane jScrollPane2 = new JScrollPane(jPanel3);
            jScrollPane2.setBorder(BorderFactory.createEmptyBorder());
            jPanel3.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel6 = new JLabel("General");
            jLabel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel6.setFont(jLabel6.getFont().deriveFont(1));
            jPanel3.add((Component)jLabel6, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.rightClick.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel3.add((Component)SwingProperties.this.rightClick, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            SwingProperties.this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jPanel3.add((Component)SwingProperties.this.scrollwheelZoom, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(15, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            JLabel jLabel7 = new JLabel("Highlights");
            jLabel7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            jLabel7.setFont(jLabel7.getFont().deriveFont(1));
            jPanel3.add((Component)jLabel7, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridx = 0;
            SwingProperties.this.highlightBoxColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel3.add((Component)SwingProperties.this.highlightBoxColor, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel3.add((Component)jButton, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            SwingProperties.this.highlightTextColor.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            jPanel3.add((Component)SwingProperties.this.highlightTextColor, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            jPanel3.add((Component)jButton2, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel3.add((Component)SwingProperties.this.highlightComposite, gridBagConstraints);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            jPanel3.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            jPanel3.add((Component)SwingProperties.this.invertHighlight, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            jPanel3.add(Box.createVerticalGlue(), gridBagConstraints);
            jTabbedPane.add("Mouse", jScrollPane2);
            jPanel.add((Component)jTabbedPane, "Center");
            return jPanel;
        }

        private JPanel createMenuSettings() {
            JPanel jPanel = this.makePanel("Menu");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            SwingProperties.this.tabs = new JTabbedPane();
            for (int i = 0; i != SwingProperties.this.menuTabs.length; ++i) {
                Object object;
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]), SwingProperties.this.menuTabs[i]);
                CheckNode checkNode = new CheckNode(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                checkNode.setEnabled(true);
                checkNode.setSelected(true);
                Vector<CheckNode> vector = new Vector<CheckNode>();
                vector.add(checkNode);
                if (this.newPreferencesCode) {
                    object = SwingProperties.this.properties.getChildren(Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]) + "Menu");
                    this.addMenuToTree(i, (NodeList)object, checkNode, vector);
                }
                object = new JTree(checkNode);
                JScrollPane jScrollPane = new JScrollPane((Component)object);
                ((JTree)object).setCellRenderer(new CheckRenderer());
                ((JTree)object).getSelectionModel().setSelectionMode(1);
                ((JTree)object).addTreeSelectionListener(new TreeSelectionListener((JTree)object){
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.val$tree = jTree;
                    }

                    private void setChildrenValue(CheckNode checkNode, boolean bl) {
                        for (int i = 0; i != checkNode.getChildCount(); ++i) {
                            ((CheckNode)checkNode.getChildAt(i)).setSelected(bl);
                            if (((CheckNode)checkNode.getChildAt(i)).getChildCount() <= 0) continue;
                            this.setChildrenValue((CheckNode)checkNode.getChildAt(i), bl);
                        }
                    }

                    private void setParentValue(CheckNode checkNode, boolean bl) {
                        checkNode.setSelected(bl);
                        if ((CheckNode)checkNode.getParent() != null) {
                            this.setParentValue((CheckNode)checkNode.getParent(), bl);
                        }
                    }

                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.val$tree.getLastSelectedPathComponent();
                        Runnable runnable = new Runnable(){

                            public void run() {
                                CheckNode checkNode = (CheckNode)defaultMutableTreeNode;
                                if (checkNode != null) {
                                    int n;
                                    boolean bl;
                                    boolean bl2 = bl = !checkNode.isSelected();
                                    if (((ButtonBarPanel)(this).ButtonBarPanel.this).SwingProperties.this.reverseMessage.get(checkNode.getText()).equals("Preferences") && !bl && (n = JOptionPane.showConfirmDialog(((ButtonBarPanel)(this).ButtonBarPanel.this).SwingProperties.this.jf, "Disabling this option will mean you can not acces this menu using this properties file. Do you want to continue?", "Preferences Access", 0)) == 1) {
                                        boolean bl3 = bl = !bl;
                                    }
                                    if (checkNode.getChildCount() > 0) {
                                        this.setChildrenValue(checkNode, bl);
                                    }
                                    if ((CheckNode)checkNode.getParent() != null && bl) {
                                        this.setParentValue((CheckNode)checkNode.getParent(), bl);
                                    }
                                    checkNode.setSelected(bl);
                                    val$tree.invalidate();
                                    val$tree.clearSelection();
                                    val$tree.repaint();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                });
                JPanel jPanel3 = new JPanel(new BorderLayout());
                final JButton jButton = new JButton();
                String string = SwingProperties.this.properties.getValue(SwingProperties.this.menuTabs[i]);
                if (string.toLowerCase().equals("true")) {
                    jButton.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + " " + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                } else {
                    jButton.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + " " + Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
                }
                final int n = i;
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jButton.getText().startsWith("Click here to show ")) {
                            jButton.setText(Messages.getMessage("PdfCustomGui.HideGuiSection") + " " + Messages.getMessage("PdfCustomGui." + ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.menuTabs[n]));
                        } else {
                            jButton.setText(Messages.getMessage("PdfCustomGui.ShowGuiSection") + " " + Messages.getMessage("PdfCustomGui." + ((ButtonBarPanel)ButtonBarPanel.this).SwingProperties.this.menuTabs[n]));
                        }
                    }
                });
                jPanel3.add((Component)jScrollPane, "Center");
                jPanel3.add((Component)jButton, "South");
                SwingProperties.this.tabs.add((Component)jPanel3, Messages.getMessage("PdfCustomGui." + SwingProperties.this.menuTabs[i]));
            }
            jPanel2.add((Component)SwingProperties.this.tabs, "Center");
            jPanel.add((Component)jPanel2, "Center");
            return jPanel;
        }

        private void addMenuToTree(int n, NodeList nodeList, CheckNode checkNode, Vector vector) {
            for (int i = 0; i != nodeList.getLength(); ++i) {
                String string;
                if (i >= nodeList.getLength() || (string = nodeList.item(i).getNodeName()).startsWith("#")) continue;
                CheckNode checkNode2 = new CheckNode(Messages.getMessage("PdfCustomGui." + string));
                checkNode2.setEnabled(true);
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + string), string);
                String string2 = SwingProperties.this.properties.getValue(string);
                if (string2.length() > 0 && string2.equals("true")) {
                    checkNode2.setSelected(true);
                } else {
                    checkNode2.setSelected(false);
                }
                if (nodeList.item(i).hasChildNodes()) {
                    vector.add(checkNode);
                    checkNode.add(checkNode2);
                    this.addMenuToTree(n, nodeList.item(i).getChildNodes(), checkNode2, vector);
                    continue;
                }
                checkNode.add(checkNode2);
            }
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String string, String string2, final Component component, JButtonBar jButtonBar, ButtonGroup buttonGroup) {
            AbstractAction abstractAction = new AbstractAction(string, new ImageIcon(this.getClass().getResource(string2))){

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton jToggleButton = new JToggleButton(abstractAction);
            if (PdfDecoder.isRunningOnMac) {
                jToggleButton.setHorizontalAlignment(2);
            }
            jButtonBar.add(jToggleButton);
            buttonGroup.add(jToggleButton);
            if (buttonGroup.getSelection() == null) {
                jToggleButton.setSelected(true);
                this.show(component);
            }
        }
    }
}

