/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;

public class SwingButton
extends JButton
implements GUIButton {
    private int ID;

    public SwingButton() {
    }

    public SwingButton(String string) {
        super(string);
    }

    public void init(URL uRL, int n, String string) {
        this.ID = n;
        this.setToolTipText(string);
        this.setBorderPainted(false);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIcon(imageIcon);
            SwingButton.createPressedLook(this, imageIcon);
        } else {
            this.setText(uRL.getFile().split("\\.")[0]);
            this.setFont(new Font("Lucida", 2, 14));
            if (uRL.equals("Buy")) {
                this.setForeground(Color.BLUE);
            } else {
                this.setForeground(Color.RED);
            }
        }
    }

    private static void createPressedLook(AbstractButton abstractButton, ImageIcon imageIcon) {
        BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth() + 2, imageIcon.getIconHeight() + 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 1, 1, null);
        graphics2D.dispose();
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        abstractButton.setPressedIcon(imageIcon2);
    }

    public void setIcon(ImageIcon imageIcon) {
        super.setIcon(imageIcon);
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public int getID() {
        return this.ID;
    }

    public void setName(String string) {
        super.setName(string);
    }
}

