/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.decompression.CCITTFactory;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.TiffDecoder;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;

public class PdfFilteredReader
extends PdfFileReader {
    public static final int A85 = 1116165;
    public static final int AHx = 0x111848;
    public static final int ASCII85Decode = 1582784916;
    public static final int ASCIIHexDecode = 2074112677;
    public static final int CCITTFaxDecode = 2108391315;
    public static final int CCF = 0x131316;
    public static final int Crypt = 1112096855;
    public static final int DCTDecode = 1180911742;
    public static final int Fl = 5692;
    public static final int FlateDecode = 2005566619;
    public static final int JBIG2Decode = 1247500931;
    public static final int JPXDecode = 1399277700;
    public static final int LZW = 1845799;
    public static final int LZWDecode = 1566984326;
    public static final int RL = 8732;
    public static final int RunLengthDecode = -1815163937;
    BufferedOutputStream streamCache = null;
    BufferedInputStream bis = null;
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};

    public byte[] decodeFilters(PdfObject pdfObject, byte[] byArray, PdfArrayIterator pdfArrayIterator, int n, int n2, boolean bl, byte[] byArray2, String string) throws Exception {
        this.streamCache = null;
        this.bis = null;
        boolean bl2 = string != null;
        int n3 = -1;
        int n4 = pdfArrayIterator.getTokenCount();
        if (n4 > 0) {
            while (pdfArrayIterator.hasMoreTokens()) {
                n3 = pdfArrayIterator.getNextValueAsConstant(true);
                if (bl2 && string != null) {
                    this.setupCachedObjectForDecoding(byArray, string, false);
                }
                if (n3 == 2005566619 || n3 == 5692) {
                    try {
                        byArray = this.flateDecode(byArray, pdfObject, string);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Invalid flate stream");
                    }
                    catch (Error error) {
                        LogWriter.writeLog("Invalid flate stream");
                    }
                } else if (n3 == 1582784916 || n3 == 1116165) {
                    if (byArray != null) {
                        byArray = PdfFilteredReader.ascii85Decode(byArray);
                    }
                    if (this.bis != null) {
                        PdfFilteredReader.ascii85Decode(this.bis, this.streamCache);
                    }
                } else if (n3 == 2108391315 || n3 == 0x131316) {
                    Object object;
                    JAIHelper.confirmJAIOnClasspath();
                    if (bl2) {
                        int n5 = this.bis.available();
                        byArray = new byte[n5];
                        this.bis.read(byArray);
                    }
                    boolean bl3 = false;
                    if (pdfObject != null) {
                        bl3 = pdfObject.getBoolean(-823077984);
                    }
                    byte[] byArray3 = null;
                    boolean bl4 = true;
                    if (!bl4 && !bl3 && bl && JAIHelper.isJAIused() && byArray != null) {
                        object = new TiffDecoder(n, n2, pdfObject, byArray);
                        byArray3 = ((TiffDecoder)object).getRawBytes();
                    }
                    if (byArray3 == null) {
                        if (bl4 && pdfObject.getInt(27) == 0) {
                            object = new CCITTFactory(byArray, n, n2, pdfObject);
                            byArray = ((CCITTFactory)object).decode();
                        } else {
                            byArray = PdfFilteredReader.ccittDecode(byArray, pdfObject, n, n2);
                        }
                    } else {
                        byArray = byArray3;
                    }
                    if (bl2) {
                        this.streamCache.write(byArray);
                    }
                } else if (n3 == 1566984326 || n3 == 1845799) {
                    try {
                        byArray = this.lzwDecode(this.bis, this.streamCache, byArray, pdfObject, n, n2, string);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + " in LZW decompression");
                        byArray = null;
                    }
                } else if (n3 == -1815163937 || n3 == 8732) {
                    byArray = PdfFilteredReader.runLengthDecode(byArray, this.bis, this.streamCache);
                } else if (n3 == 1247500931) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.bis = new BufferedInputStream(byteArrayInputStream);
                    byArray = PdfFilteredReader.JBIGDecode(this.bis, this.streamCache, byArray, byArray2, string);
                } else if (n3 == 2074112677 || n3 == 0x111848) {
                    if (byArray != null) {
                        byArray = PdfFilteredReader.asciiHexDecode(byArray);
                    }
                    if (this.bis != null) {
                        PdfFilteredReader.asciiHexDecode(this.bis, this.streamCache);
                    }
                } else if (n3 == 1112096855) {
                    // empty if block
                }
                if (!bl2) continue;
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.streamCache == null) continue;
                this.streamCache.flush();
                this.streamCache.close();
            }
        }
        return byArray;
    }

    public static String getFilterName(int n) {
        switch (n) {
            case 1116165: {
                return "A85";
            }
            case 0x111848: {
                return "AHx";
            }
            case 1582784916: {
                return "ASCII85Decode";
            }
            case 2074112677: {
                return "ASCIIHexDecode";
            }
            case 2108391315: {
                return "CCITTFaxDecode";
            }
            case 0x131316: {
                return "CCF";
            }
            case 1112096855: {
                return "Crypt";
            }
            case 1180911742: {
                return "DCTDecode";
            }
            case 5692: {
                return "Fl";
            }
            case 2005566619: {
                return "FlateDecode";
            }
            case 1247500931: {
                return "JBIG2Decode";
            }
            case 1399277700: {
                return "";
            }
            case 1845799: {
                return "";
            }
            case 1566984326: {
                return "";
            }
            case 8732: {
                return "";
            }
            case -1815163937: {
                return "";
            }
        }
        return "Unknown";
    }

    private void setupCachedObjectForDecoding(byte[] byArray, String string, boolean bl) throws IOException {
        File file = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(file.getAbsolutePath(), "x");
        ObjectStore.copy(string, file.getAbsolutePath());
        File file2 = new File(string);
        file2.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(string));
        if (bl) {
            System.out.println("cache size=" + file.length());
        }
        this.bis = new BufferedInputStream(new FileInputStream(file));
    }

    private static byte[] runLengthDecode(byte[] byArray, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        if (byArray != null) {
            n = byArray.length;
            byteArrayOutputStream = new ByteArrayOutputStream(n);
        }
        if (bufferedInputStream != null) {
            n = bufferedInputStream.available();
        }
        if (byArray != null && bufferedInputStream != null && byArray.length != bufferedInputStream.available()) {
            System.out.println("Different lengths in RunLengthDecode");
            System.out.println(byArray.length + " " + bufferedInputStream.available());
        }
        for (int i = 0; i < n; ++i) {
            int n5;
            if (byArray != null) {
                n2 = byArray[i];
            }
            if (bufferedInputStream != null) {
                n3 = bufferedInputStream.read();
                if (n3 >= 128) {
                    n3 -= 256;
                }
                if (byArray != null && n2 != n3) {
                    System.out.println("Len wrong =" + n2 + ' ' + n3);
                }
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 == 128) {
                i = n;
                continue;
            }
            if (n2 > 128) {
                ++i;
                n2 = 257 - n2;
                if (byArray != null) {
                    by = byArray[i];
                }
                if (bufferedOutputStream != null && (n4 = bufferedInputStream.read()) >= 128) {
                    n4 -= 256;
                }
                if (byArray != null && bufferedInputStream != null && by != n4) {
                    System.out.println("Different values in RunLengthDecode");
                    System.out.println(by + " " + n4 + ' ' + bufferedOutputStream);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    if (byArray != null) {
                        byteArrayOutputStream.write(by);
                    }
                    if (bufferedOutputStream == null) continue;
                    bufferedOutputStream.write(n4);
                }
                continue;
            }
            ++i;
            ++n2;
            for (n5 = 0; n5 < n2; ++n5) {
                if (byArray != null) {
                    by = byArray[i + n5];
                    byteArrayOutputStream.write(by);
                }
                if (bufferedOutputStream != null) {
                    n4 = bufferedInputStream.read();
                    if (n4 >= 128) {
                        n4 -= 256;
                    }
                    bufferedOutputStream.write(n4);
                }
                if (byArray == null || bufferedInputStream == null || by == n4) continue;
                System.out.println("2Different values in RunLengthDecode");
                System.out.println(by + " " + n4);
            }
            i = i + n2 - 1;
        }
        if (byArray != null) {
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private final byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, PdfObject pdfObject, int n, int n2, String string) throws Exception {
        int n3 = 1;
        int n4 = 8;
        int n5 = n2;
        int n6 = n;
        int n7 = 1;
        int n8 = 8;
        if (pdfObject != null) {
            int n9;
            int n10;
            int n11 = pdfObject.getInt(-1344207655);
            if (n11 != -1) {
                n8 = n11;
            }
            if ((n10 = pdfObject.getInt(1010783618)) != -1) {
                n7 = n10;
            }
            if ((n9 = pdfObject.getInt(1162902911)) != -1) {
                n6 = n9;
            }
            n3 = pdfObject.getInt(1970893723);
            int n12 = pdfObject.getInt(574572355);
            if (n12 != -1) {
                n5 = n12;
            }
        }
        return this.lzwDecode(bufferedInputStream, bufferedOutputStream, byArray, string, n3, n4, n5, n6, n7, n8);
    }

    private byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, String string, int n, int n2, int n3, int n4, int n5, int n6) throws Exception, IOException {
        Object object;
        if (n3 * n4 == 1) {
            if (byArray != null) {
                byte[] byArray2 = new byte[n2 * n3 * (n4 + 7 >> 3)];
                TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder(n4, n, n2);
                tIFFLZWDecoder.decode(byArray, byArray2, n3);
                return this.applyPredictor(n, byArray2, n5, n2, n4);
            }
            return null;
        }
        if (bufferedInputStream != null) {
            object = new LZWDecoder2();
            ((LZWDecoder2)object).decode(byArray, bufferedOutputStream, bufferedInputStream);
        }
        if (byArray != null) {
            object = new ByteArrayOutputStream();
            LZWDecoder lZWDecoder = new LZWDecoder();
            lZWDecoder.decode(byArray, (OutputStream)object);
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        if (n != 1 && n != 10) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            if (string != null) {
                this.setupCachedObjectForDecoding(byArray, string, false);
            }
        }
        byArray = this.applyPredictor(n, byArray, n5, n6, n4);
        return byArray;
    }

    private static final byte[] JBIGDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, byte[] byArray2, String string) throws Exception {
        try {
            JBIG2Decoder jBIG2Decoder = new JBIG2Decoder();
            if (byArray2 != null && byArray2.length > 0) {
                jBIG2Decoder.setGlobalData(byArray2);
            }
            jBIG2Decoder.decodeJBIG2(byArray);
            byArray = jBIG2Decoder.getPageAsJBIG2Bitmap(0).getData(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    private static byte[] ccittDecode(byte[] byArray, PdfObject pdfObject, int n, int n2) throws Exception {
        boolean bl = false;
        int n3 = 1728;
        int n4 = n2;
        int n5 = 0;
        boolean bl2 = false;
        if (pdfObject != null) {
            bl = pdfObject.getBoolean(1297445940);
            int n6 = pdfObject.getInt(1162902911);
            if (n6 != -1) {
                n3 = n6;
            }
            bl2 = pdfObject.getBoolean(-823077984);
            n5 = pdfObject.getInt(27);
            int n7 = pdfObject.getInt(574572355);
            if (n7 != -1) {
                n4 = n7;
            }
        }
        return PdfFilteredReader.sunCCITTDecode(byArray, bl, n3, n4, n5, bl2);
    }

    private static byte[] sunCCITTDecode(byte[] byArray, boolean bl, int n, int n2, int n3, boolean bl2) {
        byte[] byArray2 = new byte[n2 * (n + 7 >> 3)];
        try {
            TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(1, n, n2);
            if (n3 == 0) {
                tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n2);
            } else if (n3 > 0) {
                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n2, 0L);
            } else if (n3 < 0) {
                tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n2, 0L, bl2);
            }
            if (!bl) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)(255 - byArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing CCITT filter " + exception);
        }
        return byArray2;
    }

    private static final byte[] ascii85Decode(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        for (n = 0; n < n4; ++n) {
            if (byArray[n] == 122) {
                ++n2;
            }
            if (byArray[n] != 10 && byArray[n] != 10) continue;
            ++n3;
        }
        n = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n4 - n3 + 1 + n2 * 3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            l = 0L;
            byte by = byArray[i];
            while (by == 10 || by == 13) {
                if (++i == n4) {
                    by = 0;
                    continue;
                }
                by = byArray[i];
            }
            if (by == 122) {
                for (n6 = 0; n6 < 4; ++n6) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n4 - i <= 4 || by <= 32 || by >= 118) continue;
            for (n5 = 0; n5 < 5; ++n5) {
                if (i < byArray.length) {
                    by = byArray[i];
                }
                while (by == 10 || by == 13) {
                    if (++i == n4) {
                        by = 0;
                        continue;
                    }
                    by = byArray[i];
                }
                ++i;
                if ((by <= 32 || by >= 118) && by != 126) continue;
                l += (long)(by - 33) * base_85_indices[n5];
            }
            for (n6 = 0; n6 < 4; ++n6) {
                byArray2[n] = (byte)(l / hex_indices[n6] & 0xFFL);
                ++n;
            }
            --i;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private static final void ascii85Decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        long l = 0L;
        int n = 0;
        try {
            boolean bl = false;
            while (bufferedInputStream.available() > 0) {
                int n2;
                l = 0L;
                n = PdfFilteredReader.read(bufferedInputStream);
                if (n == 122) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        bufferedOutputStream.write(0);
                    }
                    continue;
                }
                if (bufferedInputStream.available() < 4 || n <= 32 || n >= 118) continue;
                l += (long)(n - 33) * base_85_indices[0];
                for (n2 = 1; n2 < 5; ++n2) {
                    n = PdfFilteredReader.read(bufferedInputStream);
                    if (n == -1) {
                        n = 0;
                    }
                    if (n == -1) {
                        bl = true;
                    }
                    if ((n <= 32 || n >= 118) && n != 126) continue;
                    l += (long)(n - 33) * base_85_indices[n2];
                }
                if (bl) continue;
                for (n2 = 0; n2 < 4; ++n2) {
                    byte by = (byte)(l / hex_indices[n2] & 0xFFL);
                    bufferedOutputStream.write(by);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int read(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        while (n == 13 || n == 10) {
            n = bufferedInputStream.read();
        }
        return n;
    }

    private static final byte[] asciiHexDecode(byte[] byArray) throws IOException {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer2.append(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n = stringBuffer2.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        do {
            if (!((c = (char)stringBuffer2.charAt(n2)) >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F')) continue;
            stringBuffer.append(c);
            if (n3 == 1) {
                byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                n3 = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            ++n3;
        } while (c != '>' && ++n2 != n);
        if (n3 == 1) {
            stringBuffer.append('0');
            byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static final void asciiHexDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        int n = bufferedInputStream.available();
        for (int i = 0; i < n; ++i) {
            c = (char)bufferedInputStream.read();
            while (c == '\n') {
                c = (char)bufferedInputStream.read();
            }
            if (c >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F') {
                stringBuffer.append(c);
                if (n == 1) {
                    bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                    n = 0;
                    stringBuffer = new StringBuffer();
                } else {
                    ++n;
                }
            }
            if (c == '>') break;
        }
        if (n == 1) {
            stringBuffer.append('0');
            bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
    }

    private final byte[] flateDecode(byte[] byArray, PdfObject pdfObject, String string) throws Exception {
        byte[] byArray2 = null;
        int n = 1;
        int n2 = 1;
        int n3 = 8;
        int n4 = 1;
        if (pdfObject != null) {
            int n5;
            int n6;
            int n7 = pdfObject.getInt(-1344207655);
            if (n7 != -1) {
                n3 = n7;
            }
            if ((n6 = pdfObject.getInt(1010783618)) != -1) {
                n2 = n6;
            }
            if ((n5 = pdfObject.getInt(1162902911)) != -1) {
                n4 = n5;
            }
            n = pdfObject.getInt(1970893723);
        }
        return this.flateDecode(byArray, string, byArray2, n, n2, n3, n4);
    }

    private byte[] flateDecode(byte[] byArray, String string, byte[] byArray2, int n, int n2, int n3, int n4) throws DataFormatException, Exception {
        int n5;
        Object object;
        if (byArray != null) {
            object = new Inflater();
            ((Inflater)object).setInput(byArray);
            n5 = byArray.length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
            int n6 = 512000;
            if (n5 < n6) {
                n6 = n5;
            }
            byte[] byArray3 = new byte[n6];
            while (!((Inflater)object).finished()) {
                int n7 = ((Inflater)object).inflate(byArray3);
                byteArrayOutputStream.write(byArray3, 0, n7);
                if (((Inflater)object).getRemaining() != 0) continue;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (this.bis != null) {
            try {
                object = new InflaterInputStream(this.bis);
                n5 = 0;
                while (true) {
                    int n8 = ((InputStream)object).read();
                    if (((InputStream)object).available() == 0 || n8 == -1) break;
                    this.streamCache.write(n8);
                    ++n5;
                }
                if (n != 1 && n != 10) {
                    this.streamCache.flush();
                    this.streamCache.close();
                    if (string != null) {
                        this.setupCachedObjectForDecoding(byArray, string, false);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        byArray2 = this.applyPredictor(n, byArray, n2, n3, n4);
        return byArray2;
    }

    private static void applyPredictorFunction(int n, BufferedInputStream bufferedInputStream, OutputStream outputStream, int n2, int n3, int n4) throws Exception {
        int n5 = n;
        int n6 = bufferedInputStream.available();
        int n7 = (n2 * n3 + 7) / 8;
        int n8 = (n4 * n2 * n3 + 7) / 8 + n7;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        int n9 = 0;
        try {
            int n10 = 0;
            while (n6 > n10) {
                n5 = n;
                int n11 = 0;
                int n12 = n7;
                int n13 = n8;
                if (n5 >= 10) {
                    n9 = bufferedInputStream.read();
                    if (n9 == -1) break;
                    n9 += 10;
                } else {
                    n9 = n5;
                }
                while (n12 < n13 && (n11 = bufferedInputStream.read(byArray, n12, n13 - n12)) != -1) {
                    n12 += n11;
                    n10 += n11;
                }
                if (n11 == -1) break;
                switch (n9) {
                    case 2: {
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            n15 = byArray[n16] & 0xFF;
                            n14 = byArray[n16 - n7] & 0xFF;
                            byArray[n16] = (byte)(n15 + n14 & 0xFF);
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 10: {
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 11: {
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            n15 = byArray[n16] & 0xFF;
                            n14 = byArray[n16 - n7] & 0xFF;
                            byArray[n16] = (byte)(n15 + n14);
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 12: {
                        int n15;
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            n15 = (byArray2[n16] & 0xFF) + (byArray[n16] & 0xFF);
                            byArray[n16] = (byte)n15;
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 13: {
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            n15 = byArray[n16] & 0xFF;
                            n14 = (byArray[n16 - n7] & 0xFF) + (byArray2[n16] & 0xFF) >> 1;
                            byArray[n16] = (byte)(n15 + n14);
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 14: {
                        int n14;
                        int n15;
                        int n16;
                        for (n16 = n7; n16 < n8; ++n16) {
                            n15 = byArray[n16 - n7] & 0xFF;
                            n14 = byArray2[n16] & 0xFF;
                            int n17 = byArray2[n16 - n7] & 0xFF;
                            int n18 = n15 + n14 - n17;
                            int n19 = n18 - n15;
                            int n20 = n18 - n14;
                            int n21 = n18 - n17;
                            if (n19 < 0) {
                                n19 = -n19;
                            }
                            if (n20 < 0) {
                                n20 = -n20;
                            }
                            if (n21 < 0) {
                                n21 = -n21;
                            }
                            byArray[n16] = n19 <= n20 && n19 <= n21 ? (byte)(byArray[n16] + n15) : (n20 <= n21 ? (byte)(byArray[n16] + n14) : (byte)(byArray[n16] + n17));
                            outputStream.write(byArray[n16]);
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] applyPredictor(int n, byte[] byArray, int n2, int n3, int n4) throws Exception {
        boolean bl;
        if (n == 1) {
            return byArray;
        }
        boolean bl2 = bl = byArray == null;
        if (bl) {
            PdfFilteredReader.applyPredictorFunction(n, this.bis, this.streamCache, n2, n3, n4);
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        int n5 = PdfFilteredReader.applyPredictorFunction2(n, bufferedInputStream, null, n2, n3, n4);
        byteArrayInputStream.close();
        bufferedInputStream.close();
        byte[] byArray2 = new byte[n5];
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
        PdfFilteredReader.applyPredictorFunction2(n, bufferedInputStream, byArray2, n2, n3, n4);
        byteArrayInputStream.close();
        bufferedInputStream.close();
        return byArray2;
    }

    private static int applyPredictorFunction2(int n, BufferedInputStream bufferedInputStream, byte[] byArray, int n2, int n3, int n4) throws Exception {
        int n5 = 0;
        int n6 = n;
        int n7 = bufferedInputStream.available();
        int n8 = (n2 * n3 + 7) / 8;
        int n9 = (n4 * n2 * n3 + 7) / 8 + n8;
        byte[] byArray2 = new byte[n9];
        byte[] byArray3 = new byte[n9];
        int n10 = 0;
        try {
            int n11 = 0;
            while (n7 > n11) {
                n6 = n;
                int n12 = 0;
                int n13 = n8;
                int n14 = n9;
                if (n6 >= 10) {
                    n10 = bufferedInputStream.read();
                    if (n10 == -1) break;
                    n10 += 10;
                } else {
                    n10 = n6;
                }
                while (n13 < n14 && (n12 = bufferedInputStream.read(byArray2, n13, n14 - n13)) != -1) {
                    n13 += n12;
                    n11 += n12;
                }
                if (n12 != -1) {
                    switch (n10) {
                        case 2: {
                            int n15;
                            int n16;
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                n16 = byArray2[n17] & 0xFF;
                                n15 = byArray2[n17 - n8] & 0xFF;
                                byArray2[n17] = (byte)(n16 + n15 & 0xFF);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 10: {
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 11: {
                            int n15;
                            int n16;
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                n16 = byArray2[n17] & 0xFF;
                                n15 = byArray2[n17 - n8] & 0xFF;
                                byArray2[n17] = (byte)(n16 + n15);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 12: {
                            int n16;
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                n16 = (byArray3[n17] & 0xFF) + (byArray2[n17] & 0xFF);
                                byArray2[n17] = (byte)n16;
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 13: {
                            int n15;
                            int n16;
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                n16 = byArray2[n17] & 0xFF;
                                n15 = (byArray2[n17 - n8] & 0xFF) + (byArray3[n17] & 0xFF) >> 1;
                                byArray2[n17] = (byte)(n16 + n15);
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 14: {
                            int n15;
                            int n16;
                            int n17;
                            for (n17 = n8; n17 < n9; ++n17) {
                                n16 = byArray2[n17 - n8] & 0xFF;
                                n15 = byArray3[n17] & 0xFF;
                                int n18 = byArray3[n17 - n8] & 0xFF;
                                int n19 = n16 + n15 - n18;
                                int n20 = n19 - n16;
                                int n21 = n19 - n15;
                                int n22 = n19 - n18;
                                if (n20 < 0) {
                                    n20 = -n20;
                                }
                                if (n21 < 0) {
                                    n21 = -n21;
                                }
                                if (n22 < 0) {
                                    n22 = -n22;
                                }
                                byArray2[n17] = n20 <= n21 && n20 <= n22 ? (byte)(byArray2[n17] + n16) : (n21 <= n22 ? (byte)(byArray2[n17] + n15) : (byte)(byArray2[n17] + n18));
                                if (byArray != null) {
                                    byArray[n5] = byArray2[n17];
                                }
                                ++n5;
                            }
                            break;
                        }
                        case 15: {
                            break;
                        }
                    }
                    System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n5;
    }
}

