/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class DiscreteAngle {
    private SortedSet angles = new TreeSet();

    public double getAngle(double angle) {
        if (this.angles.isEmpty()) {
            return angle;
        }
        Iterator i = this.angles.iterator();
        Double prev = (Double)i.next();
        if (!i.hasNext()) {
            return prev;
        }
        while (i.hasNext()) {
            Double cur = (Double)i.next();
            double cutoff = (cur - prev) / 2.0 + prev;
            if (angle <= cutoff) {
                return prev;
            }
            prev = cur;
        }
        return prev;
    }

    public Double addAngle(double angle) {
        Double a = new Double(angle);
        this.angles.add(a);
        return a;
    }

    public boolean removeAngle(double angle) {
        for (Double r : this.angles) {
            if (r != angle) continue;
            return this.removeAngle(r);
        }
        return false;
    }

    public boolean removeAngle(Double angle) {
        return angle != null ? this.angles.remove(angle) : false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Angles: ");
        Iterator i = this.angles.iterator();
        while (i.hasNext()) {
            Double r = (Double)i.next();
            s.append(r);
            if (!i.hasNext()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    public static void main(String[] args) {
        DiscreteAngle da = new DiscreteAngle();
        da.addAngle(0.0);
        da.addAngle(90.0);
        da.addAngle(180.0);
        da.addAngle(270.0);
        da.addAngle(360.0);
        da.addAngle(10.0);
        da.addAngle(190.0);
        System.out.println("  0 results in " + da.getAngle(0.0));
        System.out.println("  1 results in " + da.getAngle(1.0));
        System.out.println("  5 results in " + da.getAngle(5.0));
        System.out.println(" 80 results in " + da.getAngle(80.0));
        System.out.println(" 90 results in " + da.getAngle(90.0));
        System.out.println("170 results in " + da.getAngle(170.0));
        System.out.println("185 results in " + da.getAngle(185.0));
        System.out.println("186 results in " + da.getAngle(186.0));
        System.out.println("231 results in " + da.getAngle(231.0));
        System.out.println("359 results in " + da.getAngle(359.0));
    }
}

