/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator
implements Comparator {
    private static String[] special = new String[]{"SNAPSHOT", "alpha", "beta", "rc"};
    private static String pattern = "\\.+";
    private static Pattern pFileName = Pattern.compile("^([^.]+?)[-_](\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:[-_]([^-_]+))??(?:[-_](\\d+))?$");
    private static Pattern pVersion = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:[-_]([^-_]+))??(?:[-_](\\d+))?$");

    public static String stripVersion(String fileName) {
        Matcher m = pFileName.matcher(fileName);
        if (m.matches()) {
            return m.group(1);
        }
        throw new IllegalArgumentException("Unknown version format: " + fileName);
    }

    public static String stripName(String fileName) {
        Matcher m = pFileName.matcher(fileName);
        if (m.matches()) {
            int i = m.group(1).length();
            return fileName.substring(i + 1);
        }
        throw new IllegalArgumentException("Unknown version format: " + fileName);
    }

    public static Version getVersionFromFileName(String fileName) {
        Matcher m = pFileName.matcher(fileName);
        if (m.matches()) {
            try {
                return new Version(m.group(2), m.group(3), m.group(4), m.group(5), m.group(6));
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Unknown version format: " + fileName);
            }
        }
        throw new IllegalArgumentException("Unknown version format: " + fileName);
    }

    public static Version getVersion(String version) {
        Matcher m = pVersion.matcher(version);
        if (m.matches()) {
            try {
                return new Version(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
            }
            catch (Exception x) {
                throw new IllegalArgumentException("Unknown version format: " + version);
            }
        }
        throw new IllegalArgumentException("Unknown version format: " + version);
    }

    public static int compareVersion(String version1, String version2) {
        return VersionComparator.getVersion(version1).compareTo(VersionComparator.getVersion(version2));
    }

    public static Comparator<String> getComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String version1, String version2) {
                try {
                    return VersionComparator.compareVersion(version1, version2);
                }
                catch (IllegalArgumentException x) {
                    try {
                        VersionComparator.getVersion(version1);
                        return -1;
                    }
                    catch (IllegalArgumentException xx) {
                        try {
                            VersionComparator.getVersion(version2);
                            return 1;
                        }
                        catch (IllegalArgumentException xxx) {
                            return String.CASE_INSENSITIVE_ORDER.compare(version1, version2);
                        }
                    }
                }
            }
        };
    }

    public int versionNumberCompare(String v1, String v2) throws NumberFormatException {
        String[] t1 = this.replaceSpecials(v1).split(pattern);
        String[] t2 = this.replaceSpecials(v2).split(pattern);
        int maxLength = Math.max(t1.length, t2.length);
        for (int i = 0; i < maxLength; ++i) {
            int i2;
            int i1 = i < t1.length ? Integer.parseInt(t1[i]) : 0;
            int n = i2 = i < t2.length ? Integer.parseInt(t2[i]) : 0;
            if (i1 == i2) continue;
            return i1 - i2;
        }
        return 0;
    }

    private String replaceSpecials(String in) {
        in = in.replaceAll("-", ".");
        for (int i = 0; i < special.length; ++i) {
            int j = -special.length + i;
            in = in.replaceAll(special[i], "." + j + ".");
        }
        return in;
    }

    public int compare(Object obj, Object obj1) {
        return this.versionNumberCompare(obj.toString(), obj1.toString());
    }

    public static class Version
    implements Comparable<Version> {
        private int major;
        private int minor;
        private int incremental;
        private String qualifier;
        private int build;

        Version(String major, String minor, String incremental, String qualifier, String build) {
            this.major = Integer.parseInt(major);
            this.minor = minor == null ? 0 : Integer.parseInt(minor);
            this.incremental = incremental == null ? 0 : Integer.parseInt(incremental);
            this.qualifier = qualifier;
            this.build = build == null ? 0 : Integer.parseInt(build);
        }

        Version(int major, int minor, int incremental, String qualifier, int build) {
            this.major = major;
            this.minor = minor;
            this.incremental = incremental;
            this.qualifier = qualifier;
            this.build = build;
        }

        public int major() {
            return this.major;
        }

        public int minor() {
            return this.minor;
        }

        public int incremental() {
            return this.incremental;
        }

        public String qualifier() {
            return this.qualifier;
        }

        public int build() {
            return this.build;
        }

        @Override
        public int compareTo(Version other) {
            if (this.major != other.major) {
                return this.major - other.major;
            }
            if (this.minor != other.minor) {
                return this.minor - other.minor;
            }
            if (this.incremental != other.incremental) {
                return this.incremental - other.incremental;
            }
            if (this.qualifier == null) {
                if (other.qualifier != null) {
                    return 1;
                }
            } else {
                if (other.qualifier == null) {
                    return -1;
                }
                int out = this.qualifier.compareTo(other.qualifier);
                if (out != 0) {
                    return out;
                }
            }
            return this.build - other.build;
        }

        public int hashCode() {
            int hash = this.build << 24 | this.incremental << 16 | this.minor << 8 | this.major;
            return this.qualifier == null ? hash : hash ^ this.qualifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Version)) {
                return false;
            }
            Version other = (Version)obj;
            return this.major == other.major && this.minor == other.minor && this.incremental == other.incremental && this.build == other.build && (this.qualifier == null && other.qualifier == null || this.qualifier.equals(other.qualifier));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(String.valueOf(this.major));
            sb.append('.').append(String.valueOf(this.minor)).append('.').append(String.valueOf(this.incremental));
            if (this.qualifier != null) {
                sb.append('-').append(this.qualifier);
            }
            if (this.build != 0) {
                sb.append('-').append(String.valueOf(this.build));
            }
            return sb.toString();
        }
    }
}

