/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * REPLPanel.java
 *
 * Created on Nov 2, 2009, 9:21:05 PM
 */

package edu.buffalo.cse.sneps3.gui;

import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

import com.franz.jlinker.*;
import java.awt.BorderLayout;


/**
 *
 * @author Dan Schlegel
 */
public class REPLPanel extends javax.swing.JPanel {

    public JTextArea output;
 
    //public REPLFrame parent;
    /** Creates new form REPLPanel */
    public REPLPanel() {
        initComponents();
        this.setLayout(new BorderLayout());
        add(jSplitPane1, BorderLayout.CENTER);
        output = jTextArea1;
        jSplitPane1.setResizeWeight(1.0);
        jSplitPane1.setDividerSize(0);
        jSplitPane1.setDividerLocation(this.getHeight() - 15);
    }

       protected void appendText(String strText) {
                final String appendText = strText;
                // The text must be appended in a thread to avoid a bug where the test area won't
                // auto scroll otherwise.
                SwingUtilities.invokeLater( new Runnable()
                {
                        public void run()
                        {
                                jTextArea1.append(appendText);
                        }
                });
        }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTextField1KeyPressed(evt);
            }
        });
        jSplitPane1.setBottomComponent(jTextField1);

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        jSplitPane1.setLeftComponent(jScrollPane1);

        /*javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.Alignment.TRAILING, 
javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );*/
    }// </editor-fold>

    public String makeLispCall(String text) {
        String returnVal = "";

        appendText(": " + text + "\n");
        //LispCall eval_query = new LispCall("javatools.jlinker:eval-from-string");
        LispCall eval_query = new LispCall("sneps3::repl-output");
        eval_query.addArg(text);

        //eval_query.setStyle(LispCall.STYLE_IGNORE);
        try {
            if (eval_query.call() < 0) {
                System.out.println("Umm, that didn't go well!");
                return null;
            }
            //System.out.println("Executed: " + text);
            int count = eval_query.query();
            for (int i = 0; i < count; i++) {
                if(GUI2.DEBUG) System.out.println(LispCall.nameOfType(eval_query.typeOf(i)));
                returnVal = eval_query.stringValue();
                appendText(eval_query.stringValue() + '\n');
            }
            //System.out.println(eval_query.stringValue());
        } catch (JavaLinkDist.JLinkerException ex) {
            //ex.printStackTrace();
            appendText(ex.getMessage() + '\n');
        } catch (Exception ex) {
            appendText(ex.getMessage() + '\n');
        }

        eval_query.close();
        eval_query.reset();

        return returnVal;
    }

    private void jTextField1KeyPressed(java.awt.event.KeyEvent evt) {
                if(evt.getKeyCode() == KeyEvent.VK_ENTER){
                        String text = jTextField1.getText();

                        //appendText(": " + text + "\n");
                        makeLispCall(text);

                        jTextField1.setText("");
                }

    }


    // Variables declaration - do not modify
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration

}

