package sneps3.classes;

/**
 * Public view of cables, allows direct use without modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface Cable{
  /**
   * Relation accessor.
   *
   * @return the relation type this cable can point to
   */
  Relation getRelation();


  /**
   * NodeSet accessor.
   *
   * @return the set of nodes this cable points to
   */
  NodeSet getNodeSet();


  /**
   * Root accessor.
   *
   * @return the root node of this cable
   */
  Node getRoot();


  /**
   * Equality operator.  Two cables that share the same relation, root node,
   * and have equal node sets are considered equal.
   *
   * @param rhs the cable to be compared with this instance
   * @return <code>true</code> if <code>rhs</code> and this instance both have
   *  relations and root nodes that are equal and their node sets are equal.
   */
  boolean equals(final Cable rhs);


  /**
   * Checks to see if this cable is adjustable to the given cable.
   * Used for wire-based inference.
   *
   * @param c the cable to be checked against the current Cable.
   * @return <code>true</code> if the current cable can be adjusted to rhs,
   *  <code>false</code> otherwise.
   */
  boolean isAdjustableTo(final Cable rhs);


  /**
   * Creates an indented string representation for the cable.
   *
   * @param level the depth of indentation to be added to the string
   * @return a String representation of the cable
   */
  String toString(final int level);


  /**
   * Default String representation method.  Just calls toString(0).
   *
   * @return a String representation for the Cable
   */
  String toString();
    

  /** 
   * Method to clone this instance.  This is provided as a reminder that all
   * SNePS objects should be public cloneable (and implementations should
   * implement the cloneable interface).<P>
   * Note: The new cable will share the same relation and node set instances
   * as this one.
   *
   * @return a new copy of this instance
   */
  Object clone();
    
}
