package sneps3.classes;

/**
 * Allows public access to a cable set without allowing modification.
 * 
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface CableSet{

  /**
   * Finds the cable with the given relation type, if one exists in the set.
   *
   * @param rel the relation of the desired cable.
   * @return the found Cable, <code>null</code> if no such Cable.
   */
  Cable findCable(Relation r);


  /**
   * Returns an iterator for this set.
   *
   * @return an iterator over the cables in this set
   */
  java.util.Iterator iterator();


  /**
   * Creates an indented string representation for this cable set.
   *
   * @param level the depth of indentation to be added to the string
   * @return a string representation of the cable set
   */
  String toString(int level);


  /**
   * Default string representation method.  Just calls toString(0).
   *
   * @return a string representation for the cable set.
   */
  String toString();

}
