package sneps3.classes;


public interface CaseFrame{
  /**
   * Accessor for the semantic class of this case frame.
   *
   * @return the semantic class for this case frame
   */
  SemanticClass getSemanticClass();
  
  
  /**
   * Accessor for the set of relations in this case frame.
   *
   * @return the set of relations for this case frame
   */
  RelationSet getRelations();
  
  
  /**
   * Accessor for set of all nodes that have this case frame.
   *
   * @return set of nodes that have this case frame
   */
  NodeSet getNodes();


  /**
   * Checks for case frames this one can adjust to.
   * Returns true if and only if all of the following hold:<p>
   * 1: The semantic class of this instance and the rhs case 
   * frame are equal<p>
   * 2: Every relation that is in this instance but not in rhs is reducable
   * with limit=0<p>
   * 3: Every Relation that is in rhs but not in this is expandable with 
   * limit=0<p>
   *
   * @param rhs the CaseFrame to compared for reducibility.
   * @return true if the above cases hold, false otherwise
   */
  boolean isAdjustableTo(final CaseFrame rhs);
  

  /**
   * Checks to see if the cable set could be an instance of this case frame.
   *
   * @param cs is the cable set to check against this.
   * @return <code>true</code> if cableset other is an instance of this
   *  instance, returns <code>false</code> otherwise.
   */
  boolean checkIfInstance(final CableSet cs);
  

  String getHash();

  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();


}
