package sneps3.classes;

/**
 * Public access to case frame sets, does not permit modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface CaseFrameSet{
  /**
   * Searches this set for a case frame.
   *
   * @param n the case frame to look for
   * @return <code>true</code> if n is in this set, <code>false</code>
   *  otherwise
   */
  boolean contains(final CaseFrame n);

  /**
   * Check if there are no case frames in the set.
   *
   * @return <code>true</code> if there are no case frames in the set,
   *  <code>false</code> otherwise
   */
  boolean isEmpty();

  /**
   * Gets the size of this set.
   * 
   * @return the number of case frames in this set
   */
  int size();

  /**
   * Gets an iterator for the case frames of this set.
   *
   * @return an iterator over the case frames in this set
   */
  java.util.Iterator iterator();

  Object[] toArray();

  /**
   * A simple indented output method.
   *
   * @param level the depth of indentation that should be used
   * @return a string representing this set
   */
  String toString(final int level);

  /**
   * The default output method.
   *
   * @return the value of <code>toString(0)</code>
   */
  String toString();

}
