package sneps3.classes;

/**
 * Public access to contexts, does not permit modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface Context{

  /**
   * Gets the name of the Context.
   *
   * @return the name of the Context.
   */
  String getName();

  /**
   * Finds all nodes asserted in the context.
   *
   * @return the set of nodes asserted in the context
   */
  NodeSet getNodes();

  /**
   * Simple equality, only needs to check name equality.
   *
   * @param rhs the context to compare with this instance
   * @return <code>true</code> if this instance and <code>rhs</code> have
   *  the same name, <code>false</code>otherwise
   */
  boolean equals(final Context rhs);

  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);

  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();

  /**
   * Check consistency of the context.
   *
   * @return <code>true</code> if the context is known to be inconsistent,
   * <code>false</code> otherwise.
   */
  boolean isKnownInconsis();

}
