package sneps3.classes;

/**
 * Public access to contexts, does not permit modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface ContextSet{

  /**
   * A method to copy this set to a new instance.
   * Collections should generally declare their clone method public.
   *
   * @return the new instance of this set
   */
  Object clone();

  /**
   * Checks this set for the context.
   *
   * @param n the context to look for
   * @return <code>true</code> if <code>n</code> is in this set,
   *  <code>false</code> otherwise.
   */
  boolean contains(final String name);

  /**
   * Check this set for any classes.
   *
   * @return <code>true</code> if there are no relations in this set,
   *  <code>false</code> otherwise.
   */
  boolean isEmpty();

  /**
   * Get the size of the set.
   *
   * @return the number of contexts in this set.
   */
  int size();

  /**
   * Get an iterator for this set.
   *
   * @return an iterator over the contexts of this set.
   */
  java.util.Iterator iterator();

  /**
   * Creates an array of the objects in the set.
   *
   * @return an array of all the contexts
   */
  Object[] toArray();


  /**
   * Creates an indented text form for this set.
   *
   * @param level the depth of indentation this object should be displayed
   * @return a string representation of this object
   */
  String toString(final int level);
  
  /**
   * Simple output method.  Just calls toString(0).
   *
   * @return a string representation of this object
   */
  String toString();

}
