package sneps3.classes;


/**
 * Public access to molecular nodes, does not permit modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface MolecularNode extends Node{
  /**
   * Accessor for the cable set of the node.
   *
   * @return the set of cables coming out of the node
   */
  CableSet getCableSet();

  /**
   * Accessor for case frame of the node
   *
   * @return the caseframe for this node
   */
  CaseFrame getCaseFrame();

  /**
   * Check for Adjustability. 
   *
   * @return <code>true if this node is adjustable to mn, <code>false</code>
   * otherwise
   */
  boolean isAdjustableTo(final MolecularNode mn);  
}
