package sneps3.classes;

/**
 * Public interface for nodes.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface Node{
  /**
   * Name accessor.
   *
   * @return the name of the node
   */
  String getName();


  /**
   * Semantic class accessor.
   *
   * @return the semantic class of the node
   */
  SemanticClass getSemanticClass();


  /**
   * Accessor for contexts this node is asserted in.  Any node besides
   * a propsition node should return a null for this.
   *
   * @return set of contexts this node is asserted in
   */
  ContextSet isAssertedIn();


  /**
   * Returns the default name for this node.
   *
   * @return the string consisting of the first character of this instance's
   *  semantic class' name followed by its unique identification number.
   */
  String defaultName();


  /**
   * Checks for equality between this instance and <code>rhs</code>.
   * It assumes that no two nodes have the same name.
   *
   * @param rhs the semantic class to be compared with this instance
   * @return <code>true</code> if both objects have the same name,
   *  <code>false</code> otherwise
   */
  boolean equals(final Node rhs);


  /**
   * Provides an ordering among nodes for efficient set operations.
   * Only requirements are that it be non-reflexive (returns false for
   * <code>x.lt(x)</code>), non-reflective (exactly one of {x.lt(y), y.lt(x)}
   * is true if x!=y) and transitive (if x.lt(y) and y.lt(z) then x.lt(z)).
   * @param rhs the object to be compared to this instance.
   * @return <code>true</code> if this instance is "less than"
   *  <code>rhs</code>, false otherwise.
   */
  boolean lt(final Node rhs);


  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();

}
