package sneps3.classes;

/**
 * Public interface for node sets.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface NodeSet{
  /**
   * Get the size of this set.
   *
   * @return the number of nodes in this set
   */
  int size();


  /**
   * Check this set for any nodes.
   *
   * @return <code>true</code> if there are no nodes in this set,
   *  <code>false</code> otherwise.
   */
  boolean isEmpty();


  /**
   * Checks this set for the node.
   *
   * @param node the node to look for
   * @return <code>true</code> if <code>node</code> is in this set,
   *  <code>false</code> otherwise.
   */
  boolean contains(final Node node);

  /**
   * Determines if <code>ns</code> is a subset of this set.
   * Used by the method S3_Network.FindWholeNode.
   *
   * @param ns the node set to be checked
   * @return true if all the nodes in <code>ns</code> are also in this set
   */
  boolean contains(final NodeSet ns);
  /**
   * Checks that <code>ns</code> is the same as this set.
   * Used by the method S3_Network.FindWholeNode.
   *
   * @param ns the node set to be checked
   * @return true if <code>ns</code> has exactly the same nodes as this set
   */
  boolean equals(final NodeSet ns);

  /**
   * Checks the consistency of the set.
   *
   * @return <code>true</code> if the set is not known to be inconsistent,
   *  <code>false</code> otherwise.
   */
  boolean isKnownInconsis();


  /**
   * A method to copy this set to a new instance.
   * Collections should generally declare their clone method public.
   *
   * @return the new instance of this set
   */
  Object clone();


  /**
   * Returns an iterator for this set.
   *
   * @return an iterator over the nodes in this set
   */
  java.util.Iterator iterator();

  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);

  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();

}
