package sneps3.classes;

/**
 * Public interface for relations.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface Relation{

  /** Constant for an adjust value of reduce. */
  public static final int REDUCE=-1;

  /** Constant for an adjust value of none. */
  public static final int NONE=0;

  /** Constant for an adjust value of expand. */
  public static final int EXPAND=1;


  /**
   * Name accessor.
   *
   * @return the name of this instance
   */
  String getName();


  /**
   * Type accessor.
   *
   * @return the type of this instance
   */
  SemanticClass getType();


  /**
   * Adjust accessor.
   *
   * @return the adjust of this instance
   */
  int getAdjust();


  /**
   * Limit accessor.
   *
   * @return the limit of this instance
   */
  int getLimit();


  /**
   * Path accessor.
   *
   * @return the path associated with this instance
   */
  Path getPath();


  /**
   * Accessor for all nodes at the end of a cable with this relation.
   *
   * @return the set of nodes that cables of this relation point to
   */
  NodeSet getNodes();


  /**
   * Accessor for case frames containing this relation.
   *
   * @return set of case frames that this relation is a part of
   */
  CaseFrameSet getCaseFrames();

  PathSet getPaths();

  /**
   * Equality operator.  May use the fact no two relations have the same name.
   *
   * @param rhs Relation to be compared with the current Relation.
   * @return <code>true</code> if <code>rhs</code> and this instance have the
   *  same name, <code>false</code> otherwise
   */
  boolean equals(final Relation rhs);

  /**
   * Provides an ordering among semantic classes for efficient set operations.
   * Only requirements are that it be non-reflexive (returns false for
   * <code>x.lt(x)</code>), non-reflective (exactly one of {x.lt(y), y.lt(x)}
   * is true if x!=y) and transitive (if x.lt(y) and y.lt(z) then x.lt(z)).
   *
   * @param rhs the object to be compared to this instance.
   * @return <code>true</code> if this instance is "less than"
   *  <code>rhs</code>, false otherwise.
  boolean lt(final Relation rhs);


  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();


}
