package sneps3.classes;

/**
 * Public interface for relation sets.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface RelationSet{
  /**
   * Get the size of this set.
   *
   * @return the number of relations in this set
   */
  int size();


  /**
   * Check this set for any relations.
   *
   * @return <code>true</code> if there are no relations in this set,
   *  <code>false</code> otherwise.
   */
  boolean isEmpty();


  /**
   * Checks this set for the relation.
   *
   * @param relation the relation to look for
   * @return <code>true</code> if <code>relation</code> is in this set,
   *  <code>false</code> otherwise.
   */
  boolean contains(final String name);


  Relation get(final String name);


  RelationSet minus(final RelationSet rhs);

  /**
   * A method to copy this set to a new instance.
   * Collections should generally declare their clone method public.
   *
   * @return the new instance of this set
   */
  Object clone();


  /**
   * Returns an iterator for this set.
   *
   * @return an iterator over the relations in this set
   */
  java.util.Iterator iterator();

  
  /**
   * Creates an array of the objects in the set.
   *
   * @return an array of all the relations
   */
  Object[] toArray();


  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();

}
