package sneps3.classes;

/**
 * Public interface for semantic classes.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface SemanticClass{

  /**
   * Searches ancestry of the this instance for <code>ancestor</code>.
   *
   * @param ancestor the semantic class to be searched for
   * @return <code>true</code> if <code>ancestor</code> is an ancester of or
   *  equal to this instance, <code>false</code> otherwise
   */
  boolean isa(final SemanticClass ancestor);


  /**
   * Name accessor.
   *
   * @return the name of this instance
   */
  String getName();


  /**
   * Parent accessor.
   *
   * @return the parent of this instance
   */
  SemanticClass getParent();
    

  /**
   * Accessor for set of nodes having this semantic class.
   *
   * @return set of nodes with this semantic class.
   */
  NodeSet getNodes();


  /**
   * Accessor for set of relations using this semantic class.
   *
   * @return set of relations with this semantic class.
   */
  RelationSet getRelations();


  /**
   * Accessor for set of case frames using this semantic class.
   * Does not count case frames with relations using this semantic class.
   *
   * @return set of case frames that have this semantic class.
   */
  CaseFrameSet getCaseFrames();


  /**
   * Gets the color for this semantic class.
   *
   * @return the color nodes of this class should be displayed in
   */
  java.awt.Color getColor();


  int getDepth();

  /**
   * Gets the children of this semantic class.
   *
   * @return the immidate descendents of this semantic class
   */
  SemanticClassSet getChildren();


  /**
   * Returns the root of the heirarchy tree.
   *
   * @return the oldest ancestor of this semantic class
   */
  SemanticClass getRoot();

  /**
   * Checks for equality between this instance and <code>rhs</code>.
   * It assumes that no two semantic classes have the same name.
   *
   * @param rhs the semantic class to be compared with this instance
   * @return <code>true</code> if both objects have the same name,
   *  <code>false</code> otherwise
   */
  boolean equals(final SemanticClass rhs);
  

  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();


}
