package sneps3.classes;

/**
 * Public interface for semantic class sets.  Does not allow modification.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
public interface SemanticClassSet{
  /**
   * Get the size of this set.
   *
   * @return the number of semantic classes in this set
   */
  int size();


  /**
   * Check this set for any classes.
   *
   * @return <code>true</code> if there are no semantic classes in this set,
   *  <code>false</code> otherwise.
   */
  boolean isEmpty();


  /**
   * Checks this set for the semantic class.
   *
   * @param name the name of the semantic class being looked for
   * @return <code>true</code> if a node with that name is in this set,
   *  <code>false</code> otherwise.
   */
  boolean contains(final String name);

  
  /**
   * Looks for a semantic class of the given name.
   *
   * @param name the name of the semantic class being looked for
   * @return the found semantic class if it exists
   */
  SemanticClass get(final String name);


  /**
   * A method to copy this set to a new instance.
   * Collections should generally declare their clone method public.
   *
   * @return the new instance of this set
   */
  Object clone();


  /**
   * Returns an iterator for this set.
   *
   * @return an iterator over the semantic classes in this set
   */
  java.util.Iterator iterator();


  /**
   * Creates an array of the objects in the set.
   *
   * @return an array of all the semantic classes
   */
  Object[] toArray();


  /**
   * Gives a string of formatted output, indented to the given level.
   *
   * @param level indicates how deeply lines should be indented
   * @return a string representing this instance
   */
  String toString(final int level);


  /**
   * Gives a string of formatted output with no indentation.
   *
   * @return a string representing this instance
   */
  String toString();

}
