package sneps3.corecode;


/**
 * The public interface for cables.<P>
 * Cables connect nodes in a SNePS network, and indicate information about the
 * relations holding between those nodes.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface Cable extends sneps3.classes.Cable{


  /**
   * Relation mutator.
   * LOCKABLE
   *
   * @param rel the relation this instance should be set to have
   * @return <code>true</code> if this instance was set to have the new
   *  relation, <code>false</code> otherwise
   */
  boolean setRelation(final Relation r);


  /**
   * NodeSet mutator.
   * LOCKABLE
   *
   * @param ns the NodeSet the Cable should point to
   * @return <code>true</code> if this cable's NodeSet was sucessfully set,
   *  <code>false</code> otherwise
   */
  boolean setNodeSet(final NodeSet ns);


  /**
   * Root mutator.
   * LOCKABLE
   *
   * @param n the new root node for the cable
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setRoot(final Node n);


  /** 
   * Merge this cable and another cable, creating a new one.  The new cable
   * will have no duplicate wires, and its root node will be the same as
   * this instance.
   *
   * @param c the cable to be twined with the current cable
   * @return the new cable resulting from combining this cable with c
   */
  Cable twine(final Cable c);


  /**
   * Locks object against mutation.
   *
   * @return the previous status of the lock
   */
  boolean lock();  

}
