package sneps3.corecode;


/**
 * A CableSet is a collection of Cables.  Semanticly, these Cables are
 * unordered.  Additionally, no two Cables in a CableSet have the same
 * Relation.(except in special cases, like an up-cable-set)<P>
 * Most SNePS 3 object classes have associated sets to provide a common
 * interface, yet allow the flexibility of creating newer, optimized
 * implementations.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface CableSet extends sneps3.classes.CableSet{


  /**
   * Adds a cable to the set.  Must check to be sure a cable with the same
   * relation is not already in the set.
   *
   * @param c the cable to be added to the set
   * @return <code>true</code> if the cable was added <code>false</code>
   *  otherwise
   */
  boolean add(final Cable c);


  /**
   * Removes a Cable from the set.
   *
   * @param c the cable to be removed
   * @return <code>true</code> if the cable was removed, <code>false</code>
   *  otherwise
   */
  boolean remove(final Cable c);


  /**
   * Forces a cable into a set.  If a cable of the same relation already
   * exists in the set, then it twines them together.
   *
   * @param c the cable to be added to the set
   * @return the actual added cable
   */
  Cable forceCable(final Cable c);


  /**
   * Method to clone this instance.
   * Note: The new set will share the cable instances of this one.
   *
   * @return a new copy of this instance.
   */
  public Object clone();

}
