package sneps3.corecode;


/**
 * Each proposition node must have a case frame of relations it allows.
 * A case frame is a pair, <code>(c,r)</code>, where <code>c</code> is
 * a SNePS semantic class and <code>r</code> is a set of relations. 
 * Informally, <code>c</code> is the class of all nodes that have the
 * given set of arcs emanating from them.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface CaseFrame extends sneps3.classes.CaseFrame{

        
  /**
   * Mutator for the semantic class.
   *
   * @param semClass the new SemanticClass for the CaseFrame.
   * @return true if the new SemanticClass was set, false otherwise.
   */
  boolean setSemanticClass(final SemanticClass sc);


  /**
   * Mutator for the relations in this CaseFrame.
   *
   * @param rs the RelationSet the CaseFrame will have.
   * @return true if the new RelationSet is assigned to the CaseFrame, false
   *  otherwise.
   */
  boolean setRelationSet(final RelationSet rs);


  /**
   * Mutator for nodes.
   *
   * @param ns the new node set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setNodes(final NodeSet ns);

  boolean setHash();

  /**
   * Locks object against mutation.
   *
   * @return the previous status of the lock.
   */
  boolean lock();  
  
}
