package sneps3.corecode;

/**
 * Interface for a set of case frames.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface CaseFrameSet extends sneps3.classes.CaseFrameSet{

  /**
   * Add a case frame to this set.
   *
   * @param n the case frame to be added
   * @return <code>true</code> if the case frame was added,
   *  <code>false</code> otherwise
   */
  boolean add(final sneps3.classes.CaseFrame n);

  /**
   * Remove all case frames from this set.
   */
  void clear();

  /**
   * Remove a case frame from this set.
   *
   * @param n the case frame to be removed
   * @return <code>true</code> if the case frame was removed,
   *  <code>false</code> otherwise
   */
  CaseFrame remove(final sneps3.classes.RelationSet rs);

}
