package sneps3.corecode;

/**
 * This class represents the INTENSIONAL contexts of SNePS.
 * A context is a set of nodes.  These nodes are said to be asserted in
 * that context.
 */
interface Context extends sneps3.classes.Context{

  /**
   * Adds a node if not already present.  Returns true if the node was
   * added, false otherwise.
   *
   * @param n the node to be added.
   * @return true if successful, false otherwise
   */
  boolean addNode(final sneps3.classes.Node n);

  /**
   * Removes a node if it is present.  Returns true if the node was
   * removed, false otherwise.
   *
   * @param n the node to be removed.
   * @return true if successful, false otherwise
   */
  boolean removeNode(final sneps3.classes.Node n);

  /**
   * Sets the name of the Context.
   *
   * @param n the new name of the context
   * @return true if successful, false otherwise
   */
  boolean setName(final String n);

  boolean setHyps(NodeSet ns);
  boolean setDers(NodeSet ns);

}
