package sneps3.corecode;

import java.util.*;

/**
 * This class provides a place to store system default settings.  It also
 * contains information about the implementation it is associated with.<P>
 *
 * SNePS version 3.0<BR>
 * Written by the SNePS 3 Java Programming Team:<BR>
 * Robert Church<BR>
 * Sijun Kang<BR>
 * Anthony Petre<BR>
 * John Santore<BR>
 * <P>
 * The Java version of SNePS 3 is seperated into several packages:<P>
 * <B>sneps3.mind</B><BR>
 * This package forms the "hub" that nearly every other package is
 * associated with in some way.  Classes in this package should be concerned
 * mainly with access, deciding which methods of its connectd components
 * should be available to other connected components.<P>
 * <B>sneps3.corecode</B><BR>
 * This package contains all the code for the basic SNePS objects.  Classes
 * here should be fairly friendly, providing lots of useful operations and
 * not throwing exceptions.<P>
 * <B>sneps3.snip</B><BR>
 * The SNePS Inference Package.  This package contains all the reasoning
 * components of SNePS.  Minds will generally give full access of its network
 * to SNIP components.<P>
 * <B>sneps3.snebr</B><BR>
 * The SNePS Belief Revision package.  This package contains code for doing
 * belief revision.  Like SNIP, SNeBR will frequently be granted full access to * a Mind's network. (Note: SNeBR is not currently implemented).<P>
 * <B>sneps3.snere</B><BR>
 * The SNePS Rational Engine package.  This package contains code for
 * acting. (Note: not currently implemented, and may eventually be included in
 * sneps3.spine)<P>
 * <B>sneps3.world</B><BR>
 * The SNePS world package.  This package contains code to support a
 * SNePS mind's access to the world.  GUI's, SNePSUL-type command interpreters,
 * foveal vision systems, hardware drivers, and so forth would be put in
 * this package.  It is generally assumed code in this section will interact
 * directly with some piece of (possibly simulated) hardware and code within
 * the spine package (though the spine package code may simply pass a command
 * on to the mind package for a simple interface).<P>
 * <B>sneps3.spine</B><BR>
 * The SNePS Perceptory Interface and Neural Effectors package.  This package
 * is meant to provide an area for "layering" between a SNePS Mind and the 
 * "real-world" (which may be simulated).  Things like parsers (SNePSUL,
 * SNePSLOG, LKB, etc), signal processors, speech generators, motor controls,
 * and so forth should be placed in this package.  It is generally assumed
 * that code in this package will only associate with methods and objects in
 * the interface and mind packages.<P>
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */

public abstract class Defaults{

  /** Indent string for indented output methods. */
  public static final String INDENT = "  ";

  /** Reserved seperation character */
  public static final char SEPERATION_CHARACTER = '|';

  /** Indication of whether the system will be case-sensitive or not. */
  public static final boolean CASE_SENSITIVE = false;

  /** Indicates default adjustibility of relations when not declared.
   *  -1 Reduce
   *   0 None
   *   1 Expand
   */
  public static final int ADJUST_MODE = -1;

  /** Default factory for the current version of SNePS */
  public static final SnepsFactory FACTORY = new S3_SnepsFactory();

  /** The default context */
  public static final Context DEFAULT_CT;

  /** Default semantic classes */
  public static final SemanticClassSet SEMANTIC_CLASSES;

  /** Default relations */
  public static final RelationSet RELATIONS;

  /** Default case frames */
  public static final CaseFrameSet CASE_FRAMES;

  /** Default contexts */
  public static final ContextSet CONTEXTS;

  static {

    /* Initialize the default semantic classes */
    SEMANTIC_CLASSES = FACTORY.createSemanticClassSet();
    SemanticClass entity = FACTORY.createSemanticClass("entity", null);
    SemanticClass proposition =
      FACTORY.createSemanticClass("proposition",entity,java.awt.Color.red);
    SemanticClass constraint =
      FACTORY.createSemanticClass("constraint", entity, java.awt.Color.gray);
    SEMANTIC_CLASSES.add(entity);
    SEMANTIC_CLASSES.add(FACTORY.createSemanticClass("individual", entity,
        java.awt.Color.blue));
    SEMANTIC_CLASSES.add(FACTORY.createSemanticClass("act", entity,
        java.awt.Color.yellow));
    SEMANTIC_CLASSES.add(proposition);
    SEMANTIC_CLASSES.add(FACTORY.createSemanticClass("simple proposition",
        proposition, java.awt.Color.pink));
    SEMANTIC_CLASSES.add(FACTORY.createSemanticClass("generic proposition",
        proposition, java.awt.Color.orange));
    SEMANTIC_CLASSES.add(FACTORY.createSemanticClass("rule", proposition, 
        java.awt.Color.magenta));
    SEMANTIC_CLASSES.add(constraint);
    
    /* initialize default relations */
    RELATIONS = FACTORY.createRelationSet();
    Relation ant = FACTORY.createRelation("ant",proposition,Relation.EXPAND,1);
    Relation cq = FACTORY.createRelation("cq",proposition,Relation.REDUCE,1);
    Relation restrict = FACTORY.createRelation("restrict", proposition,
        Relation.NONE, -1);
    Relation all = FACTORY.createRelation("all",entity,Relation.NONE,-1);
		Relation some = FACTORY.createRelation("some",entity,Relation.NONE,-1);
		Relation depends = FACTORY.createRelation("depends", constraint,
        Relation.NONE, -1);
    Relation vcomp = FACTORY.createRelation("vcomp", constraint,
        Relation.NONE, -1);
    Relation pcomp = FACTORY.createRelation("pcomp", proposition,
        Relation.NONE, -1);
    Relation arg = FACTORY.createRelation("arg",proposition,Relation.NONE,-1);
    RELATIONS.add(ant);
    RELATIONS.add(cq);
    RELATIONS.add(restrict);
    RELATIONS.add(depends);
    RELATIONS.add(all);
    RELATIONS.add(some);
    RELATIONS.add(vcomp);
    RELATIONS.add(pcomp);
    RELATIONS.add(arg);
    
    /* initialize default case frames */
    CASE_FRAMES = FACTORY.createCaseFrameSet();
    
    RelationSet antCq = FACTORY.createRelationSet();
    antCq.add(ant);
    antCq.add(cq);
    CASE_FRAMES.add(FACTORY.createCaseFrame(proposition, antCq));
    
    RelationSet restVarA = FACTORY.createRelationSet();
    restVarA.add(restrict);
    restVarA.add(all);
    restVarA.add(depends);
    CASE_FRAMES.add(FACTORY.createCaseFrame(constraint, restVarA));
    
    RelationSet restVarB = FACTORY.createRelationSet();
    restVarB.add(restrict);
    restVarB.add(some);
    restVarB.add(depends);
    CASE_FRAMES.add(FACTORY.createCaseFrame(constraint, restVarB));
    
    RelationSet vcompPcomp = FACTORY.createRelationSet();
    vcompPcomp.add(vcomp);
    vcompPcomp.add(pcomp);
    CASE_FRAMES.add(FACTORY.createCaseFrame(proposition, vcompPcomp));
    
    RelationSet argrs = FACTORY.createRelationSet();
    argrs.add(arg);
    CASE_FRAMES.add(FACTORY.createCaseFrame(proposition, argrs));

    /* initialize default contexts */
    DEFAULT_CT = FACTORY.createContext("DEFAULT_CT");
    CONTEXTS = FACTORY.createContextSet();
    CONTEXTS.add(DEFAULT_CT);

    /* initialize default network */
    
  }
  
  

}
