package sneps3.corecode;


/**
 * All things that a generic SNePS node should be able to do.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface Node extends sneps3.classes.Node{


  /**
   * Test for deep equality with another node
   *
   * @param rhs the node to be compared with this instance
   * @return <code>true</code> if <code>this.equals(rhs)</code> and
   *  <code>rhs</code> has the same semantic class as this instance,
   *  <code>false</code> otherwise
   */
  boolean deepEquals(final sneps3.classes.Node rhs);


  /**
   * Name mutator.
   *
   * @param name the string that is to be the new name of the instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setName(final String name);


  /**
   * Semantic class mutator.
   *
   * @param semClass the new semantic class for this instance to have.
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setSemanticClass(final SemanticClass semClass);


  boolean setSlots(Object slot1, Object slot2, Object slot3);

  /**
   * Locks object against mutation.
   *
   * @return a boolean representing the previous status of the lock
   */
  boolean lock();

}
