package sneps3.corecode;


/**
 * Interface for sets of nodes.
 * Set interfaces are created in SNePS 3 to provide provide the power of
 * control over how costly set operations are done, while hiding such
 * implementation details from higher levels.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface NodeSet extends sneps3.classes.NodeSet{


  /**
   * Add a node to this set.
   *
   * @param node the node to be added
   * @return <code>true</code> if the node was added,
   *  <code>false</code> otherwise.
   */
  boolean add(final sneps3.classes.Node node);


  /**
   * Remove a node from this set.
   *
   * @param node the node to be removed
   * @return <code>true</code> if the node was removed,
   *  <code>false</code> otherwise.
   */
  boolean remove(final sneps3.classes.Node node);


  /**
   * Remove all nodes from this set.
   */
  void clear();


  /**
   * Set the consistency value of the set.
   *
   * @param value the new consistency value
   * @return the previous consistency value
   */
  boolean setConsistent(final boolean value);


}
