
package sneps3.corecode;

interface Path extends sneps3.classes.Path{

  /**
   *Output to aid in debugging
   *@param level is the number of spaces for indenting (so I am told)
   */
  String toString(int level);

  /**
   *Output to aid in debugging
   */
  String toString();

  //is this the way I want to do these? should they be static?
  public Path converse(Path cpath);
  public Path compose(Path first, Path rest, boolean asserted_node);
  public Path kstar (Path kpath);
  public Path kplus (Path kpath);
  public Path or (Path first, Path second);
  public Path and (Path first, Path second);
  public Path not (Path negedPath);
  public Path relative_complement(Path first, Path second);
  public Path irreflexive_restrict (Path rPath);
  public Path exception(Path first, Path second);
  public Path domain_restrict (Path rpath, Node rnode, Path path2);
  public Path range_restrict(Path path1, Path rpath, Node rnode);
  
  
  public boolean isConverse();
  /**
   *Integer values for the types of Paths
   */
  public static final int UNIT_PATH = 0;
  public static final int COMPLEX_PATH = 1;
  public static final int KSTAR_PATH = 2;
  public static final int KPLUS_PATH = 3;
  public static final int OR_PATH = 4;
  public static final int AND_PATH = 5;
  public static final int NOT_PATH = 6;
  public static final int REL_COMP_PATH = 7;
  public static final int IRREFL_REST_PATH = 8;
  public static final int EXCEPT_PATH = 9;
  public static final int DOMAIN_RESTR_PATH = 10;
  public static final int RANGE_RESTR_PATH = 11;
  
	
}
