package sneps3.corecode;


/**
 * The public interface for relations.
 * A SNePS 3 relation is a four-tuple, <name, type, adjust, limit><P>
 * name - A symbolic name of the relation.  No two relations may have the same
 *        name.<BR>
 * type - the SNePS semantic class of the nodes in the range of this relation.
 * <BR>
 * adjust - For wire-based inference.  May not be used in the future.<BR>
 * limit - Minimal limit for wire-based inference.<P>
 * A path can be associated with a relation.
 *
 * @author SNePS 3 Java Programming Team
 * @version 3.0
 */
interface Relation extends sneps3.classes.Relation{


  /**
   * Name mutator.
   *
   * @param name the string to be the new name of this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setName(final String name);


  /**
   * Type mutator.
   *
   * @param type the new SemanticClass type for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setType(final SemanticClass type);


  /**
   * Adjust mutator.
   *
   * @param value the new adjust value for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setAdjust(final int value);


  /**
   * Limit mutator.
   *
   * @param limit the new limit for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setLimit(final int limit);


  /**
   * Path mutator.
   *
   * @param path the new path for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setPath(final Path path);

  
  /**
   * Nodes mutator.
   *
   * @param ns the new node set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setNodes(final NodeSet ns);

  boolean setPaths(final PathSet ps);

  /**
   * Case frames mutator.
   *
   * @param cfs the new case frame set for this instance
   * @return <code>true</code> if the new value was set, <code>false</code>
   *  otherwise
   */
  boolean setCaseFrames(final CaseFrameSet cfs);


  /**
   * Locks object against mutation.
   *
   * @return a boolean representing the previous status of the lock
   */
  boolean lock();

}
